/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.DividaTributo;
import br.com.elotech.tributos.domain.DividaTributoPK;
import br.com.elotech.tributos.domain.Tributo;
import br.com.elotech.tributos.repository.DividaTributoRepository;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class DividaTributoService
extends CrudService<DividaTributo, DividaTributoPK> {
    private final DividaTributoRepository dividaTributoRepository;

    public DividaTributoService(DividaTributoRepository dividaTributoRepository) {
        this.dividaTributoRepository = dividaTributoRepository;
    }

    public Page<Tributo> findTributosByDividaIdAndRsql(Long id, String search, Pageable pageable) {
        return this.findByDividaIdAndRsql(id, search, pageable).map(DividaTributo::getTributo);
    }

    public Page<DividaTributo> findByDividaIdAndRsql(Long id, String search, Pageable pageable) {
        String finalRsql = String.format("divida.id == %d %s", id, StringUtils.isBlank((String)search) ? "" : "and (" + search + ")");
        return this.findByRsql(finalRsql, pageable);
    }

    public List<DividaTributo> findAllByDivida(Long idDivida) {
        List result = this.dividaTributoRepository.findAllByDividaIdAndReceitaSemMovimentoFalse(idDivida);
        result.sort(Comparator.comparing(DividaTributo::getOrdem, Comparator.nullsLast(Comparator.naturalOrder())));
        return result;
    }
}

