/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.tributos.domain.FormaPagamento;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.dto.DebitoEmAbertoDTO;
import br.com.elotech.tributos.dto.DebitosEmAbertoComTotalizadorDTO;
import br.com.elotech.tributos.dto.ExtratoDebitoDTO;
import br.com.elotech.tributos.dto.FiltroDebitoPorContribuinteDTO;
import br.com.elotech.tributos.dto.FiltroExtratoDebitoDTO;
import br.com.elotech.tributos.dto.acrescimo.CalculaAcrescimoBaseDTO;
import br.com.elotech.tributos.repository.DebitoEmAbertoRepository;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.FormaPagamentoService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.acrescimo.calculo.CalculoAcrescimoService;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class DebitoEmAbertoService {
    private final DebitoEmAbertoRepository debitoEmAbertoRepository;
    private final FormaPagamentoService formaPagamentoService;
    private final CalculoAcrescimoService calculoAcrescimoService;
    private final ParametroGeralService parametroGeralService;
    private final ContextService contextService;

    public List<DebitoEmAbertoDTO> loadDebitoEmAberto(String filtro, Boolean geraBoletoSomenteConstituidos) {
        return this.debitoEmAbertoRepository.loadDebitoEmAberto(filtro, geraBoletoSomenteConstituidos);
    }

    public List<ExtratoDebitoDTO> loadExtratoDebitosByIdCadastro(String filtro) {
        return this.debitoEmAbertoRepository.loadExtratoDebitosByFilter(filtro);
    }

    public List<ExtratoDebitoDTO> loadExtratoDebitosByFiltro(FiltroExtratoDebitoDTO filtro) {
        Boolean visualizaDebitosNaoConstituidos = this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.VISUALIZA_DEBITO_NAO_CONSTITUIDO);
        return this.debitoEmAbertoRepository.loadExtratoDebitosByFiltro(filtro, visualizaDebitosNaoConstituidos);
    }

    public DebitosEmAbertoComTotalizadorDTO loadDebitosAbertosAgrupados(String filtro, Boolean geraBoletoSomenteConstituidos) {
        List debitosEmAberto = this.loadDebitoEmAberto(filtro, geraBoletoSomenteConstituidos);
        return new DebitosEmAbertoComTotalizadorDTO(debitosEmAberto);
    }

    public List<DebitoEmAbertoDTO> loadDebitosContribuinte(Long idPessoa, FiltroDebitoPorContribuinteDTO filtro) {
        FormaPagamento formaPagamento = this.formaPagamentoService.findFormaPagamentoPadrao(Optional.empty());
        List debitos = this.debitoEmAbertoRepository.findDebitosPorContribuinte(this.contextService.getEntidadePrincipal(), this.contextService.getExercicioAtual(), formaPagamento, idPessoa, filtro);
        List debitosCalculados = this.calculoAcrescimoService.calculaAcrescimos(debitos, formaPagamento.getId());
        return CalculaAcrescimoBaseDTO.agruparPorParcela((List)debitosCalculados);
    }

    @Generated
    public DebitoEmAbertoService(DebitoEmAbertoRepository debitoEmAbertoRepository, FormaPagamentoService formaPagamentoService, CalculoAcrescimoService calculoAcrescimoService, ParametroGeralService parametroGeralService, ContextService contextService) {
        this.debitoEmAbertoRepository = debitoEmAbertoRepository;
        this.formaPagamentoService = formaPagamentoService;
        this.calculoAcrescimoService = calculoAcrescimoService;
        this.parametroGeralService = parametroGeralService;
        this.contextService = contextService;
    }
}

