/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.TipoCertidaoDebitos;
import br.com.elotech.tributos.domain.TipoDocumentoEnum;
import br.com.elotech.tributos.dto.DocumentoDTO;
import br.com.elotech.tributos.dto.DocumentoGenericoDTO;
import br.com.elotech.tributos.dto.RastreamentoCadastroDTO;
import br.com.elotech.tributos.service.DocumentoService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.RastreamentoService;
import java.util.Set;
import javax.validation.Valid;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class CertidaoDebitosService {
    private final RastreamentoService rastreamentoService;
    private final DocumentoService documentoService;
    private final ParametroGeralService parametroGeralService;

    public CertidaoDebitosService(RastreamentoService rastreamentoService, DocumentoService documentoService, ParametroGeralService parametroGeralService) {
        this.rastreamentoService = rastreamentoService;
        this.documentoService = documentoService;
        this.parametroGeralService = parametroGeralService;
    }

    public DocumentoDTO geraCertidaoPorContribuinte(@Valid DocumentoGenericoDTO documentoGenericoDTO) {
        documentoGenericoDTO.setPorCadastro(Boolean.FALSE);
        Set rastreamentoCadastroDTOS = this.rastreamentoService.porContribuinte(documentoGenericoDTO.getCodigoPessoa());
        documentoGenericoDTO.setSubTipo(this.getTipoCertidaoDebitos(rastreamentoCadastroDTOS, documentoGenericoDTO.getCertidaoEspecial()).getValue());
        return this.documentoService.gerar(documentoGenericoDTO, TipoDocumentoEnum.CERTIDAO_CONTRIBUINTE);
    }

    public DocumentoDTO geraCertidaoPorCadastro(@Valid DocumentoGenericoDTO documentoGenericoDTO) {
        Set rastreamentoCadastroDTOS = this.rastreamentoService.porCadastro(documentoGenericoDTO.getIdCadastro());
        documentoGenericoDTO.setSubTipo(this.getTipoCertidaoDebitos(rastreamentoCadastroDTOS, documentoGenericoDTO.getCertidaoEspecial()).getValue());
        return this.documentoService.gerar(documentoGenericoDTO, TipoDocumentoEnum.CERTIDAO_CADASTRO_MUNICIPAL);
    }

    private TipoCertidaoDebitos getTipoCertidaoDebitos(Set<RastreamentoCadastroDTO> rastreamentoCadastroDTOS, Boolean certidaoEspecial) {
        if (certidaoEspecial.booleanValue()) {
            return this.getTipoCertidaoDebitosByCertidaoCndQdoSemContrato();
        }
        return RastreamentoCadastroDTO.getTipoCertidaoDebitos(rastreamentoCadastroDTOS);
    }

    private TipoCertidaoDebitos getTipoCertidaoDebitosByCertidaoCndQdoSemContrato() {
        if (this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.CERTIDAO_CND_QDO_SEM_CONTRATO).booleanValue()) {
            return TipoCertidaoDebitos.NEGATIVA;
        }
        return TipoCertidaoDebitos.POSITIVA_EFEITO_NEGATIVA;
    }
}

