/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliarioAvaliacao;
import br.com.elotech.tributos.enums.Origem;
import br.com.elotech.tributos.repository.imobiliario.CadastroImobiliarioAvaliacaoRepository;
import br.com.elotech.tributos.service.CadastroGeralService;
import java.io.Serializable;
import java.time.LocalDate;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class CadastroImobiliarioAvaliacaoService
extends CrudService<CadastroImobiliarioAvaliacao, Long> {
    private final CadastroImobiliarioAvaliacaoRepository avaliacaoRepository;
    private final CadastroGeralService cadastroGeralService;

    protected void beforeInsert(CadastroImobiliarioAvaliacao entity) {
        entity.setSequencia(this.getNextSequencia(entity.getCadastroGeral().getId()));
        entity.setDataAvaliacao(LocalDate.now());
        if (Origem.MANUAL.equals((Object)entity.getOrigem())) {
            entity.setCadastroGeral(this.findCadastroGeralById(entity.getCadastroGeral().getId()));
        }
        super.beforeInsert((EloEntity)entity);
    }

    public CadastroGeral findCadastroGeralById(Long id) {
        return (CadastroGeral)this.cadastroGeralService.findOne((Serializable)id);
    }

    public Long getNextSequencia(Long cadastroGeralId) {
        return this.avaliacaoRepository.getNextSequenciaByCadastroGeralId(cadastroGeralId);
    }

    @Generated
    public CadastroImobiliarioAvaliacaoService(CadastroImobiliarioAvaliacaoRepository avaliacaoRepository, CadastroGeralService cadastroGeralService) {
        this.avaliacaoRepository = avaliacaoRepository;
        this.cadastroGeralService = cadastroGeralService;
    }
}

