/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.arquivos.client.ArquivoClient;
import br.com.elotech.arquivos.domain.Arquivo;
import br.com.elotech.arquivos.domain.request.ArquivoDownloadRequest;
import br.com.elotech.arquivos.domain.request.ArquivoNovoRequest;
import br.com.elotech.arquivos.domain.request.ArquivoRemocaoRequest;
import br.com.elotech.arquivos.domain.support.ContentType;
import br.com.elotech.arquivos.domain.support.Tenant;
import br.com.elotech.console.dto.Modulo;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.multitenant.filter.TenantContextHolder;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.CadastroGeralImagem;
import br.com.elotech.tributos.domain.EloArquivo;
import br.com.elotech.tributos.dto.EloArquivoDTO;
import br.com.elotech.tributos.repository.CadastroGeralImagemRepository;
import br.com.elotech.tributos.repository.CadastroGeralRepository;
import br.com.elotech.tributos.repository.EloArquivoRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.utils.TenantUtils;
import com.google.common.base.Charsets;
import java.io.IOException;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class CadastroGeralImagemService
extends CrudService<CadastroGeralImagem, Long> {
    private final CadastroGeralImagemRepository cadastroGeralImagemRepository;
    private final EloArquivoRepository eloArquivoRepository;
    private final ArquivoClient arquivoClient;
    private final ArquivoClient arquivoClientNovo;
    private final CadastroGeralRepository cadastroGeralRepository;

    public CadastroGeralImagemService(CadastroGeralImagemRepository cadastroGeralImagemRepository, EloArquivoRepository eloArquivoRepository, ArquivoClient arquivoClient, @Qualifier(value="novo") ArquivoClient arquivoClientNovo, CadastroGeralRepository cadastroGeralRepository) {
        this.cadastroGeralImagemRepository = cadastroGeralImagemRepository;
        this.eloArquivoRepository = eloArquivoRepository;
        this.arquivoClient = arquivoClient;
        this.arquivoClientNovo = arquivoClientNovo;
        this.cadastroGeralRepository = cadastroGeralRepository;
    }

    public void updateEloArquivos() {
        this.eloArquivoRepository.updateEloArquivoModuloByImagemId();
    }

    public Page<EloArquivoDTO> findArquivos(Long id, Pageable page) {
        return this.eloArquivoRepository.findEloArquivoByCadastroGeralImagemId(id, page);
    }

    public void delete(CadastroGeralImagem cadastroGeralImagem, @AuthenticationPrincipal Authentication authentication) {
        EloArquivo arquivo = (EloArquivo)this.eloArquivoRepository.findById((Object)cadastroGeralImagem.getId()).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi encontrado arquivo com id %d", cadastroGeralImagem.getId())));
        CadastroGeralImagem imagem = (CadastroGeralImagem)this.cadastroGeralImagemRepository.findById((Object)cadastroGeralImagem.getId()).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi encontrado cadastro geral imagem com id %d", cadastroGeralImagem.getId())));
        if (Objects.nonNull(arquivo.getFullPath())) {
            ArquivoRemocaoRequest removeArquivo = ArquivoRemocaoRequest.create((Tenant)Tenant.create((String)TenantContextHolder.getCurrentTenantId()), (String)arquivo.getFullPath());
            this.resolveArquivoClient().removerArquivo(removeArquivo);
        }
        this.eloArquivoRepository.deleteById((Object)arquivo.getId());
        this.cadastroGeralImagemRepository.deleteById((Object)imagem.getId());
    }

    public CadastroGeralImagem uploadArquivo(Long id, MultipartFile file) throws IOException {
        CadastroGeral cadastroGeral = (CadastroGeral)this.cadastroGeralRepository.findById((Object)id).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi encontrado cadastro geral com id %d", id)));
        String usuario = SecurityUtils.getUserName();
        Arquivo arquivo = this.saveArquivo(file);
        EloArquivo eloAarquivo = this.saveEloArquivo(file, arquivo);
        return (CadastroGeralImagem)this.cadastroGeralImagemRepository.save((Object)CadastroGeralImagem.from((MultipartFile)file, (CadastroGeral)cadastroGeral, (String)usuario, (Long)eloAarquivo.getId()));
    }

    public String getUrlArquivo(Long idArquivo) {
        EloArquivo arquivo = (EloArquivo)this.eloArquivoRepository.findById((Object)idArquivo).orElseThrow(() -> new EloValidationException(String.format("Elo arquivo com id %d n\u00e3o encontrado", idArquivo)));
        try {
            ArquivoDownloadRequest arquivoDownloadRequest = ArquivoDownloadRequest.create((Tenant)Tenant.create((String)TenantContextHolder.getCurrentTenantId()), (String)arquivo.getFullPath());
            return this.resolveArquivoClient().gerarUrlParaGet(arquivoDownloadRequest).getUrlAssinada();
        }
        catch (Exception ex) {
            throw new EloValidationException("Falha ao recuperar URL de download do arquivo." + ex.getMessage());
        }
    }

    private Arquivo saveArquivo(MultipartFile file) throws IOException {
        ArquivoNovoRequest arquivoNovoRequest = ArquivoNovoRequest.builder((Tenant)Tenant.create((String)TenantContextHolder.getCurrentTenantId()), (Modulo)Modulo.OXY_TRIBUTOS).fileName(file.getResource().getFilename()).content(file.getInputStream()).contentType(ContentType.fromType((String)file.getContentType())).build();
        return this.resolveArquivoClient().criarArquivo(arquivoNovoRequest);
    }

    private EloArquivo saveEloArquivo(MultipartFile file, Arquivo arquivo) throws IOException {
        String fileContent = new String(file.getBytes(), Charsets.ISO_8859_1);
        String arquivoImportacaoHash256 = DigestUtils.sha256Hex((String)fileContent);
        UUID usuario = SecurityUtils.getUserId();
        return (EloArquivo)this.eloArquivoRepository.save((Object)EloArquivo.from((MultipartFile)file, (String)arquivoImportacaoHash256, (UUID)usuario, (Arquivo)arquivo));
    }

    private ArquivoClient resolveArquivoClient() {
        return TenantUtils.usesNovoS3() != false ? this.arquivoClientNovo : this.arquivoClient;
    }
}

