/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.FormaPagamento;
import br.com.elotech.tributos.dto.DividaDTO;
import br.com.elotech.tributos.dto.acrescimo.AcrescimoDTO;
import br.com.elotech.tributos.dto.boleto.BoletoEspecialAcrescimoDTO;
import br.com.elotech.tributos.dto.boleto.BoletoEspecialDTO;
import br.com.elotech.tributos.dto.boleto.BoletoEspecialDebitoDTO;
import br.com.elotech.tributos.dto.boleto.BoletoEspecialDescontoDTO;
import br.com.elotech.tributos.service.BoletoEspecialCalculoService;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.FormaPagamentoService;
import br.com.elotech.tributos.service.acrescimo.calculo.CalculoAcrescimoService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class BoletoEspecialCalculoService {
    private final FormaPagamentoService formaPagamentoService;
    private final ContextService contextService;
    private final CalculoAcrescimoService calculoAcrescimoService;

    public BoletoEspecialCalculoService(FormaPagamentoService formaPagamentoService, ContextService contextService, CalculoAcrescimoService calculoAcrescimoService) {
        this.formaPagamentoService = formaPagamentoService;
        this.contextService = contextService;
        this.calculoAcrescimoService = calculoAcrescimoService;
    }

    public BoletoEspecialDTO calcularAcrescimos(BoletoEspecialAcrescimoDTO boletoEspecialAcrescimoDTO) {
        FormaPagamento formaPagamento = this.formaPagamentoService.findFormaPagamentoPadrao(Optional.empty());
        Long entidade = this.contextService.getEntidadePrincipal();
        boletoEspecialAcrescimoDTO.getDadosBoleto().getDebitos().forEach(debito -> {
            AcrescimoDTO acrescimo = new AcrescimoDTO();
            acrescimo.setEntidade(entidade);
            acrescimo.setExercicio(debito.getExercicio());
            acrescimo.setDataLancamento(debito.getDataLancamento());
            acrescimo.setDataPrimeiraParcela(debito.getDataPrimeiraParcela());
            acrescimo.setDataReferencia(boletoEspecialAcrescimoDTO.getDataReferencia());
            acrescimo.setDataVencimento(debito.getDataVencimento());
            acrescimo.setDataVencimentoOriginal(debito.getDataVencimento());
            acrescimo.setFormaCorrecao(debito.getFormaCorrecao());
            acrescimo.setParcelado(debito.getParcelado());
            acrescimo.setSituacaoLegal(debito.getSituacaoLegal());
            acrescimo.setTributo(debito.getTributo());
            acrescimo.setValor(debito.getValorPrincipal());
            acrescimo.setValorOriginal(debito.getValorPrincipal());
            acrescimo.setFormaPagamento(formaPagamento.getId());
            DividaDTO divida = new DividaDTO();
            divida.setExercicio(debito.getExercicio());
            divida.setDivida(debito.getDivida());
            divida.setEntidade(entidade);
            acrescimo.setDivida(divida);
            acrescimo.setCalculaValorDesconto(Boolean.FALSE);
            this.calculoAcrescimoService.calculaAcrescimos(acrescimo, Optional.empty());
            debito.setValorJuros(acrescimo.getValorJuros());
            debito.setValorMulta(acrescimo.getValorMulta());
            debito.setValorCorrecao(acrescimo.getValorCorrecao());
            debito.setValorDescontoPrincipal(BigDecimal.ZERO);
            debito.setValorDescontoJuros(BigDecimal.ZERO);
            debito.setValorDescontoMulta(BigDecimal.ZERO);
            debito.setValorDescontoCorrecao(BigDecimal.ZERO);
        });
        return boletoEspecialAcrescimoDTO.getDadosBoleto();
    }

    public BoletoEspecialDTO calcularDescontos(BoletoEspecialDescontoDTO descontoDTO) {
        BoletoEspecialDTO dadosBoleto = descontoDTO.getDadosBoleto();
        dadosBoleto.setDebitos(this.aplicarDescontos(descontoDTO));
        return descontoDTO.getDadosBoleto();
    }

    private List<BoletoEspecialDebitoDTO> aplicarDescontos(BoletoEspecialDescontoDTO descontoDTO) {
        if (Objects.isNull(descontoDTO.getTipoDesconto())) {
            throw new EloValidationException("O tipo de desconto \u00e9 obrigat\u00f3rio.");
        }
        switch (1.$SwitchMap$br$com$elotech$tributos$dto$enums$TipoDescontoBoletoEspecial[descontoDTO.getTipoDesconto().ordinal()]) {
            case 1: {
                return this.zerarDesconto(descontoDTO.getDadosBoleto().getDebitos());
            }
            case 2: {
                return this.descontoValorFixo(descontoDTO.getDadosBoleto().getDebitos(), descontoDTO.getValorDesconto());
            }
            case 3: {
                return this.descontoPercentual(descontoDTO, BoletoEspecialDebitoDTO::getValorPrincipal, BoletoEspecialDebitoDTO::setValorDescontoPrincipal, BoletoEspecialDebitoDTO::getValorDescontoPrincipal);
            }
            case 4: {
                return this.descontoPercentual(descontoDTO, BoletoEspecialDebitoDTO::getValorJuros, BoletoEspecialDebitoDTO::setValorDescontoJuros, BoletoEspecialDebitoDTO::getValorDescontoJuros);
            }
            case 5: {
                return this.descontoPercentual(descontoDTO, BoletoEspecialDebitoDTO::getValorMulta, BoletoEspecialDebitoDTO::setValorDescontoMulta, BoletoEspecialDebitoDTO::getValorDescontoMulta);
            }
            case 6: {
                return this.descontoPercentual(descontoDTO, BoletoEspecialDebitoDTO::getValorCorrecao, BoletoEspecialDebitoDTO::setValorDescontoCorrecao, BoletoEspecialDebitoDTO::getValorDescontoCorrecao);
            }
        }
        throw new EloValidationException("Tipo de desconto inv\u00e1lido.");
    }

    private List<BoletoEspecialDebitoDTO> zerarDesconto(List<BoletoEspecialDebitoDTO> debitos) {
        return debitos.stream().peek(debito -> {
            debito.setValorDescontoPrincipal(BigDecimal.ZERO);
            debito.setValorDescontoJuros(BigDecimal.ZERO);
            debito.setValorDescontoMulta(BigDecimal.ZERO);
            debito.setValorDescontoCorrecao(BigDecimal.ZERO);
        }).collect(Collectors.toList());
    }

    private void validaValorDescontoFixo(BigDecimal valorDesconto, BigDecimal valorTotal, BigDecimal valorDescontoAtual) {
        if (Objects.isNull(valorDesconto)) {
            throw new EloValidationException("Esse tipo de desconto precisa de um valor informado.");
        }
        if (BigDecimal.ZERO.compareTo(valorDesconto) > 0) {
            throw new EloValidationException(String.format("O valor de desconto deve ser maior que zero. Valor informado: %s.", valorDesconto));
        }
        if (valorTotal.compareTo(valorDesconto) < 0) {
            throw new EloValidationException(String.format("O valor de desconto deve ser menor que o valor total dos d\u00e9bitos. Valor informado: %s, valor total dos d\u00e9bitos: %s", valorDesconto, valorTotal));
        }
        BigDecimal valorNovoDesconto = valorDesconto.add(valorDescontoAtual);
        if (valorTotal.compareTo(valorNovoDesconto) < 0) {
            throw new EloValidationException(String.format("O valor de desconto informado combinado com o valor de desconto j\u00e1 existente deve ser menor que o valor total dos d\u00e9bitos. Valor informado: %s, Valor dos descontos existentes: %s, Valor total dos d\u00e9bitos: %s, diferen\u00e7a: %s", valorDesconto, valorDescontoAtual, valorTotal, valorNovoDesconto.subtract(valorTotal)));
        }
    }

    private List<BoletoEspecialDebitoDTO> descontoValorFixo(List<BoletoEspecialDebitoDTO> debitos, BigDecimal valorDesconto) {
        BigDecimal valorTotalSemDesconto = debitos.stream().map(BoletoEspecialDebitoDTO::getValorTotalSemDesconto).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal valorDescontoAtual = debitos.stream().map(BoletoEspecialDebitoDTO::getValorDescontos).reduce(BigDecimal.ZERO, BigDecimal::add);
        this.validaValorDescontoFixo(valorDesconto, valorTotalSemDesconto, valorDescontoAtual);
        BigDecimal valorRestanteDesconto = valorDesconto;
        BigDecimal valorDescontoJuros = this.rateioPorSobra(debitos, BoletoEspecialDebitoDTO::getValorJurosComDesconto, valorRestanteDesconto);
        valorRestanteDesconto = valorRestanteDesconto.subtract(valorDescontoJuros);
        BigDecimal valorDescontoMulta = this.rateioPorSobra(debitos, BoletoEspecialDebitoDTO::getValorMultaComDesconto, valorRestanteDesconto);
        valorRestanteDesconto = valorRestanteDesconto.subtract(valorDescontoMulta);
        BigDecimal valorDescontoCorrecao = this.rateioPorSobra(debitos, BoletoEspecialDebitoDTO::getValorCorrecaoComDesconto, valorRestanteDesconto);
        valorRestanteDesconto = valorRestanteDesconto.subtract(valorDescontoCorrecao);
        BigDecimal valorDescontoPrincipal = this.rateioPorSobra(debitos, BoletoEspecialDebitoDTO::getValorPrincipalComDesconto, valorRestanteDesconto);
        valorRestanteDesconto = valorRestanteDesconto.subtract(valorDescontoPrincipal);
        if (valorRestanteDesconto.compareTo(BigDecimal.ZERO) != 0) {
            throw new IllegalStateException("A diferen\u00e7a do desconto nunca deveria ser diferente de zero");
        }
        this.ratearValorDescontoFixo(debitos, valorDescontoJuros, BoletoEspecialDebitoDTO::getValorJurosComDesconto, BoletoEspecialDebitoDTO::getValorDescontoJuros, BoletoEspecialDebitoDTO::getValorJuros, BoletoEspecialDebitoDTO::setValorDescontoJuros);
        this.ratearValorDescontoFixo(debitos, valorDescontoMulta, BoletoEspecialDebitoDTO::getValorMultaComDesconto, BoletoEspecialDebitoDTO::getValorDescontoMulta, BoletoEspecialDebitoDTO::getValorMulta, BoletoEspecialDebitoDTO::setValorDescontoMulta);
        this.ratearValorDescontoFixo(debitos, valorDescontoCorrecao, BoletoEspecialDebitoDTO::getValorCorrecaoComDesconto, BoletoEspecialDebitoDTO::getValorDescontoCorrecao, BoletoEspecialDebitoDTO::getValorCorrecao, BoletoEspecialDebitoDTO::setValorDescontoCorrecao);
        this.ratearValorDescontoFixo(debitos, valorDescontoPrincipal, BoletoEspecialDebitoDTO::getValorPrincipalComDesconto, BoletoEspecialDebitoDTO::getValorDescontoPrincipal, BoletoEspecialDebitoDTO::getValorPrincipal, BoletoEspecialDebitoDTO::setValorDescontoPrincipal);
        return debitos;
    }

    private void ratearValorDescontoFixo(List<BoletoEspecialDebitoDTO> debitos, BigDecimal valorDesconto, Function<BoletoEspecialDebitoDTO, BigDecimal> getValorComDesconto, Function<BoletoEspecialDebitoDTO, BigDecimal> getValorDescontoExistente, Function<BoletoEspecialDebitoDTO, BigDecimal> getValorBase, BiConsumer<BoletoEspecialDebitoDTO, BigDecimal> setValorDesconto) {
        if (valorDesconto.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        BigDecimal valorDisponivelParaDesconto = debitos.stream().map(getValorComDesconto).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal descontoAcumulado = BigDecimal.ZERO;
        for (BoletoEspecialDebitoDTO debito2 : debitos) {
            if (valorDisponivelParaDesconto.compareTo(valorDesconto) == 0) {
                BigDecimal valorDescontoAdicionado = getValorBase.apply(debito2).subtract(getValorDescontoExistente.apply(debito2));
                descontoAcumulado = descontoAcumulado.add(valorDescontoAdicionado);
                setValorDesconto.accept(debito2, getValorBase.apply(debito2));
                continue;
            }
            BigDecimal valorDescontoProporcional = valorDesconto.multiply(getValorComDesconto.apply(debito2)).divide(valorDisponivelParaDesconto, 2, RoundingMode.HALF_UP);
            setValorDesconto.accept(debito2, getValorDescontoExistente.apply(debito2).add(valorDescontoProporcional));
            descontoAcumulado = descontoAcumulado.add(valorDescontoProporcional);
        }
        BigDecimal diferencaDesconto = valorDesconto.subtract(descontoAcumulado);
        if (diferencaDesconto.compareTo(BigDecimal.ZERO) != 0) {
            debitos.stream().max(Comparator.comparing(BoletoEspecialDebitoDTO::getValorTotal)).ifPresent(debito -> setValorDesconto.accept((BoletoEspecialDebitoDTO)debito, ((BigDecimal)getValorDescontoExistente.apply((BoletoEspecialDebitoDTO)debito)).add(diferencaDesconto)));
        }
    }

    private BigDecimal rateioPorSobra(List<BoletoEspecialDebitoDTO> debitos, Function<BoletoEspecialDebitoDTO, BigDecimal> getValorComDesconto, BigDecimal valorRestanteDesconto) {
        if (valorRestanteDesconto.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal valorDisponivel = debitos.stream().map(getValorComDesconto).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (valorDisponivel.compareTo(valorRestanteDesconto) >= 0) {
            return valorRestanteDesconto;
        }
        return valorDisponivel;
    }

    private void validaDescontoPercentual(BigDecimal valorDesconto) {
        if (Objects.isNull(valorDesconto)) {
            throw new EloValidationException("Esse tipo de desconto precisa de um valor informado.");
        }
        if (BigDecimal.ZERO.compareTo(valorDesconto) > 0) {
            throw new EloValidationException(String.format("O percentual de desconto deve ser maior que zero. Percentual informado: %s.", valorDesconto));
        }
        if (BigDecimal.valueOf(100L).compareTo(valorDesconto) < 0) {
            throw new EloValidationException(String.format("O percentual de desconto deve ser menor que 100. Percentual informado: %s.", valorDesconto));
        }
    }

    private List<BoletoEspecialDebitoDTO> descontoPercentual(BoletoEspecialDescontoDTO descontoDTO, Function<BoletoEspecialDebitoDTO, BigDecimal> getValorBase, BiConsumer<BoletoEspecialDebitoDTO, BigDecimal> setValorDesconto, Function<BoletoEspecialDebitoDTO, BigDecimal> getValorDesconto) {
        this.validaDescontoPercentual(descontoDTO.getValorDesconto());
        List debitos = descontoDTO.getDadosBoleto().getDebitos();
        BigDecimal total = debitos.stream().map(getValorBase).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal percentualDesconto = descontoDTO.getValorDesconto().divide(BigDecimal.valueOf(100L), 16, RoundingMode.HALF_EVEN);
        debitos.forEach(debito -> {
            BigDecimal desconto = ((BigDecimal)getValorBase.apply((BoletoEspecialDebitoDTO)debito)).multiply(percentualDesconto).setScale(2, RoundingMode.HALF_UP);
            setValorDesconto.accept((BoletoEspecialDebitoDTO)debito, desconto);
        });
        BigDecimal somaDesconto = debitos.stream().map(getValorDesconto).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal valorTotalDesconto = total.multiply(percentualDesconto).setScale(2, RoundingMode.HALF_UP);
        BigDecimal diferencaDesconto = valorTotalDesconto.subtract(somaDesconto);
        if (diferencaDesconto.compareTo(BigDecimal.ZERO) != 0) {
            debitos.stream().max(Comparator.comparing(getValorBase)).ifPresent(debito -> setValorDesconto.accept((BoletoEspecialDebitoDTO)debito, ((BigDecimal)getValorDesconto.apply((BoletoEspecialDebitoDTO)debito)).add(diferencaDesconto)));
        }
        return debitos;
    }
}

