/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.arquivos.domain.response.ArquivoUrl;
import br.com.elotech.console.dto.Modulo;
import br.com.elotech.tributos.dto.ArquivoUnicoSalvarDTO;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.exception.ArquivoUnicoException;
import br.com.elotech.tributos.util.ByteMultipartFile;
import br.com.elotech.unico.client.ArquivoStorageFeignClient;
import br.com.elotech.unico.client.dto.ArquivoDTO;
import java.net.URI;
import java.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ArquivoUnicoService {
    private final ArquivoStorageFeignClient arquivoStorageFeignClient;
    private final RestTemplate restTemplate;
    private static final Logger LOGGER = LoggerFactory.getLogger(ArquivoUnicoService.class);

    public ArquivoUnicoService(ArquivoStorageFeignClient arquivoStorageFeignClient, RestTemplate restTemplate) {
        this.arquivoStorageFeignClient = arquivoStorageFeignClient;
        this.restTemplate = restTemplate;
    }

    public Long salvarPDF(ArquivoUnicoSalvarDTO arquivoUnicoSalvarDTO) {
        ByteMultipartFile byteMultipartFile = new ByteMultipartFile(arquivoUnicoSalvarDTO.getContent(), "application/pdf");
        ArquivoDTO arquivoDTO = new ArquivoDTO(null, arquivoUnicoSalvarDTO.getFileName(), SecurityUtils.getUserId(), arquivoUnicoSalvarDTO.getTipoArquivo(), Modulo.OXY_TRIBUTOS, arquivoUnicoSalvarDTO.getDiretorio(), LocalDate.now(), "application/pdf", null, null, arquivoUnicoSalvarDTO.getMetadados());
        return this.arquivoStorageFeignClient.createWithFile(arquivoDTO, (MultipartFile)byteMultipartFile).getId();
    }

    public byte[] baixarPDF(Long id) {
        ArquivoDTO arquivoDTO = this.arquivoStorageFeignClient.findOne(id);
        ArquivoUrl arquivoUrl = this.arquivoStorageFeignClient.getUrlDownload(arquivoDTO.getFullPath(), arquivoDTO.getNome());
        try {
            URI uri = new URI(arquivoUrl.getUrlAssinada());
            LOGGER.info("Baixando arquivo pdf que foi gerado pelo unico... Url: {}", (Object)uri);
            ResponseEntity response = this.restTemplate.exchange(uri, HttpMethod.GET, HttpEntity.EMPTY, byte[].class);
            return (byte[])response.getBody();
        }
        catch (Exception ex) {
            LOGGER.error("Erro ao baixar arquivo pdf que foi gerado pelo unico", (Throwable)ex);
            throw new ArquivoUnicoException(HttpStatus.BAD_REQUEST, ex.getMessage(), ex);
        }
    }
}

