/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.simam;

import br.com.elotech.core.utils.web.ResponseUtils;
import br.com.elotech.tributos.dto.ImplantacaoSaldoImpressaoDTO;
import br.com.elotech.tributos.dto.ImplantacaoSaldoReceitaDTO;
import br.com.elotech.tributos.dto.simam.ImplantacaoSaldoContabilidadeDTO;
import br.com.elotech.tributos.dto.simam.ImplantacaoSaldoContabilidadeGroupedDTO;
import br.com.elotech.tributos.dto.simam.ImplantacaoSaldoDebitoParcelaDTO;
import br.com.elotech.tributos.dto.simam.ImplantacaoSaldoInformationDTO;
import br.com.elotech.tributos.dto.simam.ImplantacaoSaldoTributosDTO;
import br.com.elotech.tributos.service.simam.ImplantacaoSaldoService;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/api/simam-implantacao-saldo"})
public class ImplantacaoSaldoResource {
    private final ImplantacaoSaldoService implantacaoSaldoService;

    @GetMapping
    public ResponseEntity<List<ImplantacaoSaldoContabilidadeDTO>> findDadosContabilidade(@RequestParam(value="entidade") Long entidade, @RequestParam(value="exercicio") Long exercicio) {
        return ResponseEntity.ok((Object)this.implantacaoSaldoService.findDadosContabilidade(entidade, exercicio));
    }

    @GetMapping(value={"/grouped"})
    public ResponseEntity<List<ImplantacaoSaldoContabilidadeGroupedDTO>> findDadosContabilidadeGrouped(@RequestParam(value="entidade") Long entidade, @RequestParam(value="exercicio") Long exercicio) {
        return ResponseEntity.ok((Object)this.implantacaoSaldoService.findDadosContabilidadeGrouped(entidade, exercicio));
    }

    @GetMapping(value={"/tributos-detalhados"})
    public ResponseEntity<List<ImplantacaoSaldoTributosDTO>> findTributosDetalhados(ImplantacaoSaldoReceitaDTO dto) {
        return ResponseEntity.ok((Object)this.implantacaoSaldoService.findTributosDetalhados(dto));
    }

    @GetMapping(value={"/debito-parcela-tributos"})
    public ResponseEntity<Page<ImplantacaoSaldoDebitoParcelaDTO>> findDebitoParcelaTributos(ImplantacaoSaldoReceitaDTO dto, Pageable page) {
        return ResponseEntity.ok((Object)this.implantacaoSaldoService.findDebitoParcelaTributos(dto, page));
    }

    @GetMapping(value={"/ultima-geracao"})
    public ResponseEntity<ImplantacaoSaldoInformationDTO> getInformationFromLastImplantacaoSaldo(@RequestParam(value="entidade") Long entidade, @RequestParam(value="exercicio") Long exercicio) {
        return ResponseEntity.ok((Object)this.implantacaoSaldoService.getInformationFromLastImplantacaoSaldo(entidade, exercicio));
    }

    @PostMapping(value={"/imprimir"})
    public void imprimir(@RequestBody ImplantacaoSaldoImpressaoDTO dto, HttpServletResponse response) throws IOException {
        byte[] arquivo = this.implantacaoSaldoService.printImplantacaoSaldo(dto);
        if (Objects.isNull(arquivo)) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "N\u00e3o foi poss\u00edvel gerar a consulta de Implanta\u00e7\u00e3o de Saldo.");
        }
        ResponseUtils.writePdfToResponse((HttpServletResponse)response, (byte[])arquivo, (String)"consulta_implantacao_saldo_simam.pdf");
    }

    @Generated
    public ImplantacaoSaldoResource(ImplantacaoSaldoService implantacaoSaldoService) {
        this.implantacaoSaldoService = implantacaoSaldoService;
    }
}

