/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.protocolo;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.resource.support.ReadOnlyResource;
import br.com.elotech.core.utils.EloPage;
import br.com.elotech.protocolo.client.feign.ProcessoClientFeign;
import br.com.elotech.protocolo.dto.ProcessoDTO;
import br.com.elotech.tributos.domain.protocolo.Processo;
import br.com.elotech.tributos.domain.protocolo.ProcessoId;
import java.util.Optional;
import lombok.Generated;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/processos"})
public class ProcessoResource
extends ReadOnlyResource<Processo, ProcessoId> {
    private final Optional<ProcessoClientFeign> processoClientFeign;

    @GetMapping(value={"/search"})
    public ResponseEntity<EloPage<ProcessoDTO>> findAll(@RequestParam(value="search", required=false) String search, Pageable pageable, Long entidade) {
        if (this.processoClientFeign.isEmpty()) {
            throw new EloValidationException("O client do protocolo n\u00e3o est\u00e1 disponivel no ambiente onpremise.");
        }
        EloPage processo = ((ProcessoClientFeign)this.processoClientFeign.get()).findAll(search, pageable, entidade);
        return ResponseEntity.ok((Object)processo);
    }

    @Generated
    public ProcessoResource(Optional<ProcessoClientFeign> processoClientFeign) {
        this.processoClientFeign = processoClientFeign;
    }
}

