/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.integracaogeomais;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.dto.integracaogeomais.PessoaGeomaisDTO;
import br.com.elotech.tributos.service.PessoaService;
import io.swagger.annotations.ApiOperation;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/elogeo/pessoa"})
public class PessoaGeomaisResource {
    private final PessoaService pessoaService;

    public PessoaGeomaisResource(PessoaService pessoaService) {
        this.pessoaService = pessoaService;
    }

    @ApiOperation(value="Retorna uma lista de pessoas")
    @GetMapping
    public ResponseEntity<Page<PessoaGeomaisDTO>> findAll(Pageable page) {
        Page pessoas = this.pessoaService.findAll(page).map(PessoaGeomaisDTO::from);
        return ResponseEntity.ok((Object)pessoas);
    }

    @ApiOperation(value="Retorna uma pessoa em espec\u00edfico")
    @GetMapping(value={"/{id}"})
    public ResponseEntity<PessoaGeomaisDTO> findById(@PathVariable Long id) {
        PessoaGeomaisDTO pessoaGeomaisDTO = this.pessoaService.findById(id).map(PessoaGeomaisDTO::from).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar a Pessoa com o id '%d'.", id)));
        return ResponseEntity.ok((Object)pessoaGeomaisDTO);
    }
}

