/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.integracaogeomais;

import br.com.elotech.tributos.domain.Loteamento;
import br.com.elotech.tributos.dto.integracaogeomais.LoteamentoElogeoSearchDTO;
import br.com.elotech.tributos.dto.integracaogeomais.LoteamentoGeomaisDTO;
import br.com.elotech.tributos.dto.integracaogeomais.LoteamentoPostElogeoDTO;
import br.com.elotech.tributos.service.integracaogeomais.LoteamentoElogeoService;
import io.swagger.annotations.ApiOperation;
import java.net.URI;
import javax.validation.Valid;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/elogeo/loteamento"})
public class LoteamentoGeomaisResource {
    private final LoteamentoElogeoService loteamentoElogeoService;

    public LoteamentoGeomaisResource(LoteamentoElogeoService loteamentoElogeoService) {
        this.loteamentoElogeoService = loteamentoElogeoService;
    }

    @ApiOperation(value="Retorna uma lista de loteamentos")
    @GetMapping
    public ResponseEntity<Page<LoteamentoGeomaisDTO>> findAll(Pageable page) {
        return ResponseEntity.ok((Object)this.loteamentoElogeoService.findAllElogeo(page));
    }

    @ApiOperation(value="Retorna um loteamento em espec\u00edfico")
    @GetMapping(value={"/{id}"})
    public ResponseEntity<LoteamentoGeomaisDTO> findByLoteamento(@PathVariable Long id) {
        return ResponseEntity.ok((Object)LoteamentoGeomaisDTO.from((Loteamento)this.loteamentoElogeoService.findByLoteamentoElogeoDTO(id)));
    }

    @ApiOperation(value="Faz uma pesquisa espec\u00edfica pelos campos distrito, setor, codigo, nome")
    @GetMapping(value={"/pesquisa"})
    public ResponseEntity<Page<LoteamentoGeomaisDTO>> findByRSQL(@Valid LoteamentoElogeoSearchDTO request, Pageable pageable) {
        return ResponseEntity.ok((Object)this.loteamentoElogeoService.findByRSQL(request.toRsqlSearch(), pageable));
    }

    @ApiOperation(value="Altera as informa\u00e7\u00f5es de um Loteamento existente")
    @PutMapping(value={"/{loteamento}/distrito/{distrito}/setor/{setor}"})
    public ResponseEntity<LoteamentoGeomaisDTO> update(@PathVariable Long loteamento, @PathVariable String distrito, @PathVariable String setor, @RequestBody @Valid LoteamentoPostElogeoDTO loteamentoPostElogeoDTO) {
        return ResponseEntity.ok((Object)this.loteamentoElogeoService.saveElogeoDTO(loteamentoPostElogeoDTO, distrito, setor, loteamento));
    }

    @ApiOperation(value="Grava um novo Loteamento")
    @PostMapping
    public ResponseEntity<LoteamentoGeomaisDTO> save(@RequestBody @Valid LoteamentoPostElogeoDTO loteamentoPostElogeoDTO) {
        return ResponseEntity.created((URI)URI.create("")).body((Object)this.loteamentoElogeoService.saveElogeoDTO(loteamentoPostElogeoDTO));
    }
}

