/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.integracaocontabil;

import br.com.elotech.tributos.dto.integracaocontabil.ArrecadacaoPorLoteDTO;
import br.com.elotech.tributos.dto.integracaocontabil.FiltroArrecadacaoPorLoteDTO;
import br.com.elotech.tributos.dto.integracaocontabil.ResumoArrecadacaoPorLoteDTO;
import br.com.elotech.tributos.service.integracaocontabil.ArrecadacaoPorLoteService;
import javax.validation.Valid;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/arrecadacao-por-lote"})
public class ArrecadacaoPorLoteResource {
    private final ArrecadacaoPorLoteService arrecadacaoPorLoteService;

    public ArrecadacaoPorLoteResource(ArrecadacaoPorLoteService arrecadacaoPorLoteService) {
        this.arrecadacaoPorLoteService = arrecadacaoPorLoteService;
    }

    @PostMapping(value={"/resumo"})
    public ResponseEntity<ResumoArrecadacaoPorLoteDTO> consultaArrecadacaoPorLote(@RequestBody @Valid FiltroArrecadacaoPorLoteDTO filtro) {
        return ResponseEntity.ok((Object)this.arrecadacaoPorLoteService.resumo(filtro));
    }

    @PostMapping(value={"/consulta"})
    public ResponseEntity<Page<ArrecadacaoPorLoteDTO>> consulta(@RequestBody @Valid FiltroArrecadacaoPorLoteDTO filtro, Pageable pageable) {
        return ResponseEntity.ok((Object)this.arrecadacaoPorLoteService.consulta(filtro, pageable));
    }
}

