/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.documento.peticao;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.resource.support.CrudResource;
import br.com.elotech.tributos.domain.documento.peticao.LotePeticao;
import br.com.elotech.tributos.domain.documento.peticao.LotePeticaoItem;
import br.com.elotech.tributos.domain.tarefaassincrona.TipoTarefaAssincrona;
import br.com.elotech.tributos.dto.documento.peticao.GeracaoLotePeticaoDTO;
import br.com.elotech.tributos.dto.documento.peticao.LotePeticaoIdDTO;
import br.com.elotech.tributos.service.TarefaAssincronaService;
import br.com.elotech.tributos.service.documento.peticao.GeraPeticaoService;
import br.com.elotech.tributos.service.documento.peticao.LotePeticaoService;
import java.util.concurrent.Callable;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/lotes-peticao"})
@RestController
public class LotePeticaoResource
extends CrudResource<LotePeticao, Long> {
    private final LotePeticaoService lotePeticaoService;
    private final GeraPeticaoService geraPeticaoService;
    private final TarefaAssincronaService tarefaAssincronaService;

    public LotePeticaoResource(LotePeticaoService lotePeticaoService, GeraPeticaoService geraPeticaoService, TarefaAssincronaService tarefaAssincronaService) {
        this.lotePeticaoService = lotePeticaoService;
        this.geraPeticaoService = geraPeticaoService;
        this.tarefaAssincronaService = tarefaAssincronaService;
    }

    @PostMapping(value={"/gerar-simulacao"})
    public ResponseEntity<LotePeticaoIdDTO> gerarSimulacao(@RequestBody GeracaoLotePeticaoDTO geracaoLotePeticaoDTO) {
        return ResponseEntity.ok((Object)LotePeticaoIdDTO.from((LotePeticao)this.lotePeticaoService.gerarSimulacao(geracaoLotePeticaoDTO)));
    }

    @GetMapping(value={"/{id}/itens"})
    public ResponseEntity<Page<LotePeticaoItem>> findItens(@PathVariable(value="id") Long id, @RequestParam(required=false, defaultValue="") String search, Pageable pageable) {
        return ResponseEntity.ok((Object)this.lotePeticaoService.searchItens(id, search, pageable));
    }

    @PostMapping(value={"/gerar-peticao/{id}"})
    public ResponseEntity<LotePeticaoIdDTO> gerarPeticao(@PathVariable(value="id") Long id) {
        return ResponseEntity.ok((Object)LotePeticaoIdDTO.from((LotePeticao)this.geraPeticaoService.gerarPeticoesLote(id)));
    }

    @GetMapping(value={"/{id}/imprimirPeticaoLote"})
    public Callable<Void> printPeticaoLote(@PathVariable Long id, @RequestParam(required=false, defaultValue="") String search, @RequestParam(value="totalPeticoes") Integer totalPeticoes, Sort sort) {
        return () -> {
            Boolean tarefaEmExecucao = this.tarefaAssincronaService.existsProcessoEmExecucao(TipoTarefaAssincrona.IMPRESSAO_PETICAO_LOTE, "ID_LOTE_PETICAO", id.toString());
            if (Boolean.TRUE.equals(tarefaEmExecucao)) {
                throw new EloValidationException("J\u00e1 existe uma tarefa com o par\u00e2metro informado em execu\u00e7\u00e3o");
            }
            this.lotePeticaoService.printPeticaoLoteAgrupado(id, search, sort, totalPeticoes);
            return null;
        };
    }

    @GetMapping(value={"/{idArquivo}/download"})
    public ResponseEntity<String> downloadLoteCDAAgrupado(@PathVariable String idArquivo) {
        return ResponseEntity.ok((Object)this.lotePeticaoService.getUrlArquivoLotePeticao(idArquivo));
    }
}

