/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.documento;

import br.com.elotech.tributos.dto.DocumentoDTO;
import br.com.elotech.tributos.dto.DocumentoGenericoDTO;
import br.com.elotech.tributos.dto.ImpressaoDTO;
import br.com.elotech.tributos.dto.atendimento.AtendimentoDTO;
import br.com.elotech.tributos.service.documento.CertidaoInscricaoService;
import br.com.elotech.tributos.service.ws.AisePdfService;
import javax.validation.Valid;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/certidao-inscricao"})
@RestController
public class CertidaoInscricaoResource {
    private final CertidaoInscricaoService certidaoInscricaoService;
    private final AisePdfService aisePdfService;

    public CertidaoInscricaoResource(CertidaoInscricaoService certidaoInscricaoService, AisePdfService aisePdfService) {
        this.certidaoInscricaoService = certidaoInscricaoService;
        this.aisePdfService = aisePdfService;
    }

    @PostMapping(value={"/valores-iniciais"})
    public ResponseEntity<DocumentoGenericoDTO> getInitialValues(@RequestBody AtendimentoDTO atendimento) {
        return ResponseEntity.ok((Object)this.certidaoInscricaoService.getInitialValues(atendimento));
    }

    @PostMapping
    public ResponseEntity<ImpressaoDTO> buildCertidaoEncerramento(@RequestBody @Valid DocumentoGenericoDTO geracaoDocumentoDto) {
        DocumentoDTO dto = this.certidaoInscricaoService.save(geracaoDocumentoDto);
        dto.setUrl(this.aisePdfService.fetchDocumento(dto.getDocumento(), dto.getTipoDocumento(), dto.getExercicio()));
        return ResponseEntity.ok((Object)ImpressaoDTO.from((Long)dto.getId(), (String)dto.getUrl()));
    }
}

