/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.resource.support.ReadOnlyResource;
import br.com.elotech.tributos.domain.ImobiliariaCadastro;
import br.com.elotech.tributos.dto.ImobiliariaCadastroDTO;
import br.com.elotech.tributos.service.ImobiliariaCadastroService;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/imobiliarias-cadastro"})
public class ImobiliariaCadastroResource
extends ReadOnlyResource<ImobiliariaCadastro, Long> {
    private final ImobiliariaCadastroService imobiliariaCadastroService;

    public ImobiliariaCadastroResource(ImobiliariaCadastroService imobiliariaCadastroService) {
        this.imobiliariaCadastroService = imobiliariaCadastroService;
    }

    @GetMapping(value={"/search"})
    public ResponseEntity<Page<ImobiliariaCadastroDTO>> searchCadastroByImobiliaria(String search, Pageable pageable) {
        return ResponseEntity.ok((Object)this.imobiliariaCadastroService.findByRsql(search, pageable).map(ImobiliariaCadastroDTO::of));
    }

    @Transactional
    @PostMapping
    public ResponseEntity<ImobiliariaCadastroDTO> adicionar(@RequestBody ImobiliariaCadastroDTO imobiliariaCadastroDTO) {
        return ResponseEntity.ok((Object)this.imobiliariaCadastroService.save(imobiliariaCadastroDTO));
    }

    @Transactional
    @PutMapping(value={"/{id}"})
    public ResponseEntity<ImobiliariaCadastroDTO> editar(@PathVariable(value="id") Long id, @RequestBody ImobiliariaCadastroDTO imobiliariaCadastroDTO) {
        return ResponseEntity.ok((Object)this.imobiliariaCadastroService.edit(id, imobiliariaCadastroDTO));
    }

    @Transactional
    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> deletar(@PathVariable(value="id") Long id) {
        this.imobiliariaCadastroService.delete(id);
        return ResponseEntity.ok().build();
    }
}

