/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.dto.dividaativa.FiltroGeraLivroDTO;
import br.com.elotech.tributos.dto.dividaativa.GeraLivroDebitoParcelaDTO;
import br.com.elotech.tributos.dto.dividaativa.LivroDTO;
import br.com.elotech.tributos.repository.GeraLivroRepository;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.batch.LivroDividaAtivaJobStarter;
import com.fasterxml.jackson.core.JsonProcessingException;
import javax.validation.Valid;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/gera-livro-divida-ativa"})
public class GeraLivroResource {
    private final ParametroGeralService parametroGeralService;
    private final GeraLivroRepository geraLivroRepository;
    private final LivroDividaAtivaJobStarter livroDividaAtivaJobStarter;

    public GeraLivroResource(ParametroGeralService parametroGeralService, GeraLivroRepository geraLivroRepository, LivroDividaAtivaJobStarter livroDividaAtivaJobStarter) {
        this.parametroGeralService = parametroGeralService;
        this.geraLivroRepository = geraLivroRepository;
        this.livroDividaAtivaJobStarter = livroDividaAtivaJobStarter;
    }

    @PostMapping(value={"/filtrar-debitos"})
    public ResponseEntity<Page<GeraLivroDebitoParcelaDTO>> search(@RequestBody FiltroGeraLivroDTO filtro, Pageable pageable) {
        Boolean inscricaoPorParcela = "P".equals(this.parametroGeralService.getParamValueAsString(ParametroGeralEnum.TIPO_INSCRICAO_DIVIDA_ATIVA, ModuloEnum.MODULO_TRIBUTARIO.getValue()));
        Page result = this.geraLivroRepository.getDebitoParcelas(filtro.getFiltro(inscricaoPorParcela), pageable, filtro.getEntidade());
        return ResponseEntity.ok((Object)result);
    }

    @PostMapping
    public ResponseEntity<LivroDTO> geraLivroDividaAtiva(@Valid @RequestBody FiltroGeraLivroDTO filtro) throws JsonProcessingException, JobParametersInvalidException, JobExecutionAlreadyRunningException, JobRestartException, JobInstanceAlreadyCompleteException {
        this.livroDividaAtivaJobStarter.startJob(filtro);
        return ResponseEntity.ok().build();
    }
}

