/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.tributos.dto.DebitoDTO;
import br.com.elotech.tributos.service.DebitoCpfService;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/debitos-cpf"})
@CrossOrigin
public class DebitosCpfResource {
    private final DebitoCpfService debitoCpfService;

    public DebitosCpfResource(DebitoCpfService debitoCpfService) {
        this.debitoCpfService = debitoCpfService;
    }

    @GetMapping(path={"/agrupados"}, params={"cpf"})
    public ResponseEntity<List<DebitoDTO>> getDebitosAgrupadosCpf(String cpf) {
        return ResponseEntity.ok().body((Object)this.debitoCpfService.getDebitosAgrupadosCpf(cpf));
    }

    @GetMapping(params={"cpf"})
    public ResponseEntity<List<DebitoDTO>> getDebitosCpf(String cpf) {
        return ResponseEntity.ok().body((Object)this.debitoCpfService.getDebitosCpf(cpf));
    }
}

