/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.resource.support.CrudResource;
import br.com.elotech.tributos.domain.CreditoContribuinte;
import br.com.elotech.tributos.domain.CreditoContribuinteId;
import br.com.elotech.tributos.dto.CreditoContribuinteDTO;
import br.com.elotech.tributos.dto.CreditoContribuintePesquisaDTO;
import br.com.elotech.tributos.dto.FiltroCreditoContribuinteDTO;
import br.com.elotech.tributos.service.CreditoContribuinteService;
import javax.validation.Valid;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/creditos"})
public class CreditoContribuinteResource
extends CrudResource<CreditoContribuinte, CreditoContribuinteId> {
    private final CreditoContribuinteService creditoContribuinteService;

    public CreditoContribuinteResource(CreditoContribuinteService creditoContribuinteService) {
        this.creditoContribuinteService = creditoContribuinteService;
    }

    @PostMapping(value={"/search"})
    public ResponseEntity<Page<CreditoContribuintePesquisaDTO>> findAll(@RequestBody @Valid FiltroCreditoContribuinteDTO filtroCreditoContribuinte, Pageable pageable) {
        return ResponseEntity.ok((Object)this.creditoContribuinteService.findCreditos(filtroCreditoContribuinte, pageable));
    }

    @GetMapping(value={"/{entidade}/{exercicio}/{credito}/resumo"})
    public ResponseEntity<CreditoContribuinteDTO> findById(@PathVariable Long entidade, @PathVariable Long exercicio, @PathVariable Long credito) {
        return ResponseEntity.ok((Object)this.creditoContribuinteService.getResumo(entidade, exercicio, credito));
    }
}

