/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.tributos.dto.DocumentoDTO;
import br.com.elotech.tributos.dto.ImpressaoDTO;
import br.com.elotech.tributos.params.CertidaoQuitacaoITBIParams;
import br.com.elotech.tributos.service.CertidaoQuitacaoITBIService;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.DocumentoService;
import br.com.elotech.tributos.service.ws.AisePdfService;
import br.com.elotech.tributos.util.LoggerPrototype;
import br.com.elotech.tributos.ws.domain.GeraCertidaoQuitacaoITBIResposta;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/certidaoquitacaoitbi"})
public class CertidaoQuitacaoITBIResource
implements LoggerPrototype {
    @Autowired
    private CertidaoQuitacaoITBIService certidaoQuitacaoITBIService;
    @Autowired
    private AisePdfService aisePdfService;
    @Autowired
    private DocumentoService documentoService;
    @Autowired
    private ContextService contextService;

    @GetMapping(params={"exercicioITBI", "tipoCadastro", "cpfRequerente", "tipoRequerente", "requerente", "finalidade"})
    public ImpressaoDTO geraCertidaoQuitacaoITBI(CertidaoQuitacaoITBIParams params) {
        GeraCertidaoQuitacaoITBIResposta itbi = this.certidaoQuitacaoITBIService.geraCertidaoQuitacaoITBI(params);
        return ImpressaoDTO.from((String)this.aisePdfService.fetchDocumento(itbi.getDocumento(), itbi.getTipoDocumento(), itbi.getExercicio()));
    }

    @PostMapping(value={"/documento"})
    public ResponseEntity<DocumentoDTO> geraCertidaoQuitacaoITBIOnline(@RequestBody CertidaoQuitacaoITBIParams params) {
        GeraCertidaoQuitacaoITBIResposta itbi = this.certidaoQuitacaoITBIService.geraCertidaoQuitacaoITBI(params);
        return ResponseEntity.ok((Object)this.documentoService.getDocumentoDTO(this.contextService.getEntidadePrincipal(), itbi.getExercicio(), itbi.getTipoDocumento(), itbi.getDocumento()));
    }
}

