/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.tributos.dto.AlvaraLocalizacaoDTO;
import br.com.elotech.tributos.dto.DocumentoDTO;
import br.com.elotech.tributos.dto.ImpressaoDTO;
import br.com.elotech.tributos.dto.atendimento.AtendimentoDTO;
import br.com.elotech.tributos.service.AlvaraLocalizacaoService;
import br.com.elotech.tributos.service.ws.AisePdfService;
import javax.validation.Valid;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/alvara-localizacao"})
public class AlvaraLocalizacaoResource {
    private final AlvaraLocalizacaoService alvaraLocalizacaoService;
    private final AisePdfService aisePdfService;

    public AlvaraLocalizacaoResource(AlvaraLocalizacaoService alvaraLocalizacaoService, AisePdfService aisePdfService) {
        this.alvaraLocalizacaoService = alvaraLocalizacaoService;
        this.aisePdfService = aisePdfService;
    }

    @PostMapping(value={"/valores-iniciais"})
    public ResponseEntity<AlvaraLocalizacaoDTO> getInitialValues(@RequestBody AtendimentoDTO atendimento) {
        return ResponseEntity.ok((Object)this.alvaraLocalizacaoService.getInitialValues(atendimento));
    }

    @PostMapping
    public ResponseEntity<ImpressaoDTO> save(@RequestBody @Valid AlvaraLocalizacaoDTO geracaoDocumentoDto) {
        DocumentoDTO dto = this.alvaraLocalizacaoService.save(geracaoDocumentoDto);
        dto.setUrl(this.aisePdfService.fetchDocumento(dto.getDocumento(), dto.getTipoDocumento(), dto.getExercicio()));
        return ResponseEntity.ok((Object)ImpressaoDTO.from((Long)dto.getId(), (String)dto.getUrl()));
    }
}

