/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.simam;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.domain.Entidade;
import br.com.elotech.tributos.dto.simam.EstornoDeducaoCreditoDividaAtivaCargaExistenteDTO;
import br.com.elotech.tributos.dto.simam.EstornoDeducaoDividaAtivaDTO;
import br.com.elotech.tributos.dto.simam.manutencaoarquivo.EstornoDeducaoCreditoDividaAtivaMaDTO;
import br.com.elotech.tributos.repository.simam.EstornoDeducaoCreditoDACustomRepostitory;
import java.sql.Date;
import java.time.LocalDate;
import java.util.List;
import lombok.Generated;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class EstornoDeducaoCreditoDividaAtivaRepositoryImpl
implements EstornoDeducaoCreditoDACustomRepostitory {
    private static final String PESSOA = "idPessoa";
    private static final String ENTIDADE = "entidade";
    private static final String DATA_INICIAL = "dataInicial";
    private static final String DATA_FINAL = "dataFinal";
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    public List<EstornoDeducaoDividaAtivaDTO> findLancamentos(Entidade entidade, LocalDate dataInicial, LocalDate dataFinal) {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue(PESSOA, (Object)entidade.getIdentificacaoTce());
        parameters.addValue(ENTIDADE, (Object)entidade.getId());
        parameters.addValue(DATA_INICIAL, (Object)Date.valueOf(dataInicial), 91);
        parameters.addValue(DATA_FINAL, (Object)Date.valueOf(dataFinal), 91);
        String sqlLancamentos = FileUtils.readResourceAsString((String)"sql/simam/estornoDeducaoDALancamentos.sql");
        return this.namedParameterJdbcTemplate.query(sqlLancamentos, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(EstornoDeducaoDividaAtivaDTO.class));
    }

    public List<EstornoDeducaoCreditoDividaAtivaCargaExistenteDTO> getCargaExistenteDeducaoCreditoDividaAtiva(Long entidade, LocalDate dataInicial, LocalDate dataFinal) {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue(ENTIDADE, (Object)entidade);
        parameters.addValue(DATA_INICIAL, (Object)Date.valueOf(dataInicial), 91);
        parameters.addValue(DATA_FINAL, (Object)Date.valueOf(dataFinal), 91);
        String sqlCargaExistente = FileUtils.readResourceAsString((String)"sql/simam/estornoDeducaoCreditoDividaAtivaCargaExistente.sql");
        return this.namedParameterJdbcTemplate.query(sqlCargaExistente, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(EstornoDeducaoCreditoDividaAtivaCargaExistenteDTO.class));
    }

    public List<EstornoDeducaoCreditoDividaAtivaMaDTO> findEstornosMa(Long entidade, LocalDate dataInicial, LocalDate dataFinal) {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue(ENTIDADE, (Object)entidade);
        parameters.addValue(DATA_INICIAL, (Object)Date.valueOf(dataInicial), 91);
        parameters.addValue(DATA_FINAL, (Object)Date.valueOf(dataFinal), 91);
        String sql = FileUtils.readResourceAsString((String)"sql/simam/manutencaoarquivo/estornoDeducaoCreditoDividaAtivaMa.sql");
        return this.namedParameterJdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(EstornoDeducaoCreditoDividaAtivaMaDTO.class));
    }

    @Generated
    public EstornoDeducaoCreditoDividaAtivaRepositoryImpl(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }
}

