/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.simam;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.tributos.dto.simam.EstAtualizacaoCreditoDACargaExistenteDTO;
import br.com.elotech.tributos.repository.simam.EstAtualizacaoMonCreditoDACustomRepository;
import java.sql.Date;
import java.time.LocalDate;
import java.util.List;
import lombok.Generated;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class EstAtualizacaoMonCreditoDACustomRepositoryImpl
implements EstAtualizacaoMonCreditoDACustomRepository {
    private static final String DATA_INICIAL = "dataInicial";
    private static final String DATA_FINAL = "dataFinal";
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    public List<EstAtualizacaoCreditoDACargaExistenteDTO> getCargaExistente(LocalDate dataInicial, LocalDate dataFinal) {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue(DATA_INICIAL, (Object)Date.valueOf(dataInicial), 91);
        parameters.addValue(DATA_FINAL, (Object)Date.valueOf(dataFinal), 91);
        String sql = "select t.idTceAtualizaMoneCredDAEst,      t.nrAtualizacao,      t.nrAnoAtualizacao,      t.cdControleLeiAto,      t.dtEstorno       from tceAtualizaMoneCredDAEst t       where t.dtEstorno between :dataInicial and :dataFinal       order by t.nrAtualizacao, t.nrAnoAtualizacao";
        return this.namedParameterJdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(EstAtualizacaoCreditoDACargaExistenteDTO.class));
    }

    @Generated
    public EstAtualizacaoMonCreditoDACustomRepositoryImpl(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }
}

