/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.simam;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.simam.AtualizacaoCreditoCargaExistenteDTO;
import br.com.elotech.tributos.dto.simam.AtualizacaoCreditoDTO;
import br.com.elotech.tributos.repository.simam.AtualizacaoCreditoCustomRepository;
import java.sql.Date;
import java.time.LocalDate;
import java.util.List;
import lombok.Generated;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class AtualizacaoCreditoCustomRepositoryImpl
implements AtualizacaoCreditoCustomRepository {
    private static final String DATA_INICIAL = "dataInicial";
    private static final String DATA_FINAL = "dataFinal";
    private static final String ENTIDADE = "entidade";
    private static final String PESSOA = "idPessoa";
    private static final String EXERCICIO = "exercicio";
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    public List<AtualizacaoCreditoCargaExistenteDTO> getCargaExistente(LocalDate dataInicial, LocalDate dataFinal) {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue(DATA_INICIAL, (Object)Date.valueOf(dataInicial), 91);
        parameters.addValue(DATA_FINAL, (Object)Date.valueOf(dataFinal), 91);
        String sql = "select t.idTceAtualizaMoneCred,        t.nrCredito,        t.nrAnoCredito,        t.cdControleLeiAto,        t.idTipoAtualizacaoCredito,        t.dtAtualizacao from tceAtualizaMoneCred t where t.dtAtualizacao between :dataInicial and :dataFinal order by t.nrAtualizacao, t.nrAnoAtualizacao";
        return this.namedParameterJdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(AtualizacaoCreditoCargaExistenteDTO.class));
    }

    public List<AtualizacaoCreditoDTO> findAtualizacoes(Long idPessoa, Long entidade, LocalDate dataInicial, LocalDate dataFinal) {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue(PESSOA, (Object)idPessoa);
        parameters.addValue(DATA_INICIAL, (Object)Date.valueOf(dataInicial), 91);
        parameters.addValue(DATA_FINAL, (Object)Date.valueOf(dataFinal), 91);
        String sqlLancamentos = FileUtils.readResourceAsString((String)"sql/simam/atualizacaoCreditoLancamentos.sql");
        return this.namedParameterJdbcTemplate.query(sqlLancamentos, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(AtualizacaoCreditoDTO.class));
    }

    @Generated
    public AtualizacaoCreditoCustomRepositoryImpl(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }
}

