/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.oxyadmin;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import org.springframework.data.repository.query.Param;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class DashBoardRepository {
    private final DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private final NamedParameterJdbcTemplate jdbcTemplate;

    public DashBoardRepository(NamedParameterJdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    private Long getSqlValue(String sql, Long entidade, Long exercicio, Long mes) {
        LocalDate dataInicial = LocalDate.of(exercicio.intValue(), mes.intValue(), 1);
        LocalDate dataFinal = LocalDate.of(exercicio.intValue(), mes.intValue(), 1).plusMonths(1L);
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("ENTIDADE", (Object)entidade);
        parameters.addValue("EXERCICIO", (Object)exercicio);
        parameters.addValue("DATAINICIAL", (Object)dataInicial.format(this.dtf));
        parameters.addValue("DATAFINAL", (Object)dataFinal.format(this.dtf));
        return (Long)this.jdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, Long.class);
    }

    public Long getTotalGuiasEmitidas(@Param(value="entidade") Long entidade, @Param(value="exercicio") Long exercicio, @Param(value="mes") Long mes) {
        String sql = "SELECT COUNT(*) FROM TRIBBLOQUETO TB WHERE TB.ENTIDADE = :ENTIDADE AND TB.EXERCICIOBLOQUETO = :EXERCICIO AND (TB.DATAEMISSAO >= :DATAINICIAL AND TB.DATAEMISSAO < :DATAFINAL) ";
        return this.getSqlValue(sql, entidade, exercicio, mes);
    }

    public Long getTotalCertidoesEmitidas(@Param(value="entidade") Long entidade, @Param(value="exercicio") Long exercicio, @Param(value="mes") Long mes) {
        String sql = "SELECT COUNT(*) FROM TRIBDOCUMENTO TD WHERE TD.ENTIDADE = :ENTIDADE AND TD.EXERCICIO = :EXERCICIO AND TD.TIPODOCUMENTO IN (2, 33) AND TD.CANCELADO = 'N' AND (TD.DATAEMISSAO >= :DATAINICIAL AND TD.DATAEMISSAO < :DATAFINAL) ";
        return this.getSqlValue(sql, entidade, exercicio, mes);
    }
}

