/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.integracaocontabil;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.integracaocontabil.ArrecadacaoPorLoteDTO;
import br.com.elotech.tributos.dto.integracaocontabil.FiltroArrecadacaoPorLoteDTO;
import br.com.elotech.tributos.dto.integracaocontabil.ResumoArrecadacaoPorLoteDTO;
import br.com.elotech.tributos.util.SqlUtils;
import java.sql.Date;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class ArrecadacaoPorLoteRepository {
    private static final String CONSULTA_ARRECADACAO_LOTE = "br/com/elotech/tributos/repository/integracaocontabil/consulta-arrecadacao-por-lote.sql";
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    public ArrecadacaoPorLoteRepository(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }

    private String generateSql(String sql, String select, String filtro, String group, String order) {
        return String.format(sql, select, filtro, group, order);
    }

    private String generateGroupBy() {
        return "group by lote.entidade,\n         lote.exercicio,\n         lote.lote,\n         lote.datamovimento,\n         contabancaria.contabancaria,\n         contabancaria.descricao,\n         convenio.convenio,\n         convenio.descricao,\n         lote.lotemanual";
    }

    private String generateSelect() {
        return "lote.entidade,\n       lote.exercicio,\n       lote.lote,\n       lote.datamovimento,\n       contabancaria.contabancaria,\n       contabancaria.descricao descricaoConta,\n       convenio.convenio,\n       convenio.descricao descricaoconvenio,\n       case\n         when lote.lotemanual = 'S' then\n           'MANUAL'\n         else\n           'BANCARIO'\n       end tipolote,\n       ";
    }

    private String generateOrder() {
        return "order by lote.datamovimento,\n         contabancaria.contabancaria,\n         lote.exercicio,\n         lote.lote";
    }

    public Page<ArrecadacaoPorLoteDTO> consulta(FiltroArrecadacaoPorLoteDTO filtro, Long entidade, Pageable pageable) {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("entidade", (Object)entidade);
        parameters.addValue("datamovimento", (Object)Date.valueOf(filtro.getDataMovimento()));
        String sql = this.generateSql(FileUtils.readResourceAsString((String)CONSULTA_ARRECADACAO_LOTE), this.generateSelect(), filtro.buildFiltro(), this.generateGroupBy(), this.generateOrder());
        String sqlContagem = String.format("select count(*) as total from (%s) count_query", sql);
        Long numeroTotal = (Long)this.namedParameterJdbcTemplate.queryForObject(sqlContagem, (SqlParameterSource)parameters, (rs, rowNum) -> rs.getLong("total"));
        String sqlComPaginacao = SqlUtils.withPagination((String)sql, (Pageable)pageable, (DataSource)this.namedParameterJdbcTemplate.getJdbcTemplate().getDataSource());
        List pagedRecords = this.namedParameterJdbcTemplate.query(sqlComPaginacao, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(ArrecadacaoPorLoteDTO.class));
        return new PageImpl(pagedRecords, pageable, numeroTotal.longValue());
    }

    public ResumoArrecadacaoPorLoteDTO resumo(FiltroArrecadacaoPorLoteDTO filtro, Long entidade) {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("entidade", (Object)entidade);
        parameters.addValue("datamovimento", (Object)Date.valueOf(filtro.getDataMovimento()));
        String sql = this.generateSql(FileUtils.readResourceAsString((String)CONSULTA_ARRECADACAO_LOTE), "", filtro.buildFiltro(), "", "");
        return (ResumoArrecadacaoPorLoteDTO)this.namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(ResumoArrecadacaoPorLoteDTO.class));
    }
}

