/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.atendimento;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.DebitoEmAbertoDTO;
import br.com.elotech.tributos.repository.atendimento.AtendimentoCustomRepository;
import java.util.List;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class AtendimentoRepositoryImpl
implements AtendimentoCustomRepository {
    private static final String TOTAL_PARCELAMENTO = "br/com/elotech/tributos/repository/parcelamento-total-debito.sql";
    private final JdbcTemplate jdbcTemplate;

    public AtendimentoRepositoryImpl(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public List<DebitoEmAbertoDTO> findTotalParcelamentosEmAberto(Long idCadastro) {
        String sql = FileUtils.readResourceAsString((String)TOTAL_PARCELAMENTO);
        return this.jdbcTemplate.query(sql, new Object[]{idCadastro}, (RowMapper)new ElotechBeanPropertyRowMapper(DebitoEmAbertoDTO.class));
    }
}

