/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository;

import br.com.elotech.core.jpa.hibernate.HibernateUtils;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.calculo.domain.TabelaValor;
import br.com.elotech.tributos.calculo.domain.TabelaValorCelula;
import br.com.elotech.tributos.calculo.domain.TabelaValorColuna;
import br.com.elotech.tributos.calculo.repository.CalculoTributoRepository;
import br.com.elotech.tributos.calculo.repository.TabelaValorRepository;
import br.com.elotech.tributos.domain.Divida;
import br.com.elotech.tributos.domain.LogViradaExercicio;
import br.com.elotech.tributos.domain.Tributo;
import br.com.elotech.tributos.domain.calculo.CalculoTributo;
import br.com.elotech.tributos.domain.calculo.CalculoTributoScript;
import br.com.elotech.tributos.dto.ViradaExercicioDTO;
import br.com.elotech.tributos.enums.TabelaViradaExercicio;
import br.com.elotech.tributos.repository.DividaRepository;
import br.com.elotech.tributos.repository.LogViradaExercicioRepository;
import br.com.elotech.tributos.repository.TributoRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.exception.ViradaExercicioException;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.persistence.EntityManager;
import javax.sql.DataSource;
import javax.transaction.Transactional;
import lombok.Generated;
import org.apache.commons.beanutils.BeanUtils;
import org.hibernate.dialect.Dialect;
import org.hibernate.internal.SessionImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.support.DatabaseType;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.support.MetaDataAccessException;
import org.springframework.stereotype.Repository;

/*
 * Exception performing whole class analysis ignored.
 */
@Repository
public class ViradaExercicioRepository {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ViradaExercicioRepository.class);
    private static final String SELECT = "SELECT %s FROM %s WHERE exercicio = :exercicioAtual";
    private static final String INSERT = "INSERT INTO %s(%s) (%s)";
    private static final String VIRADA_ALREADY_EXECUTED = "Virada de exerc\u00edcio j\u00e1 executada para o exerc\u00edcio de %s";
    private static final String SQL_UPDATE_CNAE_POSTGRES = "sql/UpdateCnaeViradaExercicioPostgres.sql";
    private static final String SQL_UPDATE_CNAE_ORACLE = "sql/UpdateCnaeViradaExercicioOracle.sql";
    private final NamedParameterJdbcTemplate jdbcTemplate;
    private final EntityManager em;
    private DataSource dataSource;
    private CalculoTributoRepository calculoTributoRepository;
    private DividaRepository dividaRepository;
    private TributoRepository tributoRepository;
    private TabelaValorRepository tabelaValorRepository;
    private LogViradaExercicioRepository logViradaExercicioRepository;

    @Transactional(rollbackOn={Exception.class})
    public Long virarExercicio(ViradaExercicioDTO viradaExercicio) throws SQLException {
        log.info(String.format("Iniciando virada de exerc\u00edcio para o exerc\u00edcio %s", viradaExercicio.getProximoExercicio()));
        LogViradaExercicio logViradaExercicio = this.createLog(viradaExercicio);
        for (TabelaViradaExercicio viradaExercicioEnum : TabelaViradaExercicio.values()) {
            this.copyTable(viradaExercicioEnum, viradaExercicio, logViradaExercicio);
        }
        this.copyTableCalculoTributo(viradaExercicio);
        this.copyTableTabelaValor(viradaExercicio);
        this.updateCnae(logViradaExercicio);
        this.logViradaExercicioRepository.save((Object)logViradaExercicio);
        log.info(String.format("Virada de exerc\u00edcio conclu\u00edda para o exerc\u00edcio %s", viradaExercicio.getProximoExercicio()));
        return viradaExercicio.getProximoExercicio();
    }

    private static Object cloneEntity(Object entityToClone) {
        try {
            return BeanUtils.cloneBean((Object)entityToClone);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            log.error("Erro ao clonar a entidade {}. {}", entityToClone, (Object)e.getMessage());
            throw new ViradaExercicioException(String.format("Erro ao clonar a entidade %s", entityToClone), (Throwable)e);
        }
    }

    private void copyTable(TabelaViradaExercicio viradaExercicioEnum, ViradaExercicioDTO viradaExercicio, LogViradaExercicio logViradaExercicio) throws SQLException {
        log.info(String.format("Gerando inserts para a tabela %s", viradaExercicioEnum.getTableName()));
        String sql = this.generateInsert(viradaExercicioEnum, viradaExercicio.getProximoExercicio());
        logViradaExercicio.setScript(logViradaExercicio.getScript().concat(sql.replace(":exercicioAtual", viradaExercicio.getExercicioAtual().toString()).replace(":novoExercicio", viradaExercicio.getProximoExercicio().toString())));
        log.info(String.format("Inserindo dados na tabela %s", viradaExercicioEnum.getTableName()));
        this.jdbcTemplate.update(sql, (SqlParameterSource)this.getMapSqlParameterSource(viradaExercicio));
    }

    private MapSqlParameterSource getMapSqlParameterSource(ViradaExercicioDTO viradaExercicio) {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("exercicioAtual", (Object)viradaExercicio.getExercicioAtual());
        parameters.addValue("novoExercicio", (Object)viradaExercicio.getProximoExercicio());
        return parameters;
    }

    private String generateInsert(TabelaViradaExercicio viradaExercicioEnum, Long proximoExercicio) throws SQLException {
        List columnNames = this.getColumnNamesByTableName(viradaExercicioEnum);
        String columnsWithComma = String.join((CharSequence)",", columnNames);
        String columnsWithNewExercicio = columnsWithComma.replaceAll("\\bexercicio\\b", ":novoExercicio as exercicio");
        if (this.viradaExercicioAlreadyExecuted(columnsWithComma, proximoExercicio, viradaExercicioEnum.getTableName()).booleanValue()) {
            throw new ViradaExercicioException(String.format("Virada de exerc\u00edcio j\u00e1 executada para o exerc\u00edcio de %s", proximoExercicio));
        }
        if (!((String)viradaExercicioEnum.getSequenceAndColumnName().getKey()).isEmpty()) {
            String sqlSequenceNextVal = this.getSelectSequenceNextValString((String)viradaExercicioEnum.getSequenceAndColumnName().getKey());
            columnsWithNewExercicio = columnsWithNewExercicio.replaceAll(String.format("\\b%s\\b", viradaExercicioEnum.getSequenceAndColumnName().getValue()), String.format("(%s) as %s", sqlSequenceNextVal, viradaExercicioEnum.getSequenceAndColumnName().getValue()));
        }
        String select = String.format("SELECT %s FROM %s WHERE exercicio = :exercicioAtual", columnsWithNewExercicio, viradaExercicioEnum.getTableName());
        return String.format("INSERT INTO %s(%s) (%s)", viradaExercicioEnum.getTableName(), columnsWithComma, select);
    }

    private String getSelectSequenceNextValString(String sequence) {
        SessionImpl session = (SessionImpl)this.em.unwrap(SessionImpl.class);
        Dialect dialect = HibernateUtils.getDialect((SessionImpl)session);
        return dialect.getSelectSequenceNextValString(sequence);
    }

    private Boolean viradaExercicioAlreadyExecuted(String columnsWithComma, Long exercicioAtual, String tableName) {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("exercicioAtual", (Object)exercicioAtual);
        String select = String.format("SELECT %s FROM %s WHERE exercicio = :exercicioAtual", columnsWithComma, tableName);
        return !this.jdbcTemplate.query(select, (SqlParameterSource)parameters, (rs, rowNum) -> rs.getLong("exercicio")).isEmpty();
    }

    private List<String> getColumnNamesByTableName(TabelaViradaExercicio viradaExercicioEnum) throws SQLException {
        DatabaseType dbType = this.getDatabaseType();
        ResultSet resultSet = null;
        try (Connection connection = this.dataSource.getConnection();){
            String schema;
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            String string = schema = DatabaseType.POSTGRES.equals((Object)dbType) || DatabaseType.H2.equals((Object)dbType) ? connection.getSchema() : databaseMetaData.getUserName();
            if (DatabaseType.POSTGRES.equals((Object)dbType)) {
                resultSet = databaseMetaData.getColumns(null, schema, viradaExercicioEnum.getTableName(), null);
            }
            if (DatabaseType.ORACLE.equals((Object)dbType) || DatabaseType.H2.equals((Object)dbType)) {
                resultSet = databaseMetaData.getColumns(null, schema, viradaExercicioEnum.getTableName().toUpperCase(), null);
            }
            if (Objects.isNull(resultSet)) {
                throw new ViradaExercicioException("Erro ao determinar tipo do banco de dados");
            }
            ArrayList<String> columnNames = new ArrayList<String>();
            while (resultSet.next()) {
                String columnName = resultSet.getString("COLUMN_NAME");
                columnNames.add(columnName.toLowerCase());
            }
            this.removeKeyColumns(viradaExercicioEnum, columnNames);
            ArrayList<String> arrayList = columnNames;
            return arrayList;
        }
    }

    private void removeKeyColumns(TabelaViradaExercicio viradaExercicioEnum, List<String> columnNames) {
        for (String columnToExclude : viradaExercicioEnum.getColumnsToExclude()) {
            columnNames.removeIf(column -> column.equalsIgnoreCase(columnToExclude));
        }
    }

    private void copyTableCalculoTributo(ViradaExercicioDTO viradaExercicio) {
        try {
            log.info("Copiando e inserindo dados nas tabelas calculotributo e calculotributoscript");
            if (!this.calculoTributoRepository.findAllByExercicio(viradaExercicio.getProximoExercicio()).isEmpty()) {
                throw new ViradaExercicioException(String.format("Virada de exerc\u00edcio j\u00e1 executada para o exerc\u00edcio de %s", viradaExercicio.getProximoExercicio()));
            }
            for (CalculoTributo calculoTributo : this.calculoTributoRepository.findAllByExercicio(viradaExercicio.getExercicioAtual())) {
                CalculoTributo newCalculoTributo = (CalculoTributo)ViradaExercicioRepository.cloneEntity((Object)calculoTributo);
                ArrayList newScriptList = new ArrayList();
                Divida divida = calculoTributo.getDivida();
                Tributo tributo = calculoTributo.getTributo();
                newCalculoTributo.setId(null);
                newCalculoTributo.setExercicio(viradaExercicio.getProximoExercicio());
                newCalculoTributo.setDivida((Divida)this.dividaRepository.findByEntidadeAndExercicioAndDivida(divida.getEntidade(), viradaExercicio.getProximoExercicio(), divida.getDivida()).orElseThrow(() -> new ViradaExercicioException("D\u00edvida n\u00e3o encontrada")));
                newCalculoTributo.setTributo(this.tributoRepository.findByEntidadeAndExercicioAndTributo(tributo.getEntidade(), viradaExercicio.getProximoExercicio(), tributo.getTributo()));
                calculoTributo.getScript().forEach(script -> {
                    CalculoTributoScript calculoTributoScript = (CalculoTributoScript)ViradaExercicioRepository.cloneEntity((Object)script);
                    calculoTributoScript.setId(null);
                    calculoTributoScript.setCalculoTributo(newCalculoTributo);
                    newScriptList.add(calculoTributoScript);
                });
                newCalculoTributo.setScript(newScriptList);
                this.calculoTributoRepository.save((Object)newCalculoTributo);
            }
        }
        catch (Exception e) {
            log.error("Erro ao copiar e inserir dados nas tabelas calculotributo e calculotributoscript {}", (Object)e.getMessage());
            throw new ViradaExercicioException("N\u00e3o foi poss\u00edvel realizar a virada de exerc\u00edcio", (Throwable)e);
        }
    }

    private void copyTableTabelaValor(ViradaExercicioDTO viradaExercicio) {
        try {
            log.info("Copiando e inserindo dados nas tabelas tabelavalor, tabelavalorcoluna e tabelavalorcelula");
            if (!this.tabelaValorRepository.findAllByExercicio(viradaExercicio.getProximoExercicio()).isEmpty()) {
                throw new ViradaExercicioException(String.format("Virada de exerc\u00edcio j\u00e1 executada para o exerc\u00edcio de %s", viradaExercicio.getProximoExercicio()));
            }
            for (TabelaValor tabelaValor : this.tabelaValorRepository.findAllByExercicio(viradaExercicio.getExercicioAtual())) {
                TabelaValor newTabelaValor = (TabelaValor)ViradaExercicioRepository.cloneEntity((Object)tabelaValor);
                ArrayList newColunaList = new ArrayList();
                newTabelaValor.setId(null);
                newTabelaValor.setExercicio(viradaExercicio.getProximoExercicio());
                tabelaValor.getColunas().forEach(coluna -> {
                    ArrayList newCelulaList = new ArrayList();
                    TabelaValorColuna newTabelaValorColuna = (TabelaValorColuna)ViradaExercicioRepository.cloneEntity((Object)coluna);
                    newTabelaValorColuna.setId(null);
                    newTabelaValorColuna.setTabelaValor(newTabelaValor);
                    newTabelaValorColuna.getCelulas().forEach(celula -> {
                        TabelaValorCelula newTabelaValorCelula = (TabelaValorCelula)ViradaExercicioRepository.cloneEntity((Object)celula);
                        newTabelaValorCelula.setId(null);
                        newTabelaValorCelula.setColuna(newTabelaValorColuna);
                        newCelulaList.add(newTabelaValorCelula);
                    });
                    newTabelaValorColuna.setCelulas(newCelulaList);
                    newColunaList.add(newTabelaValorColuna);
                });
                newTabelaValor.setColunas(newColunaList);
                this.tabelaValorRepository.save((Object)newTabelaValor);
            }
        }
        catch (Exception e) {
            log.error("Erro ao copiar e inserir dados nas tabelas tabelavalor, tabelavalorcoluna e tabelavalorcelula {}", (Object)e.getMessage());
            throw new ViradaExercicioException("Erro ao copiar e inserir dados nas tabelas tabelavalor, tabelavalorcoluna e tabelavalorcelula", (Throwable)e);
        }
    }

    private void updateCnae(LogViradaExercicio logViradaExercicio) {
        DatabaseType dbType = this.getDatabaseType();
        log.info("Iniciando update de CNAE's");
        String sqlUpdateCnae = "";
        if (DatabaseType.POSTGRES.equals((Object)dbType) || DatabaseType.H2.equals((Object)dbType)) {
            sqlUpdateCnae = FileUtils.readResourceAsString((String)"sql/UpdateCnaeViradaExercicioPostgres.sql");
        }
        if (DatabaseType.ORACLE.equals((Object)dbType)) {
            sqlUpdateCnae = FileUtils.readResourceAsString((String)"sql/UpdateCnaeViradaExercicioOracle.sql");
        }
        this.jdbcTemplate.update(sqlUpdateCnae, (SqlParameterSource)new MapSqlParameterSource());
        logViradaExercicio.setScript(logViradaExercicio.getScript().concat(sqlUpdateCnae));
        log.info("Update de CNAE's finalizado");
    }

    private DatabaseType getDatabaseType() {
        DatabaseType databaseType;
        try {
            databaseType = DatabaseType.fromMetaData((DataSource)Objects.requireNonNull(this.jdbcTemplate.getJdbcTemplate().getDataSource()));
        }
        catch (MetaDataAccessException e) {
            throw new ViradaExercicioException("Erro ao extrair os metadados do banco", (Throwable)e);
        }
        if (!Arrays.asList(DatabaseType.ORACLE, DatabaseType.POSTGRES, DatabaseType.H2).contains(databaseType)) {
            throw new ViradaExercicioException("Virada de exerc\u00edcio n\u00e3o implementada para esse tipo de banco de dados.");
        }
        return databaseType;
    }

    private LogViradaExercicio createLog(ViradaExercicioDTO viradaExercicioDTO) {
        LogViradaExercicio logViradaExercicio = new LogViradaExercicio();
        logViradaExercicio.setExercicioAtual(viradaExercicioDTO.getExercicioAtual());
        logViradaExercicio.setNovoExercicio(viradaExercicioDTO.getProximoExercicio());
        logViradaExercicio.setUsuario(SecurityUtils.getUserName());
        logViradaExercicio.setDataVirada(LocalDateTime.now());
        logViradaExercicio.setScript("");
        return logViradaExercicio;
    }

    @Generated
    public ViradaExercicioRepository(NamedParameterJdbcTemplate jdbcTemplate, EntityManager em, DataSource dataSource, CalculoTributoRepository calculoTributoRepository, DividaRepository dividaRepository, TributoRepository tributoRepository, TabelaValorRepository tabelaValorRepository, LogViradaExercicioRepository logViradaExercicioRepository) {
        this.jdbcTemplate = jdbcTemplate;
        this.em = em;
        this.dataSource = dataSource;
        this.calculoTributoRepository = calculoTributoRepository;
        this.dividaRepository = dividaRepository;
        this.tributoRepository = tributoRepository;
        this.tabelaValorRepository = tabelaValorRepository;
        this.logViradaExercicioRepository = logViradaExercicioRepository;
    }
}

