/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.domain.ConsultaDebitoTipoAgrupamento;
import br.com.elotech.tributos.dto.ConsultaDebitoItemDTO;
import br.com.elotech.tributos.dto.ConsultaDebitoValoresDTO;
import br.com.elotech.tributos.repository.ConsultaDebitoCustomRepository;
import br.com.elotech.tributos.repository.ConsultaDebitoRepositoryImpl;
import br.com.elotech.tributos.util.SqlUtils;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class ConsultaDebitoRepositoryImpl
implements ConsultaDebitoCustomRepository {
    private static final String SQL_CONSULTA_DEBITO = "br/com/elotech/tributos/repository/find-consulta-debito.sql";
    private static final String ID_CONSULTA = "idConsulta";
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    public ConsultaDebitoRepositoryImpl(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }

    public ConsultaDebitoValoresDTO getResumo(Long idConsulta) {
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        parameterSource.addValue(ID_CONSULTA, (Object)idConsulta);
        String sql = String.format(FileUtils.readResourceAsString((String)SQL_CONSULTA_DEBITO), "", "", "");
        return (ConsultaDebitoValoresDTO)this.namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameterSource, (RowMapper)new ElotechBeanPropertyRowMapper(ConsultaDebitoValoresDTO.class));
    }

    public Page<ConsultaDebitoItemDTO> findDebitos(Long idConsulta, String tipoAgrupamento, Pageable pageable) {
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        parameterSource.addValue(ID_CONSULTA, (Object)idConsulta);
        String query = String.format(FileUtils.readResourceAsString((String)SQL_CONSULTA_DEBITO), this.getSelectFields(tipoAgrupamento), this.getGroupByFields(tipoAgrupamento), this.getOrderByFields(tipoAgrupamento));
        String queryCount = String.format("select count(*) as total from (%s) queryCount", query);
        Long sqlCount = (Long)this.namedParameterJdbcTemplate.queryForObject(queryCount, (SqlParameterSource)parameterSource, (rs, rowNum) -> rs.getLong("total"));
        String pagedQuery = SqlUtils.withPagination((String)query, (Pageable)pageable, (DataSource)this.namedParameterJdbcTemplate.getJdbcTemplate().getDataSource());
        List pagedContent = this.namedParameterJdbcTemplate.query(pagedQuery, (SqlParameterSource)parameterSource, (RowMapper)new ElotechBeanPropertyRowMapper(ConsultaDebitoItemDTO.class));
        return new PageImpl(pagedContent, pageable, sqlCount.longValue());
    }

    private String getSelectFields(String tipoAgrupamento) {
        switch (1.$SwitchMap$br$com$elotech$tributos$domain$ConsultaDebitoTipoAgrupamento[ConsultaDebitoTipoAgrupamento.fromValue((String)tipoAgrupamento).ordinal()]) {
            case 1: {
                return "consultadebitoitem.tipocadastro, \nconsultadebitoitem.cadastrogeral, \nconsultadebitoitem.pessoa, \npessoa.nome, ";
            }
            case 2: {
                return "consultadebitoitem.pessoa, \npessoa.nome, ";
            }
            case 3: {
                return "consultadebitoitem.exercicio, \nconsultadebitoitem.divida, \ndivida.descricao as descricaoDivida, ";
            }
            case 4: {
                return "consultadebitoitem.tipotributo, \ntipoTributo.descricao as descricaoTipoTributo, \nconsultadebitoitem.situacaolegal, ";
            }
            case 5: {
                return "consultadebitoitem.pessoa, \npessoa.nome, \npessoa.cnpj_cpf as cpfCnpj, ";
            }
        }
        return "";
    }

    private String getGroupByFields(String tipoAgrupamento) {
        switch (1.$SwitchMap$br$com$elotech$tributos$domain$ConsultaDebitoTipoAgrupamento[ConsultaDebitoTipoAgrupamento.fromValue((String)tipoAgrupamento).ordinal()]) {
            case 1: {
                return "GROUP BY  consultadebitoitem.tipocadastro, \nconsultadebitoitem.cadastrogeral, \nconsultadebitoitem.pessoa, \npessoa.nome ";
            }
            case 2: {
                return "GROUP BY consultadebitoitem.pessoa, \npessoa.nome ";
            }
            case 3: {
                return "GROUP BY consultadebitoitem.exercicio, \nconsultadebitoitem.divida, \ndivida.descricao ";
            }
            case 4: {
                return "GROUP BY consultadebitoitem.situacaolegal, \ntipoTributo.descricao, \nconsultadebitoitem.tipotributo ";
            }
            case 5: {
                return "GROUP BY consultadebitoitem.pessoa, \npessoa.nome, \npessoa.cnpj_cpf ";
            }
        }
        return "";
    }

    private String getOrderByFields(String tipoAgrupamento) {
        return this.getGroupByFields(tipoAgrupamento).replace("GROUP BY", "ORDER BY");
    }
}

