/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.rsql.RsqlUtils;
import br.com.elotech.core.rsql.extractor.AttributeGetterResult;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.domain.JobType;
import br.com.elotech.tributos.dto.BatchInstanceDTO;
import br.com.elotech.tributos.dto.HistoricoBatchDTO;
import br.com.elotech.tributos.repository.BatchRepository;
import br.com.elotech.tributos.util.RsqlOperatorUtils;
import br.com.elotech.tributos.util.SqlUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobParameters;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class BatchRepository {
    private static final String FIND_PARAMS_FROM_ID = "SELECT JOB_EXECUTION_ID, KEY_NAME, TYPE_CD, STRING_VAL, DATE_VAL, LONG_VAL, DOUBLE_VAL, IDENTIFYING FROM TRIB_JOB_EXECUTION_PARAMS WHERE JOB_EXECUTION_ID = :executionId";
    private static final String FIND_INSTANCE_ID = "SELECT JOB_INSTANCE_ID FROM TRIB_JOB_EXECUTION WHERE JOB_EXECUTION_ID = :executionId";
    private static final String SQL_CONSULTA_BATCH_LAST_EXECUTION = "br/com/elotech/tributos/repository/find-batch-last-instance-execution.sql";
    private static final String SQL_CONSULTA_BATCH_EXECUTIONS_BY_INSTANCE = "br/com/elotech/tributos/repository/find-batch-executions-by-instance.sql";
    private final NamedParameterJdbcTemplate jdbcTemplate;

    public BatchRepository(NamedParameterJdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public Page<BatchInstanceDTO> getTarefas(String search, Pageable pageable) {
        String parameter;
        int index;
        List filterInstanceId = RsqlUtils.getFieldValues((String)search, (String)"instanceId");
        List filterTarefa = RsqlUtils.getFieldValues((String)search, (String)"tarefa");
        List filterStatus = RsqlUtils.getFieldValues((String)search, (String)"status");
        String sql = FileUtils.readResourceAsString((String)SQL_CONSULTA_BATCH_LAST_EXECUTION);
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        ArrayList<String> whereClauses = new ArrayList<String>();
        for (index = 0; index < filterInstanceId.size(); ++index) {
            parameter = String.format("instanceId%s", index);
            Long instanceId = Long.valueOf(((AttributeGetterResult)filterInstanceId.get(index)).getValue());
            whereClauses.add(String.format(" bji.job_instance_id %s :%s ", ((AttributeGetterResult)filterInstanceId.get(index)).getOperator(), parameter));
            parameters.addValue(parameter, (Object)instanceId);
        }
        for (index = 0; index < filterStatus.size(); ++index) {
            parameter = String.format("status%s", index);
            BatchStatus status = BatchStatus.valueOf((String)((AttributeGetterResult)filterStatus.get(index)).getValue());
            whereClauses.add(String.format(" bje.status %s :%s ", ((AttributeGetterResult)filterStatus.get(index)).getOperator(), parameter));
            parameters.addValue(parameter, (Object)status.name());
        }
        for (index = 0; index < filterTarefa.size(); ++index) {
            parameter = String.format("jobName%s", index);
            JobType type = JobType.fromName((String)((AttributeGetterResult)filterTarefa.get(index)).getValue());
            whereClauses.add(String.format(" bji.job_name %s :%s ", ((AttributeGetterResult)filterTarefa.get(index)).getOperator(), parameter));
            parameters.addValue(parameter, (Object)type.getTipo());
        }
        String sqlComParametros = whereClauses.isEmpty() ? sql : String.format("%s where %s", sql, String.join((CharSequence)" and ", whereClauses));
        String sqlWithOperators = RsqlOperatorUtils.replaceOperatorsRsqlToSql((String)sqlComParametros);
        String sqlContagem = String.format("select count(*) as total from (%s) count_query", sqlWithOperators);
        Long numeroTotal = (Long)this.jdbcTemplate.queryForObject(sqlContagem, (SqlParameterSource)parameters, (rs, rowNum) -> rs.getLong("total"));
        String sqlComOrder = String.format("%s order by bji.JOB_INSTANCE_ID desc", sqlWithOperators);
        String sqlComPaginacao = SqlUtils.withPagination((String)sqlComOrder, (Pageable)pageable, (DataSource)this.jdbcTemplate.getJdbcTemplate().getDataSource());
        List pagedRecords = this.jdbcTemplate.query(sqlComPaginacao, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(BatchInstanceDTO.class));
        pagedRecords.forEach(batchAtividadesProcessamento -> {
            batchAtividadesProcessamento.setType(JobType.fromType((String)batchAtividadesProcessamento.getNomeJob()));
            JobParameters parameters1 = this.getJobParameters(batchAtividadesProcessamento.getExecutionId());
            batchAtividadesProcessamento.setJobParameters(parameters1);
        });
        return new PageImpl(pagedRecords, pageable, numeroTotal.longValue());
    }

    public JobParameters getJobParameters(Long executionId) {
        HashMap map = new HashMap();
        1 handler = new /* Unavailable Anonymous Inner Class!! */;
        HashMap<String, Long> parameters = new HashMap<String, Long>();
        parameters.put("executionId", executionId);
        this.jdbcTemplate.query(FIND_PARAMS_FROM_ID, parameters, (RowCallbackHandler)handler);
        return new JobParameters(map);
    }

    public List<HistoricoBatchDTO> findHistoricoExecutionByInstanceId(Long instanceId) {
        String sql = FileUtils.readResourceAsString((String)SQL_CONSULTA_BATCH_EXECUTIONS_BY_INSTANCE);
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("instanceId", (Object)instanceId);
        return this.jdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(HistoricoBatchDTO.class));
    }

    public Long getJobInstanceId(Long executionId) {
        HashMap<String, Long> parameters = new HashMap<String, Long>();
        parameters.put("executionId", executionId);
        return (Long)this.jdbcTemplate.queryForObject(FIND_INSTANCE_ID, parameters, (rs, rowNum) -> rs.getLong("JOB_INSTANCE_ID"));
    }
}

