/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.report.loader;

import br.com.elotech.tributos.domain.Entidade;
import br.com.elotech.tributos.domain.EntidadeTributacao;
import br.com.elotech.tributos.repository.EntidadeRepository;
import br.com.elotech.tributos.service.EntidadeTributacaoService;
import br.com.elotech.tributos.service.ExercicioService;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.springframework.stereotype.Component;

@Component
public class EspelhoImobiliarioParamLoader {
    private static final String PARAM_FORMAT = "%s=%s%n";
    private final EntidadeRepository entidadeRepository;
    private final ExercicioService exercicioService;
    private final EntidadeTributacaoService entidadeTributacaoService;

    public EspelhoImobiliarioParamLoader(EntidadeRepository entidadeRepository, ExercicioService exercicioService, EntidadeTributacaoService entidadeTributacaoService) {
        this.entidadeRepository = entidadeRepository;
        this.exercicioService = exercicioService;
        this.entidadeTributacaoService = entidadeTributacaoService;
    }

    public String load() {
        Entidade entidadeprincipal = this.entidadeRepository.findByEntidadeprincipal();
        String unidadeFederacaoDescr = this.entidadeRepository.findDescricaoUfEntidadeprincipal();
        Long exercicio = this.exercicioService.getExercicio();
        EntidadeTributacao entidadeTributacao = this.entidadeTributacaoService.findByEntidadeIdAndExercicio(entidadeprincipal.getId(), exercicio);
        return String.format(PARAM_FORMAT, "PNomeEntidade", entidadeprincipal.getNome()).concat(String.format(PARAM_FORMAT, "PDescUF", unidadeFederacaoDescr)).concat(String.format(PARAM_FORMAT, "PExercicio", exercicio)).concat(String.format(PARAM_FORMAT, "PDataTitulo", String.format("Atual - %s", this.formattedDate()))).concat(String.format(PARAM_FORMAT, "PMascaraInscricao", entidadeTributacao.getMascaraInscricaoCadastral()));
    }

    public String formattedDate() {
        return LocalDateTime.now().format(DateTimeFormatter.ofPattern("dd/MM/yyyy hh:mm:ss"));
    }
}

