/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.report.loader;

import br.com.elotech.tributos.domain.Cidade;
import br.com.elotech.tributos.domain.Entidade;
import br.com.elotech.tributos.repository.EntidadeRepository;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class ComunicadoParamLoader {
    private static final String PARAM_NOME_ENTIDADE = "PNomeEntidade";
    private static final String PARAM_DESC_UF = "PDescUF";
    private static final String PARAM_CIDADE = "PCidade";
    private static final String PARAM_SEGUNDA_VIA = "PEhSegundaVia";
    private static final String PARAM_DATA = "PData";
    private static final String PARAM_MASK_CNPJ = "PMaskCNPJ";
    private static final String MASCARA_CNPJ = "XX.XXX.XXX/XXXX-XX";
    private static final String PARAM_FORMAT = "%s=%s%n";
    private final EntidadeRepository entidadeRepository;

    public String load() {
        Entidade entidadePrincipal = this.entidadeRepository.findByEntidadeprincipal();
        String descricaoUF = this.entidadeRepository.findDescricaoUfEntidadeprincipal();
        return String.format(PARAM_FORMAT, PARAM_NOME_ENTIDADE, entidadePrincipal.getNome()).concat(String.format(PARAM_FORMAT, PARAM_DESC_UF, "Estado do " + descricaoUF)).concat(String.format(PARAM_FORMAT, PARAM_CIDADE, this.getDescricaoCidade(entidadePrincipal.getCidade()))).concat(String.format(PARAM_FORMAT, PARAM_SEGUNDA_VIA, "N")).concat(String.format(PARAM_FORMAT, PARAM_DATA, String.format("Atual - %s", this.getFormattedDate()))).concat(String.format(PARAM_FORMAT, PARAM_MASK_CNPJ, MASCARA_CNPJ));
    }

    private String getDescricaoCidade(Cidade cidade) {
        return Optional.ofNullable(cidade).map(Cidade::getDescricao).orElse("");
    }

    private String getFormattedDate() {
        return LocalDateTime.now().format(DateTimeFormatter.ofPattern("dd/MM/yyyy hh:mm:ss"));
    }

    @Generated
    public ComunicadoParamLoader(EntidadeRepository entidadeRepository) {
        this.entidadeRepository = entidadeRepository;
    }
}

