/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.parcelamento;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.parcelamento.ParamParcelamento;
import br.com.elotech.tributos.domain.parcelamento.Parcelamento;
import br.com.elotech.tributos.dto.parcelamento.ParcelamentoDebitoParcelasDTO;
import br.com.elotech.tributos.dto.parcelamento.ParcelamentoPassivelQuitacaoDTO;
import io.jsonwebtoken.lang.Assert;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import lombok.Generated;

public class ImpressaoBoletoParcelamentoDTO {
    private Long tipoCadastro;
    private Long cadastroGeral;
    @Min(value=1L, message="Informe a quantidade de parcelas")
    private @Min(value=1L, message="Informe a quantidade de parcelas") Integer quantidadeParcelas;
    private LocalDate dataParcelamento;
    @NotNull(message="Informe a data de vencimento inicial")
    private @NotNull(message="Informe a data de vencimento inicial") LocalDate vencimentoInicial;
    @NotNull(message="Informe a data de vencimento final")
    private @NotNull(message="Informe a data de vencimento final") LocalDate vencimentoFinal;
    @NotNull(message="Informe a forma de pagamento")
    private @NotNull(message="Informe a forma de pagamento") Long formaPagamento;
    @NotEmpty(message="Informe ao menos um contrato")
    private @NotEmpty(message="Informe ao menos um contrato") List<ParcelamentoPassivelQuitacaoDTO> parcelamentos = new ArrayList();

    public static ImpressaoBoletoParcelamentoDTO of(Parcelamento parcelamento, ParamParcelamento paramParcelamento, List<ParcelamentoDebitoParcelasDTO> parcelasDTO) {
        Assert.notNull((Object)parcelamento.getCadastroGeral().getTipoCadastro(), (String)"Erro ao fazer convers\u00e3o de dados: Tipo Cadastro est\u00e1 nulo.");
        Assert.notNull((Object)parcelamento.getCadastroGeral().getCadastroGeral(), (String)"Erro ao fazer convers\u00e3o de dados: Cadastro Geral est\u00e1 nulo.");
        Assert.notNull((Object)parcelamento.getDataParcelamento(), (String)"Erro ao fazer convers\u00e3o de dados: Data Parcelamento est\u00e1 nulo.");
        Assert.notNull((Object)paramParcelamento.getFormaPagamento(), (String)"Erro ao fazer convers\u00e3o de dados: Forma Pagamento est\u00e1 nulo.");
        ImpressaoBoletoParcelamentoDTO dto = new ImpressaoBoletoParcelamentoDTO();
        dto.setTipoCadastro(parcelamento.getCadastroGeral().getTipoCadastro().getValue());
        dto.setCadastroGeral(parcelamento.getCadastroGeral().getCadastroGeral());
        dto.setDataParcelamento(parcelamento.getDataParcelamento());
        dto.setFormaPagamento(paramParcelamento.getFormaPagamento().getId());
        if (parcelasDTO.isEmpty()) {
            throw new EloValidationException("N\u00e3o foi encontrado parcelas do d\u00e9bito para o parcelamento.");
        }
        List parcelasEmAberto = parcelasDTO.stream().filter(ParcelamentoDebitoParcelasDTO::getAberto).collect(Collectors.toList());
        Integer parcelasPagas = parcelasDTO.size() - parcelasEmAberto.size();
        if (parcelasEmAberto.isEmpty()) {
            throw new EloValidationException("N\u00e3o foi encontrado parcelas em aberto para o parcelamento.");
        }
        dto.setQuantidadeParcelas(Integer.valueOf(parcelasEmAberto.size()));
        parcelasEmAberto.stream().min(Comparator.comparing(ParcelamentoDebitoParcelasDTO::getDataVencimento)).map(ParcelamentoDebitoParcelasDTO::getDataVencimento).ifPresent(arg_0 -> dto.setVencimentoInicial(arg_0));
        parcelasEmAberto.stream().max(Comparator.comparing(ParcelamentoDebitoParcelasDTO::getDataVencimento)).map(ParcelamentoDebitoParcelasDTO::getDataVencimento).ifPresent(arg_0 -> dto.setVencimentoFinal(arg_0));
        ParcelamentoPassivelQuitacaoDTO parcelamentoPassivelQuitacaoDTO = ParcelamentoPassivelQuitacaoDTO.of((Parcelamento)parcelamento, (ParamParcelamento)paramParcelamento, (Integer)parcelasEmAberto.size(), (Integer)parcelasPagas);
        dto.setParcelamentos(Collections.singletonList(parcelamentoPassivelQuitacaoDTO));
        return dto;
    }

    @Generated
    public ImpressaoBoletoParcelamentoDTO() {
    }

    @Generated
    public Long getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public Integer getQuantidadeParcelas() {
        return this.quantidadeParcelas;
    }

    @Generated
    public LocalDate getDataParcelamento() {
        return this.dataParcelamento;
    }

    @Generated
    public LocalDate getVencimentoInicial() {
        return this.vencimentoInicial;
    }

    @Generated
    public LocalDate getVencimentoFinal() {
        return this.vencimentoFinal;
    }

    @Generated
    public Long getFormaPagamento() {
        return this.formaPagamento;
    }

    @Generated
    public List<ParcelamentoPassivelQuitacaoDTO> getParcelamentos() {
        return this.parcelamentos;
    }

    @Generated
    public void setTipoCadastro(Long tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setQuantidadeParcelas(Integer quantidadeParcelas) {
        this.quantidadeParcelas = quantidadeParcelas;
    }

    @Generated
    public void setDataParcelamento(LocalDate dataParcelamento) {
        this.dataParcelamento = dataParcelamento;
    }

    @Generated
    public void setVencimentoInicial(LocalDate vencimentoInicial) {
        this.vencimentoInicial = vencimentoInicial;
    }

    @Generated
    public void setVencimentoFinal(LocalDate vencimentoFinal) {
        this.vencimentoFinal = vencimentoFinal;
    }

    @Generated
    public void setFormaPagamento(Long formaPagamento) {
        this.formaPagamento = formaPagamento;
    }

    @Generated
    public void setParcelamentos(List<ParcelamentoPassivelQuitacaoDTO> parcelamentos) {
        this.parcelamentos = parcelamentos;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImpressaoBoletoParcelamentoDTO)) {
            return false;
        }
        ImpressaoBoletoParcelamentoDTO other = (ImpressaoBoletoParcelamentoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$tipoCadastro = this.getTipoCadastro();
        Long other$tipoCadastro = other.getTipoCadastro();
        if (this$tipoCadastro == null ? other$tipoCadastro != null : !((Object)this$tipoCadastro).equals(other$tipoCadastro)) {
            return false;
        }
        Long this$cadastroGeral = this.getCadastroGeral();
        Long other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !((Object)this$cadastroGeral).equals(other$cadastroGeral)) {
            return false;
        }
        Integer this$quantidadeParcelas = this.getQuantidadeParcelas();
        Integer other$quantidadeParcelas = other.getQuantidadeParcelas();
        if (this$quantidadeParcelas == null ? other$quantidadeParcelas != null : !((Object)this$quantidadeParcelas).equals(other$quantidadeParcelas)) {
            return false;
        }
        LocalDate this$dataParcelamento = this.getDataParcelamento();
        LocalDate other$dataParcelamento = other.getDataParcelamento();
        if (this$dataParcelamento == null ? other$dataParcelamento != null : !((Object)this$dataParcelamento).equals(other$dataParcelamento)) {
            return false;
        }
        LocalDate this$vencimentoInicial = this.getVencimentoInicial();
        LocalDate other$vencimentoInicial = other.getVencimentoInicial();
        if (this$vencimentoInicial == null ? other$vencimentoInicial != null : !((Object)this$vencimentoInicial).equals(other$vencimentoInicial)) {
            return false;
        }
        LocalDate this$vencimentoFinal = this.getVencimentoFinal();
        LocalDate other$vencimentoFinal = other.getVencimentoFinal();
        if (this$vencimentoFinal == null ? other$vencimentoFinal != null : !((Object)this$vencimentoFinal).equals(other$vencimentoFinal)) {
            return false;
        }
        Long this$formaPagamento = this.getFormaPagamento();
        Long other$formaPagamento = other.getFormaPagamento();
        if (this$formaPagamento == null ? other$formaPagamento != null : !((Object)this$formaPagamento).equals(other$formaPagamento)) {
            return false;
        }
        List this$parcelamentos = this.getParcelamentos();
        List other$parcelamentos = other.getParcelamentos();
        return !(this$parcelamentos == null ? other$parcelamentos != null : !((Object)this$parcelamentos).equals(other$parcelamentos));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ImpressaoBoletoParcelamentoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $tipoCadastro = this.getTipoCadastro();
        result = result * 59 + ($tipoCadastro == null ? 43 : ((Object)$tipoCadastro).hashCode());
        Long $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : ((Object)$cadastroGeral).hashCode());
        Integer $quantidadeParcelas = this.getQuantidadeParcelas();
        result = result * 59 + ($quantidadeParcelas == null ? 43 : ((Object)$quantidadeParcelas).hashCode());
        LocalDate $dataParcelamento = this.getDataParcelamento();
        result = result * 59 + ($dataParcelamento == null ? 43 : ((Object)$dataParcelamento).hashCode());
        LocalDate $vencimentoInicial = this.getVencimentoInicial();
        result = result * 59 + ($vencimentoInicial == null ? 43 : ((Object)$vencimentoInicial).hashCode());
        LocalDate $vencimentoFinal = this.getVencimentoFinal();
        result = result * 59 + ($vencimentoFinal == null ? 43 : ((Object)$vencimentoFinal).hashCode());
        Long $formaPagamento = this.getFormaPagamento();
        result = result * 59 + ($formaPagamento == null ? 43 : ((Object)$formaPagamento).hashCode());
        List $parcelamentos = this.getParcelamentos();
        result = result * 59 + ($parcelamentos == null ? 43 : ((Object)$parcelamentos).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ImpressaoBoletoParcelamentoDTO(tipoCadastro=" + this.getTipoCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ", quantidadeParcelas=" + this.getQuantidadeParcelas() + ", dataParcelamento=" + this.getDataParcelamento() + ", vencimentoInicial=" + this.getVencimentoInicial() + ", vencimentoFinal=" + this.getVencimentoFinal() + ", formaPagamento=" + this.getFormaPagamento() + ", parcelamentos=" + this.getParcelamentos() + ")";
    }
}

