/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.pagamento;

import br.com.elotech.tributos.domain.Pagamento;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;
import lombok.Generated;

public class PagamentoResumoDTO {
    private Long entidade;
    private Long exercicioPagamento;
    private Long pagamento;
    private Long boleto;
    private Long boletoId;
    private Long idPagamentoBoleto;
    private Long exercicioBoleto;
    private Long contaBancariaId;
    private String contaBancariaDescricao;
    private LocalDate dataMovimento;
    private LocalDate dataPagamento;
    private LocalDate dataCredito;
    private LocalDate dataLote;
    private Long exercicioLote;
    private Long lote;
    private Long sequenciaLote;
    private String usuario;
    private Long motivoDeducaoId;
    private String motivoDeducaoDescricao;
    private Boolean estorno;
    private Boolean pagoAMenor = Boolean.FALSE;
    private BigDecimal valorPagoAMaior = BigDecimal.ZERO;
    private Boolean aptoParaAcerto = Boolean.FALSE;

    public static PagamentoResumoDTO of(Pagamento pagamento) {
        PagamentoResumoDTO dto = new PagamentoResumoDTO();
        dto.setEntidade(pagamento.getId().getEntidade());
        dto.setExercicioPagamento(pagamento.getId().getExercicioPagamento());
        dto.setPagamento(pagamento.getId().getPagamento());
        if (Objects.nonNull(pagamento.getPagamentoBoleto().getBoleto())) {
            dto.setBoleto(pagamento.getPagamentoBoleto().getBoleto().getBloqueto());
            dto.setBoletoId(pagamento.getPagamentoBoleto().getBoleto().getId());
            dto.setExercicioBoleto(pagamento.getPagamentoBoleto().getBoleto().getExercicioBloqueto());
            dto.setIdPagamentoBoleto(pagamento.getPagamentoBoleto().getId());
        }
        dto.setContaBancariaId(pagamento.getContaBancaria().getContaBancaria());
        dto.setContaBancariaDescricao(pagamento.getContaBancaria().getDescricao());
        dto.setDataMovimento(pagamento.getDataMovimento());
        dto.setDataPagamento(pagamento.getDataPagamento());
        dto.setDataCredito(pagamento.getDataCredito());
        dto.setDataLote(pagamento.getLote().getDataLote());
        dto.setLote(pagamento.getLote().getId().getLote());
        dto.setExercicioLote(pagamento.getLote().getId().getExercicio());
        dto.setSequenciaLote(pagamento.getSequenciaLote());
        dto.setUsuario(pagamento.getUsuario());
        if (Objects.nonNull(pagamento.getPagamentoBoleto().getMotivoDeducao())) {
            dto.setMotivoDeducaoId(pagamento.getPagamentoBoleto().getMotivoDeducao().getId());
            dto.setMotivoDeducaoDescricao(pagamento.getPagamentoBoleto().getMotivoDeducao().getDescricao());
        }
        pagamento.getPagamentoBoleto().getPagamentosDebito().stream().findFirst().ifPresent(debitos -> dto.setEstorno(debitos.getEstorno()));
        dto.setPagoAMenor(pagamento.getPagoAMenor());
        dto.setValorPagoAMaior(pagamento.getValorPagoAMaior());
        return dto;
    }

    @Generated
    public PagamentoResumoDTO() {
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicioPagamento() {
        return this.exercicioPagamento;
    }

    @Generated
    public Long getPagamento() {
        return this.pagamento;
    }

    @Generated
    public Long getBoleto() {
        return this.boleto;
    }

    @Generated
    public Long getBoletoId() {
        return this.boletoId;
    }

    @Generated
    public Long getIdPagamentoBoleto() {
        return this.idPagamentoBoleto;
    }

    @Generated
    public Long getExercicioBoleto() {
        return this.exercicioBoleto;
    }

    @Generated
    public Long getContaBancariaId() {
        return this.contaBancariaId;
    }

    @Generated
    public String getContaBancariaDescricao() {
        return this.contaBancariaDescricao;
    }

    @Generated
    public LocalDate getDataMovimento() {
        return this.dataMovimento;
    }

    @Generated
    public LocalDate getDataPagamento() {
        return this.dataPagamento;
    }

    @Generated
    public LocalDate getDataCredito() {
        return this.dataCredito;
    }

    @Generated
    public LocalDate getDataLote() {
        return this.dataLote;
    }

    @Generated
    public Long getExercicioLote() {
        return this.exercicioLote;
    }

    @Generated
    public Long getLote() {
        return this.lote;
    }

    @Generated
    public Long getSequenciaLote() {
        return this.sequenciaLote;
    }

    @Generated
    public String getUsuario() {
        return this.usuario;
    }

    @Generated
    public Long getMotivoDeducaoId() {
        return this.motivoDeducaoId;
    }

    @Generated
    public String getMotivoDeducaoDescricao() {
        return this.motivoDeducaoDescricao;
    }

    @Generated
    public Boolean getEstorno() {
        return this.estorno;
    }

    @Generated
    public Boolean getPagoAMenor() {
        return this.pagoAMenor;
    }

    @Generated
    public BigDecimal getValorPagoAMaior() {
        return this.valorPagoAMaior;
    }

    @Generated
    public Boolean getAptoParaAcerto() {
        return this.aptoParaAcerto;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicioPagamento(Long exercicioPagamento) {
        this.exercicioPagamento = exercicioPagamento;
    }

    @Generated
    public void setPagamento(Long pagamento) {
        this.pagamento = pagamento;
    }

    @Generated
    public void setBoleto(Long boleto) {
        this.boleto = boleto;
    }

    @Generated
    public void setBoletoId(Long boletoId) {
        this.boletoId = boletoId;
    }

    @Generated
    public void setIdPagamentoBoleto(Long idPagamentoBoleto) {
        this.idPagamentoBoleto = idPagamentoBoleto;
    }

    @Generated
    public void setExercicioBoleto(Long exercicioBoleto) {
        this.exercicioBoleto = exercicioBoleto;
    }

    @Generated
    public void setContaBancariaId(Long contaBancariaId) {
        this.contaBancariaId = contaBancariaId;
    }

    @Generated
    public void setContaBancariaDescricao(String contaBancariaDescricao) {
        this.contaBancariaDescricao = contaBancariaDescricao;
    }

    @Generated
    public void setDataMovimento(LocalDate dataMovimento) {
        this.dataMovimento = dataMovimento;
    }

    @Generated
    public void setDataPagamento(LocalDate dataPagamento) {
        this.dataPagamento = dataPagamento;
    }

    @Generated
    public void setDataCredito(LocalDate dataCredito) {
        this.dataCredito = dataCredito;
    }

    @Generated
    public void setDataLote(LocalDate dataLote) {
        this.dataLote = dataLote;
    }

    @Generated
    public void setExercicioLote(Long exercicioLote) {
        this.exercicioLote = exercicioLote;
    }

    @Generated
    public void setLote(Long lote) {
        this.lote = lote;
    }

    @Generated
    public void setSequenciaLote(Long sequenciaLote) {
        this.sequenciaLote = sequenciaLote;
    }

    @Generated
    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    @Generated
    public void setMotivoDeducaoId(Long motivoDeducaoId) {
        this.motivoDeducaoId = motivoDeducaoId;
    }

    @Generated
    public void setMotivoDeducaoDescricao(String motivoDeducaoDescricao) {
        this.motivoDeducaoDescricao = motivoDeducaoDescricao;
    }

    @Generated
    public void setEstorno(Boolean estorno) {
        this.estorno = estorno;
    }

    @Generated
    public void setPagoAMenor(Boolean pagoAMenor) {
        this.pagoAMenor = pagoAMenor;
    }

    @Generated
    public void setValorPagoAMaior(BigDecimal valorPagoAMaior) {
        this.valorPagoAMaior = valorPagoAMaior;
    }

    @Generated
    public void setAptoParaAcerto(Boolean aptoParaAcerto) {
        this.aptoParaAcerto = aptoParaAcerto;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PagamentoResumoDTO)) {
            return false;
        }
        PagamentoResumoDTO other = (PagamentoResumoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicioPagamento = this.getExercicioPagamento();
        Long other$exercicioPagamento = other.getExercicioPagamento();
        if (this$exercicioPagamento == null ? other$exercicioPagamento != null : !((Object)this$exercicioPagamento).equals(other$exercicioPagamento)) {
            return false;
        }
        Long this$pagamento = this.getPagamento();
        Long other$pagamento = other.getPagamento();
        if (this$pagamento == null ? other$pagamento != null : !((Object)this$pagamento).equals(other$pagamento)) {
            return false;
        }
        Long this$boleto = this.getBoleto();
        Long other$boleto = other.getBoleto();
        if (this$boleto == null ? other$boleto != null : !((Object)this$boleto).equals(other$boleto)) {
            return false;
        }
        Long this$boletoId = this.getBoletoId();
        Long other$boletoId = other.getBoletoId();
        if (this$boletoId == null ? other$boletoId != null : !((Object)this$boletoId).equals(other$boletoId)) {
            return false;
        }
        Long this$idPagamentoBoleto = this.getIdPagamentoBoleto();
        Long other$idPagamentoBoleto = other.getIdPagamentoBoleto();
        if (this$idPagamentoBoleto == null ? other$idPagamentoBoleto != null : !((Object)this$idPagamentoBoleto).equals(other$idPagamentoBoleto)) {
            return false;
        }
        Long this$exercicioBoleto = this.getExercicioBoleto();
        Long other$exercicioBoleto = other.getExercicioBoleto();
        if (this$exercicioBoleto == null ? other$exercicioBoleto != null : !((Object)this$exercicioBoleto).equals(other$exercicioBoleto)) {
            return false;
        }
        Long this$contaBancariaId = this.getContaBancariaId();
        Long other$contaBancariaId = other.getContaBancariaId();
        if (this$contaBancariaId == null ? other$contaBancariaId != null : !((Object)this$contaBancariaId).equals(other$contaBancariaId)) {
            return false;
        }
        String this$contaBancariaDescricao = this.getContaBancariaDescricao();
        String other$contaBancariaDescricao = other.getContaBancariaDescricao();
        if (this$contaBancariaDescricao == null ? other$contaBancariaDescricao != null : !this$contaBancariaDescricao.equals(other$contaBancariaDescricao)) {
            return false;
        }
        LocalDate this$dataMovimento = this.getDataMovimento();
        LocalDate other$dataMovimento = other.getDataMovimento();
        if (this$dataMovimento == null ? other$dataMovimento != null : !((Object)this$dataMovimento).equals(other$dataMovimento)) {
            return false;
        }
        LocalDate this$dataPagamento = this.getDataPagamento();
        LocalDate other$dataPagamento = other.getDataPagamento();
        if (this$dataPagamento == null ? other$dataPagamento != null : !((Object)this$dataPagamento).equals(other$dataPagamento)) {
            return false;
        }
        LocalDate this$dataCredito = this.getDataCredito();
        LocalDate other$dataCredito = other.getDataCredito();
        if (this$dataCredito == null ? other$dataCredito != null : !((Object)this$dataCredito).equals(other$dataCredito)) {
            return false;
        }
        LocalDate this$dataLote = this.getDataLote();
        LocalDate other$dataLote = other.getDataLote();
        if (this$dataLote == null ? other$dataLote != null : !((Object)this$dataLote).equals(other$dataLote)) {
            return false;
        }
        Long this$exercicioLote = this.getExercicioLote();
        Long other$exercicioLote = other.getExercicioLote();
        if (this$exercicioLote == null ? other$exercicioLote != null : !((Object)this$exercicioLote).equals(other$exercicioLote)) {
            return false;
        }
        Long this$lote = this.getLote();
        Long other$lote = other.getLote();
        if (this$lote == null ? other$lote != null : !((Object)this$lote).equals(other$lote)) {
            return false;
        }
        Long this$sequenciaLote = this.getSequenciaLote();
        Long other$sequenciaLote = other.getSequenciaLote();
        if (this$sequenciaLote == null ? other$sequenciaLote != null : !((Object)this$sequenciaLote).equals(other$sequenciaLote)) {
            return false;
        }
        String this$usuario = this.getUsuario();
        String other$usuario = other.getUsuario();
        if (this$usuario == null ? other$usuario != null : !this$usuario.equals(other$usuario)) {
            return false;
        }
        Long this$motivoDeducaoId = this.getMotivoDeducaoId();
        Long other$motivoDeducaoId = other.getMotivoDeducaoId();
        if (this$motivoDeducaoId == null ? other$motivoDeducaoId != null : !((Object)this$motivoDeducaoId).equals(other$motivoDeducaoId)) {
            return false;
        }
        String this$motivoDeducaoDescricao = this.getMotivoDeducaoDescricao();
        String other$motivoDeducaoDescricao = other.getMotivoDeducaoDescricao();
        if (this$motivoDeducaoDescricao == null ? other$motivoDeducaoDescricao != null : !this$motivoDeducaoDescricao.equals(other$motivoDeducaoDescricao)) {
            return false;
        }
        Boolean this$estorno = this.getEstorno();
        Boolean other$estorno = other.getEstorno();
        if (this$estorno == null ? other$estorno != null : !((Object)this$estorno).equals(other$estorno)) {
            return false;
        }
        Boolean this$pagoAMenor = this.getPagoAMenor();
        Boolean other$pagoAMenor = other.getPagoAMenor();
        if (this$pagoAMenor == null ? other$pagoAMenor != null : !((Object)this$pagoAMenor).equals(other$pagoAMenor)) {
            return false;
        }
        BigDecimal this$valorPagoAMaior = this.getValorPagoAMaior();
        BigDecimal other$valorPagoAMaior = other.getValorPagoAMaior();
        if (this$valorPagoAMaior == null ? other$valorPagoAMaior != null : !((Object)this$valorPagoAMaior).equals(other$valorPagoAMaior)) {
            return false;
        }
        Boolean this$aptoParaAcerto = this.getAptoParaAcerto();
        Boolean other$aptoParaAcerto = other.getAptoParaAcerto();
        return !(this$aptoParaAcerto == null ? other$aptoParaAcerto != null : !((Object)this$aptoParaAcerto).equals(other$aptoParaAcerto));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PagamentoResumoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicioPagamento = this.getExercicioPagamento();
        result = result * 59 + ($exercicioPagamento == null ? 43 : ((Object)$exercicioPagamento).hashCode());
        Long $pagamento = this.getPagamento();
        result = result * 59 + ($pagamento == null ? 43 : ((Object)$pagamento).hashCode());
        Long $boleto = this.getBoleto();
        result = result * 59 + ($boleto == null ? 43 : ((Object)$boleto).hashCode());
        Long $boletoId = this.getBoletoId();
        result = result * 59 + ($boletoId == null ? 43 : ((Object)$boletoId).hashCode());
        Long $idPagamentoBoleto = this.getIdPagamentoBoleto();
        result = result * 59 + ($idPagamentoBoleto == null ? 43 : ((Object)$idPagamentoBoleto).hashCode());
        Long $exercicioBoleto = this.getExercicioBoleto();
        result = result * 59 + ($exercicioBoleto == null ? 43 : ((Object)$exercicioBoleto).hashCode());
        Long $contaBancariaId = this.getContaBancariaId();
        result = result * 59 + ($contaBancariaId == null ? 43 : ((Object)$contaBancariaId).hashCode());
        String $contaBancariaDescricao = this.getContaBancariaDescricao();
        result = result * 59 + ($contaBancariaDescricao == null ? 43 : $contaBancariaDescricao.hashCode());
        LocalDate $dataMovimento = this.getDataMovimento();
        result = result * 59 + ($dataMovimento == null ? 43 : ((Object)$dataMovimento).hashCode());
        LocalDate $dataPagamento = this.getDataPagamento();
        result = result * 59 + ($dataPagamento == null ? 43 : ((Object)$dataPagamento).hashCode());
        LocalDate $dataCredito = this.getDataCredito();
        result = result * 59 + ($dataCredito == null ? 43 : ((Object)$dataCredito).hashCode());
        LocalDate $dataLote = this.getDataLote();
        result = result * 59 + ($dataLote == null ? 43 : ((Object)$dataLote).hashCode());
        Long $exercicioLote = this.getExercicioLote();
        result = result * 59 + ($exercicioLote == null ? 43 : ((Object)$exercicioLote).hashCode());
        Long $lote = this.getLote();
        result = result * 59 + ($lote == null ? 43 : ((Object)$lote).hashCode());
        Long $sequenciaLote = this.getSequenciaLote();
        result = result * 59 + ($sequenciaLote == null ? 43 : ((Object)$sequenciaLote).hashCode());
        String $usuario = this.getUsuario();
        result = result * 59 + ($usuario == null ? 43 : $usuario.hashCode());
        Long $motivoDeducaoId = this.getMotivoDeducaoId();
        result = result * 59 + ($motivoDeducaoId == null ? 43 : ((Object)$motivoDeducaoId).hashCode());
        String $motivoDeducaoDescricao = this.getMotivoDeducaoDescricao();
        result = result * 59 + ($motivoDeducaoDescricao == null ? 43 : $motivoDeducaoDescricao.hashCode());
        Boolean $estorno = this.getEstorno();
        result = result * 59 + ($estorno == null ? 43 : ((Object)$estorno).hashCode());
        Boolean $pagoAMenor = this.getPagoAMenor();
        result = result * 59 + ($pagoAMenor == null ? 43 : ((Object)$pagoAMenor).hashCode());
        BigDecimal $valorPagoAMaior = this.getValorPagoAMaior();
        result = result * 59 + ($valorPagoAMaior == null ? 43 : ((Object)$valorPagoAMaior).hashCode());
        Boolean $aptoParaAcerto = this.getAptoParaAcerto();
        result = result * 59 + ($aptoParaAcerto == null ? 43 : ((Object)$aptoParaAcerto).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PagamentoResumoDTO(entidade=" + this.getEntidade() + ", exercicioPagamento=" + this.getExercicioPagamento() + ", pagamento=" + this.getPagamento() + ", boleto=" + this.getBoleto() + ", boletoId=" + this.getBoletoId() + ", idPagamentoBoleto=" + this.getIdPagamentoBoleto() + ", exercicioBoleto=" + this.getExercicioBoleto() + ", contaBancariaId=" + this.getContaBancariaId() + ", contaBancariaDescricao=" + this.getContaBancariaDescricao() + ", dataMovimento=" + this.getDataMovimento() + ", dataPagamento=" + this.getDataPagamento() + ", dataCredito=" + this.getDataCredito() + ", dataLote=" + this.getDataLote() + ", exercicioLote=" + this.getExercicioLote() + ", lote=" + this.getLote() + ", sequenciaLote=" + this.getSequenciaLote() + ", usuario=" + this.getUsuario() + ", motivoDeducaoId=" + this.getMotivoDeducaoId() + ", motivoDeducaoDescricao=" + this.getMotivoDeducaoDescricao() + ", estorno=" + this.getEstorno() + ", pagoAMenor=" + this.getPagoAMenor() + ", valorPagoAMaior=" + this.getValorPagoAMaior() + ", aptoParaAcerto=" + this.getAptoParaAcerto() + ")";
    }
}

