/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.integracaocontabil;

import java.sql.Date;
import java.time.LocalDate;
import java.util.Objects;
import lombok.Generated;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;

public class FiltroDeducaoAnaliticaContribuinteDTO {
    private Long idEntidade;
    private LocalDate dataDeducaoInicial;
    private LocalDate dataDeducaoFinal;
    private static final String WHERE_CLAUSE_ISENCAO = " AND ((TD.DATACONTABILIZACAO >= TDP.DATALANCAMENTO AND %s)  OR (((TD.DATACONTABILIZACAO IS NULL) OR (TD.DATACONTABILIZACAO < TDP.DATALANCAMENTO)) AND  ((TD.DATAINCLUSAO >= TDP.DATALANCAMENTO AND %s)  OR (((TD.DATAINCLUSAO IS NULL) OR (TD.DATAINCLUSAO < TDP.DATALANCAMENTO)) AND %s))))";

    private String addAndClause(String clause) {
        return " AND " + clause;
    }

    public String buildWhereClauseInsencoes() {
        StringBuilder where = new StringBuilder();
        this.buildWhereClause(where);
        if (Objects.isNull(this.dataDeducaoInicial) && Objects.isNull(this.dataDeducaoFinal)) {
            return where.toString();
        }
        if (Objects.nonNull(this.dataDeducaoInicial) && Objects.nonNull(this.dataDeducaoFinal)) {
            where.append(String.format(WHERE_CLAUSE_ISENCAO, "TD.DATACONTABILIZACAO >= :DATADEDUCAOINICIAL AND TD.DATACONTABILIZACAO <= :DATADEDUCAOFINAL", "TD.DATAINCLUSAO >= :DATADEDUCAOINICIAL AND TD.DATAINCLUSAO <= :DATADEDUCAOFINAL", "TDP.DATALANCAMENTO >= :DATADEDUCAOINICIAL AND TDP.DATALANCAMENTO <= :DATADEDUCAOFINAL"));
        }
        if (Objects.nonNull(this.dataDeducaoInicial) && Objects.isNull(this.dataDeducaoFinal)) {
            where.append(String.format(WHERE_CLAUSE_ISENCAO, "TD.DATACONTABILIZACAO >= :DATADEDUCAOINICIAL", "TD.DATAINCLUSAO >= :DATADEDUCAOINICIAL", "TDP.DATALANCAMENTO >= :DATADEDUCAOINICIAL"));
        }
        if (Objects.nonNull(this.dataDeducaoFinal) && Objects.isNull(this.dataDeducaoInicial)) {
            where.append(String.format(WHERE_CLAUSE_ISENCAO, "TD.DATACONTABILIZACAO <= :DATADEDUCAOFINAL", "TD.DATAINCLUSAO <= :DATADEDUCAOFINAL", "TDP.DATALANCAMENTO <= :DATADEDUCAOFINAL"));
        }
        return where.toString();
    }

    public String buildWhereClauseDeducao() {
        StringBuilder where = new StringBuilder();
        this.buildWhereClause(where);
        if (Objects.nonNull(this.dataDeducaoInicial)) {
            where.append(this.addAndClause("TCD.DATACANCELAMENTO >= :DATADEDUCAOINICIAL"));
        }
        if (Objects.nonNull(this.dataDeducaoFinal)) {
            where.append(this.addAndClause("TCD.DATACANCELAMENTO <= :DATADEDUCAOFINAL"));
        }
        return where.toString();
    }

    public String buildWhereClauseDescontos() {
        StringBuilder where = new StringBuilder();
        this.buildWhereClause(where);
        if (Objects.nonNull(this.dataDeducaoInicial)) {
            where.append(this.addAndClause("LIC.DATALOTE >= :DATADEDUCAOINICIAL"));
        }
        if (Objects.nonNull(this.dataDeducaoFinal)) {
            where.append(this.addAndClause("LIC.DATALOTE <= :DATADEDUCAOFINAL"));
        }
        return where.toString();
    }

    public MapSqlParameterSource buildMapSqlParameter() {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        if (Objects.nonNull(this.dataDeducaoInicial)) {
            parameters.addValue("DATADEDUCAOINICIAL", (Object)Date.valueOf(this.dataDeducaoInicial));
        }
        if (Objects.nonNull(this.dataDeducaoFinal)) {
            parameters.addValue("DATADEDUCAOFINAL", (Object)Date.valueOf(this.dataDeducaoFinal));
        }
        if (Objects.nonNull(this.idEntidade)) {
            parameters.addValue("IDENTIDADE", (Object)this.idEntidade);
        }
        return parameters;
    }

    private void buildWhereClause(StringBuilder where) {
        if (Objects.nonNull(this.idEntidade)) {
            where.append(this.addAndClause("TD.ENTIDADE = :IDENTIDADE"));
        }
    }

    @Generated
    public FiltroDeducaoAnaliticaContribuinteDTO() {
    }

    @Generated
    public Long getIdEntidade() {
        return this.idEntidade;
    }

    @Generated
    public LocalDate getDataDeducaoInicial() {
        return this.dataDeducaoInicial;
    }

    @Generated
    public LocalDate getDataDeducaoFinal() {
        return this.dataDeducaoFinal;
    }

    @Generated
    public void setIdEntidade(Long idEntidade) {
        this.idEntidade = idEntidade;
    }

    @Generated
    public void setDataDeducaoInicial(LocalDate dataDeducaoInicial) {
        this.dataDeducaoInicial = dataDeducaoInicial;
    }

    @Generated
    public void setDataDeducaoFinal(LocalDate dataDeducaoFinal) {
        this.dataDeducaoFinal = dataDeducaoFinal;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FiltroDeducaoAnaliticaContribuinteDTO)) {
            return false;
        }
        FiltroDeducaoAnaliticaContribuinteDTO other = (FiltroDeducaoAnaliticaContribuinteDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$idEntidade = this.getIdEntidade();
        Long other$idEntidade = other.getIdEntidade();
        if (this$idEntidade == null ? other$idEntidade != null : !((Object)this$idEntidade).equals(other$idEntidade)) {
            return false;
        }
        LocalDate this$dataDeducaoInicial = this.getDataDeducaoInicial();
        LocalDate other$dataDeducaoInicial = other.getDataDeducaoInicial();
        if (this$dataDeducaoInicial == null ? other$dataDeducaoInicial != null : !((Object)this$dataDeducaoInicial).equals(other$dataDeducaoInicial)) {
            return false;
        }
        LocalDate this$dataDeducaoFinal = this.getDataDeducaoFinal();
        LocalDate other$dataDeducaoFinal = other.getDataDeducaoFinal();
        return !(this$dataDeducaoFinal == null ? other$dataDeducaoFinal != null : !((Object)this$dataDeducaoFinal).equals(other$dataDeducaoFinal));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FiltroDeducaoAnaliticaContribuinteDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $idEntidade = this.getIdEntidade();
        result = result * 59 + ($idEntidade == null ? 43 : ((Object)$idEntidade).hashCode());
        LocalDate $dataDeducaoInicial = this.getDataDeducaoInicial();
        result = result * 59 + ($dataDeducaoInicial == null ? 43 : ((Object)$dataDeducaoInicial).hashCode());
        LocalDate $dataDeducaoFinal = this.getDataDeducaoFinal();
        result = result * 59 + ($dataDeducaoFinal == null ? 43 : ((Object)$dataDeducaoFinal).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FiltroDeducaoAnaliticaContribuinteDTO(idEntidade=" + this.getIdEntidade() + ", dataDeducaoInicial=" + this.getDataDeducaoInicial() + ", dataDeducaoFinal=" + this.getDataDeducaoFinal() + ")";
    }
}

