/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.integracaoboleto.bancodobrasil;

import br.com.elotech.core.enumerable.common.TipoPessoa;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.ContatoPessoa;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.dto.integracaoboleto.bancodobrasil.GerarQrCodePixBBRequestDTO;
import br.com.elotech.tributos.util.CnpjCpfValidator;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang.Validate;

/*
 * Exception performing whole class analysis ignored.
 */
public class GerarQrCodePixBBRequestDTO {
    private Long numeroConvenio;
    private String indicadorCodigoBarras;
    private String codigoGuiaRecebimento;
    private String emailDevedor;
    private Integer codigoPaisTelefoneDevedor;
    private Integer dddTelefoneDevedor;
    private String numeroTelefoneDevedor;
    private String codigoSolicitacaoBancoCentralBrasil;
    private String descricaoSolicitacaoPagamento;
    private BigDecimal valorOriginalSolicitacao;
    private String cpfDevedor;
    private String cnpjDevedor;
    private String nomeDevedor;
    private Long quantidadeSegundoExpiracao;
    private List<InformacaoAdicional> listaInformacaoAdicional;

    public static GerarQrCodePixBBRequestDTO from(Bloqueto bloqueto) {
        Pessoa pessoa = bloqueto.getPessoa();
        ContatoPessoa contatoPrincipal = pessoa.getContatoPrincipal();
        GerarQrCodePixBBRequestDTO dto = GerarQrCodePixBBRequestDTO.builder().numeroConvenio(Long.valueOf(bloqueto.getModeloBloqueto().getConvenio().getNumeroConvenio())).indicadorCodigoBarras("S").codigoGuiaRecebimento(bloqueto.getCodigoBarras()).codigoSolicitacaoBancoCentralBrasil(bloqueto.getModeloBloqueto().getConvenio().getChavePix()).valorOriginalSolicitacao(bloqueto.getValorBloqueto()).emailDevedor((String)Optional.ofNullable(contatoPrincipal).map(ContatoPessoa::getEmail).orElse(null)).build();
        if (Objects.nonNull(contatoPrincipal) && Objects.nonNull(contatoPrincipal.getTelefoneCelular())) {
            dto.setCodigoPaisTelefoneDevedor(Integer.valueOf(55));
            dto.setDddTelefoneDevedor(contatoPrincipal.getDDDCelular());
            dto.setNumeroTelefoneDevedor(contatoPrincipal.getCelularSemDDD());
        }
        if (Objects.nonNull(pessoa.getCnpjCpf()) && CnpjCpfValidator.isValidCnpjCpf((String)pessoa.getCnpjCpf()).booleanValue()) {
            if (TipoPessoa.FISICA.equals((Object)pessoa.getTipoPessoa())) {
                dto.setCpfDevedor(pessoa.getCnpjCpfSemMascara());
            } else if (TipoPessoa.JURIDICA.equals((Object)pessoa.getTipoPessoa())) {
                dto.setCnpjDevedor(pessoa.getCnpjCpfSemMascara());
            }
            dto.setNomeDevedor(pessoa.getNome());
        }
        dto.setQuantidadeSegundoExpiracao(Long.valueOf(LocalDateTime.now().until(bloqueto.getDataVencimento().atTime(LocalTime.MAX), ChronoUnit.SECONDS)));
        GerarQrCodePixBBRequestDTO.validarParametrosObrigatorios((GerarQrCodePixBBRequestDTO)dto);
        return dto;
    }

    private static void validarParametrosObrigatorios(GerarQrCodePixBBRequestDTO dto) {
        Validate.notNull((Object)dto);
        Validate.notNull((Object)dto.getNumeroConvenio(), (String)"O numeroConvenio \u00e9 obrigat\u00f3rio");
        Validate.notNull((Object)dto.getIndicadorCodigoBarras(), (String)"O indicadorCodigoBarras \u00e9 obrigat\u00f3rio");
        Validate.notNull((Object)dto.getCodigoGuiaRecebimento(), (String)"O codigoGuiaRecebimento \u00e9 obrigat\u00f3rio");
        Validate.notNull((Object)dto.getCodigoSolicitacaoBancoCentralBrasil(), (String)"O codigoSolicitacaoBancoCentralBrasil \u00e9 obrigat\u00f3rio");
        Validate.notNull((Object)dto.getValorOriginalSolicitacao(), (String)"O valorOriginalSolicitacao \u00e9 obrigat\u00f3rio");
    }

    @Generated
    GerarQrCodePixBBRequestDTO(Long numeroConvenio, String indicadorCodigoBarras, String codigoGuiaRecebimento, String emailDevedor, Integer codigoPaisTelefoneDevedor, Integer dddTelefoneDevedor, String numeroTelefoneDevedor, String codigoSolicitacaoBancoCentralBrasil, String descricaoSolicitacaoPagamento, BigDecimal valorOriginalSolicitacao, String cpfDevedor, String cnpjDevedor, String nomeDevedor, Long quantidadeSegundoExpiracao, List<InformacaoAdicional> listaInformacaoAdicional) {
        this.numeroConvenio = numeroConvenio;
        this.indicadorCodigoBarras = indicadorCodigoBarras;
        this.codigoGuiaRecebimento = codigoGuiaRecebimento;
        this.emailDevedor = emailDevedor;
        this.codigoPaisTelefoneDevedor = codigoPaisTelefoneDevedor;
        this.dddTelefoneDevedor = dddTelefoneDevedor;
        this.numeroTelefoneDevedor = numeroTelefoneDevedor;
        this.codigoSolicitacaoBancoCentralBrasil = codigoSolicitacaoBancoCentralBrasil;
        this.descricaoSolicitacaoPagamento = descricaoSolicitacaoPagamento;
        this.valorOriginalSolicitacao = valorOriginalSolicitacao;
        this.cpfDevedor = cpfDevedor;
        this.cnpjDevedor = cnpjDevedor;
        this.nomeDevedor = nomeDevedor;
        this.quantidadeSegundoExpiracao = quantidadeSegundoExpiracao;
        this.listaInformacaoAdicional = listaInformacaoAdicional;
    }

    @Generated
    public static GerarQrCodePixBBRequestDTOBuilder builder() {
        return new GerarQrCodePixBBRequestDTOBuilder();
    }

    @Generated
    public Long getNumeroConvenio() {
        return this.numeroConvenio;
    }

    @Generated
    public String getIndicadorCodigoBarras() {
        return this.indicadorCodigoBarras;
    }

    @Generated
    public String getCodigoGuiaRecebimento() {
        return this.codigoGuiaRecebimento;
    }

    @Generated
    public String getEmailDevedor() {
        return this.emailDevedor;
    }

    @Generated
    public Integer getCodigoPaisTelefoneDevedor() {
        return this.codigoPaisTelefoneDevedor;
    }

    @Generated
    public Integer getDddTelefoneDevedor() {
        return this.dddTelefoneDevedor;
    }

    @Generated
    public String getNumeroTelefoneDevedor() {
        return this.numeroTelefoneDevedor;
    }

    @Generated
    public String getCodigoSolicitacaoBancoCentralBrasil() {
        return this.codigoSolicitacaoBancoCentralBrasil;
    }

    @Generated
    public String getDescricaoSolicitacaoPagamento() {
        return this.descricaoSolicitacaoPagamento;
    }

    @Generated
    public BigDecimal getValorOriginalSolicitacao() {
        return this.valorOriginalSolicitacao;
    }

    @Generated
    public String getCpfDevedor() {
        return this.cpfDevedor;
    }

    @Generated
    public String getCnpjDevedor() {
        return this.cnpjDevedor;
    }

    @Generated
    public String getNomeDevedor() {
        return this.nomeDevedor;
    }

    @Generated
    public Long getQuantidadeSegundoExpiracao() {
        return this.quantidadeSegundoExpiracao;
    }

    @Generated
    public List<InformacaoAdicional> getListaInformacaoAdicional() {
        return this.listaInformacaoAdicional;
    }

    @Generated
    public void setNumeroConvenio(Long numeroConvenio) {
        this.numeroConvenio = numeroConvenio;
    }

    @Generated
    public void setIndicadorCodigoBarras(String indicadorCodigoBarras) {
        this.indicadorCodigoBarras = indicadorCodigoBarras;
    }

    @Generated
    public void setCodigoGuiaRecebimento(String codigoGuiaRecebimento) {
        this.codigoGuiaRecebimento = codigoGuiaRecebimento;
    }

    @Generated
    public void setEmailDevedor(String emailDevedor) {
        this.emailDevedor = emailDevedor;
    }

    @Generated
    public void setCodigoPaisTelefoneDevedor(Integer codigoPaisTelefoneDevedor) {
        this.codigoPaisTelefoneDevedor = codigoPaisTelefoneDevedor;
    }

    @Generated
    public void setDddTelefoneDevedor(Integer dddTelefoneDevedor) {
        this.dddTelefoneDevedor = dddTelefoneDevedor;
    }

    @Generated
    public void setNumeroTelefoneDevedor(String numeroTelefoneDevedor) {
        this.numeroTelefoneDevedor = numeroTelefoneDevedor;
    }

    @Generated
    public void setCodigoSolicitacaoBancoCentralBrasil(String codigoSolicitacaoBancoCentralBrasil) {
        this.codigoSolicitacaoBancoCentralBrasil = codigoSolicitacaoBancoCentralBrasil;
    }

    @Generated
    public void setDescricaoSolicitacaoPagamento(String descricaoSolicitacaoPagamento) {
        this.descricaoSolicitacaoPagamento = descricaoSolicitacaoPagamento;
    }

    @Generated
    public void setValorOriginalSolicitacao(BigDecimal valorOriginalSolicitacao) {
        this.valorOriginalSolicitacao = valorOriginalSolicitacao;
    }

    @Generated
    public void setCpfDevedor(String cpfDevedor) {
        this.cpfDevedor = cpfDevedor;
    }

    @Generated
    public void setCnpjDevedor(String cnpjDevedor) {
        this.cnpjDevedor = cnpjDevedor;
    }

    @Generated
    public void setNomeDevedor(String nomeDevedor) {
        this.nomeDevedor = nomeDevedor;
    }

    @Generated
    public void setQuantidadeSegundoExpiracao(Long quantidadeSegundoExpiracao) {
        this.quantidadeSegundoExpiracao = quantidadeSegundoExpiracao;
    }

    @Generated
    public void setListaInformacaoAdicional(List<InformacaoAdicional> listaInformacaoAdicional) {
        this.listaInformacaoAdicional = listaInformacaoAdicional;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GerarQrCodePixBBRequestDTO)) {
            return false;
        }
        GerarQrCodePixBBRequestDTO other = (GerarQrCodePixBBRequestDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$numeroConvenio = this.getNumeroConvenio();
        Long other$numeroConvenio = other.getNumeroConvenio();
        if (this$numeroConvenio == null ? other$numeroConvenio != null : !((Object)this$numeroConvenio).equals(other$numeroConvenio)) {
            return false;
        }
        String this$indicadorCodigoBarras = this.getIndicadorCodigoBarras();
        String other$indicadorCodigoBarras = other.getIndicadorCodigoBarras();
        if (this$indicadorCodigoBarras == null ? other$indicadorCodigoBarras != null : !this$indicadorCodigoBarras.equals(other$indicadorCodigoBarras)) {
            return false;
        }
        String this$codigoGuiaRecebimento = this.getCodigoGuiaRecebimento();
        String other$codigoGuiaRecebimento = other.getCodigoGuiaRecebimento();
        if (this$codigoGuiaRecebimento == null ? other$codigoGuiaRecebimento != null : !this$codigoGuiaRecebimento.equals(other$codigoGuiaRecebimento)) {
            return false;
        }
        String this$emailDevedor = this.getEmailDevedor();
        String other$emailDevedor = other.getEmailDevedor();
        if (this$emailDevedor == null ? other$emailDevedor != null : !this$emailDevedor.equals(other$emailDevedor)) {
            return false;
        }
        Integer this$codigoPaisTelefoneDevedor = this.getCodigoPaisTelefoneDevedor();
        Integer other$codigoPaisTelefoneDevedor = other.getCodigoPaisTelefoneDevedor();
        if (this$codigoPaisTelefoneDevedor == null ? other$codigoPaisTelefoneDevedor != null : !((Object)this$codigoPaisTelefoneDevedor).equals(other$codigoPaisTelefoneDevedor)) {
            return false;
        }
        Integer this$dddTelefoneDevedor = this.getDddTelefoneDevedor();
        Integer other$dddTelefoneDevedor = other.getDddTelefoneDevedor();
        if (this$dddTelefoneDevedor == null ? other$dddTelefoneDevedor != null : !((Object)this$dddTelefoneDevedor).equals(other$dddTelefoneDevedor)) {
            return false;
        }
        String this$numeroTelefoneDevedor = this.getNumeroTelefoneDevedor();
        String other$numeroTelefoneDevedor = other.getNumeroTelefoneDevedor();
        if (this$numeroTelefoneDevedor == null ? other$numeroTelefoneDevedor != null : !this$numeroTelefoneDevedor.equals(other$numeroTelefoneDevedor)) {
            return false;
        }
        String this$codigoSolicitacaoBancoCentralBrasil = this.getCodigoSolicitacaoBancoCentralBrasil();
        String other$codigoSolicitacaoBancoCentralBrasil = other.getCodigoSolicitacaoBancoCentralBrasil();
        if (this$codigoSolicitacaoBancoCentralBrasil == null ? other$codigoSolicitacaoBancoCentralBrasil != null : !this$codigoSolicitacaoBancoCentralBrasil.equals(other$codigoSolicitacaoBancoCentralBrasil)) {
            return false;
        }
        String this$descricaoSolicitacaoPagamento = this.getDescricaoSolicitacaoPagamento();
        String other$descricaoSolicitacaoPagamento = other.getDescricaoSolicitacaoPagamento();
        if (this$descricaoSolicitacaoPagamento == null ? other$descricaoSolicitacaoPagamento != null : !this$descricaoSolicitacaoPagamento.equals(other$descricaoSolicitacaoPagamento)) {
            return false;
        }
        BigDecimal this$valorOriginalSolicitacao = this.getValorOriginalSolicitacao();
        BigDecimal other$valorOriginalSolicitacao = other.getValorOriginalSolicitacao();
        if (this$valorOriginalSolicitacao == null ? other$valorOriginalSolicitacao != null : !((Object)this$valorOriginalSolicitacao).equals(other$valorOriginalSolicitacao)) {
            return false;
        }
        String this$cpfDevedor = this.getCpfDevedor();
        String other$cpfDevedor = other.getCpfDevedor();
        if (this$cpfDevedor == null ? other$cpfDevedor != null : !this$cpfDevedor.equals(other$cpfDevedor)) {
            return false;
        }
        String this$cnpjDevedor = this.getCnpjDevedor();
        String other$cnpjDevedor = other.getCnpjDevedor();
        if (this$cnpjDevedor == null ? other$cnpjDevedor != null : !this$cnpjDevedor.equals(other$cnpjDevedor)) {
            return false;
        }
        String this$nomeDevedor = this.getNomeDevedor();
        String other$nomeDevedor = other.getNomeDevedor();
        if (this$nomeDevedor == null ? other$nomeDevedor != null : !this$nomeDevedor.equals(other$nomeDevedor)) {
            return false;
        }
        Long this$quantidadeSegundoExpiracao = this.getQuantidadeSegundoExpiracao();
        Long other$quantidadeSegundoExpiracao = other.getQuantidadeSegundoExpiracao();
        if (this$quantidadeSegundoExpiracao == null ? other$quantidadeSegundoExpiracao != null : !((Object)this$quantidadeSegundoExpiracao).equals(other$quantidadeSegundoExpiracao)) {
            return false;
        }
        List this$listaInformacaoAdicional = this.getListaInformacaoAdicional();
        List other$listaInformacaoAdicional = other.getListaInformacaoAdicional();
        return !(this$listaInformacaoAdicional == null ? other$listaInformacaoAdicional != null : !((Object)this$listaInformacaoAdicional).equals(other$listaInformacaoAdicional));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GerarQrCodePixBBRequestDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $numeroConvenio = this.getNumeroConvenio();
        result = result * 59 + ($numeroConvenio == null ? 43 : ((Object)$numeroConvenio).hashCode());
        String $indicadorCodigoBarras = this.getIndicadorCodigoBarras();
        result = result * 59 + ($indicadorCodigoBarras == null ? 43 : $indicadorCodigoBarras.hashCode());
        String $codigoGuiaRecebimento = this.getCodigoGuiaRecebimento();
        result = result * 59 + ($codigoGuiaRecebimento == null ? 43 : $codigoGuiaRecebimento.hashCode());
        String $emailDevedor = this.getEmailDevedor();
        result = result * 59 + ($emailDevedor == null ? 43 : $emailDevedor.hashCode());
        Integer $codigoPaisTelefoneDevedor = this.getCodigoPaisTelefoneDevedor();
        result = result * 59 + ($codigoPaisTelefoneDevedor == null ? 43 : ((Object)$codigoPaisTelefoneDevedor).hashCode());
        Integer $dddTelefoneDevedor = this.getDddTelefoneDevedor();
        result = result * 59 + ($dddTelefoneDevedor == null ? 43 : ((Object)$dddTelefoneDevedor).hashCode());
        String $numeroTelefoneDevedor = this.getNumeroTelefoneDevedor();
        result = result * 59 + ($numeroTelefoneDevedor == null ? 43 : $numeroTelefoneDevedor.hashCode());
        String $codigoSolicitacaoBancoCentralBrasil = this.getCodigoSolicitacaoBancoCentralBrasil();
        result = result * 59 + ($codigoSolicitacaoBancoCentralBrasil == null ? 43 : $codigoSolicitacaoBancoCentralBrasil.hashCode());
        String $descricaoSolicitacaoPagamento = this.getDescricaoSolicitacaoPagamento();
        result = result * 59 + ($descricaoSolicitacaoPagamento == null ? 43 : $descricaoSolicitacaoPagamento.hashCode());
        BigDecimal $valorOriginalSolicitacao = this.getValorOriginalSolicitacao();
        result = result * 59 + ($valorOriginalSolicitacao == null ? 43 : ((Object)$valorOriginalSolicitacao).hashCode());
        String $cpfDevedor = this.getCpfDevedor();
        result = result * 59 + ($cpfDevedor == null ? 43 : $cpfDevedor.hashCode());
        String $cnpjDevedor = this.getCnpjDevedor();
        result = result * 59 + ($cnpjDevedor == null ? 43 : $cnpjDevedor.hashCode());
        String $nomeDevedor = this.getNomeDevedor();
        result = result * 59 + ($nomeDevedor == null ? 43 : $nomeDevedor.hashCode());
        Long $quantidadeSegundoExpiracao = this.getQuantidadeSegundoExpiracao();
        result = result * 59 + ($quantidadeSegundoExpiracao == null ? 43 : ((Object)$quantidadeSegundoExpiracao).hashCode());
        List $listaInformacaoAdicional = this.getListaInformacaoAdicional();
        result = result * 59 + ($listaInformacaoAdicional == null ? 43 : ((Object)$listaInformacaoAdicional).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "GerarQrCodePixBBRequestDTO(numeroConvenio=" + this.getNumeroConvenio() + ", indicadorCodigoBarras=" + this.getIndicadorCodigoBarras() + ", codigoGuiaRecebimento=" + this.getCodigoGuiaRecebimento() + ", emailDevedor=" + this.getEmailDevedor() + ", codigoPaisTelefoneDevedor=" + this.getCodigoPaisTelefoneDevedor() + ", dddTelefoneDevedor=" + this.getDddTelefoneDevedor() + ", numeroTelefoneDevedor=" + this.getNumeroTelefoneDevedor() + ", codigoSolicitacaoBancoCentralBrasil=" + this.getCodigoSolicitacaoBancoCentralBrasil() + ", descricaoSolicitacaoPagamento=" + this.getDescricaoSolicitacaoPagamento() + ", valorOriginalSolicitacao=" + this.getValorOriginalSolicitacao() + ", cpfDevedor=" + this.getCpfDevedor() + ", cnpjDevedor=" + this.getCnpjDevedor() + ", nomeDevedor=" + this.getNomeDevedor() + ", quantidadeSegundoExpiracao=" + this.getQuantidadeSegundoExpiracao() + ", listaInformacaoAdicional=" + this.getListaInformacaoAdicional() + ")";
    }
}

