/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.integracaoboleto.bancodobrasil;

import br.com.elotech.core.enumerable.common.SimNao;
import br.com.elotech.tributos.dto.integracaoboleto.ConsultaPixResponseDTO;
import br.com.elotech.tributos.dto.integracaoboleto.bancodobrasil.ConsultaQrCodePagamentoPixResponseBBDTO;
import br.com.elotech.tributos.dto.integracaoboleto.bancodobrasil.QrCodePixBBErroDTO;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

public class ConsultaQrCodePagamentoPixResponseBBDTO {
    private static String SITUACAO_PAGO = "CONCLUIDA";
    private String codigoGuiaRecebimento;
    private String emailDevedor;
    private Long codigoPaisTelefoneDevedor;
    private Long dddTelefoneDevedor;
    private String numeroTelefoneDevedor;
    private String timestampCriacaoSolicitacao;
    private Long quantidadeSegundoExpiracao;
    private String estadoSolicitacao;
    private Long numeroVersaoSolicitacaoPagamento;
    private String linkQrCode;
    private String qrCode;
    private String cpfDevedor;
    private String cnpjDevedor;
    private String nomeDevedor;
    private BigDecimal valorOriginalSolicitacao;
    private String codigoSolicitacaoBancoCentralBrasil;
    private String descricaoSolicitacaoPagamento;
    private List<InformacaoAdicional> listaInformacaoAdicional;
    private String codigoIdentificadorPagamento;
    private BigDecimal valorPagamento;
    private String timestampPagamento;
    private String cpfPagador;
    private String cnpjPagador;
    private String nomeClientePagador;
    private String textoInformativoPagador;
    private String message;
    private List<QrCodePixBBErroDTO> erros;

    public ConsultaPixResponseDTO toConsultaPixE2EResponseDTO() {
        ConsultaPixResponseDTO dto = new ConsultaPixResponseDTO();
        dto.setValorPagamento(this.valorPagamento);
        dto.setChaveRecebedor(this.codigoSolicitacaoBancoCentralBrasil);
        dto.setInfoLivrePagador(this.textoInformativoPagador);
        dto.setCodigoBarrasBoleto(this.codigoGuiaRecebimento);
        dto.setPago(SimNao.fromBoolean((Boolean)SITUACAO_PAGO.equals(this.estadoSolicitacao)));
        dto.setCpfCnpjPagador((String)Optional.ofNullable(this.cpfPagador).filter(cpf -> !cpf.equals("0")).or(() -> Optional.ofNullable(this.cnpjPagador).filter(cnpj -> !cnpj.equals("0"))).orElse(null));
        dto.setDataHoraPagamento((LocalDateTime)Optional.ofNullable(this.timestampPagamento).filter(StringUtils::isNotEmpty).map(data -> LocalDateTime.parse(data, DateTimeFormatter.ISO_DATE_TIME)).orElse(null));
        return dto;
    }

    @JsonIgnore
    public boolean hasErro() {
        return !CollectionUtils.isEmpty((Collection)this.erros) || !StringUtils.isEmpty((CharSequence)this.message);
    }

    @JsonIgnore
    public String getErrosConcatenado() {
        return Optional.ofNullable(this.message).orElseGet(() -> ((List)Optional.ofNullable(this.erros).orElse(new ArrayList())).stream().map(QrCodePixBBErroDTO::getMensagem).collect(Collectors.joining(",")));
    }

    @Generated
    public ConsultaQrCodePagamentoPixResponseBBDTO() {
    }

    @Generated
    public String getCodigoGuiaRecebimento() {
        return this.codigoGuiaRecebimento;
    }

    @Generated
    public String getEmailDevedor() {
        return this.emailDevedor;
    }

    @Generated
    public Long getCodigoPaisTelefoneDevedor() {
        return this.codigoPaisTelefoneDevedor;
    }

    @Generated
    public Long getDddTelefoneDevedor() {
        return this.dddTelefoneDevedor;
    }

    @Generated
    public String getNumeroTelefoneDevedor() {
        return this.numeroTelefoneDevedor;
    }

    @Generated
    public String getTimestampCriacaoSolicitacao() {
        return this.timestampCriacaoSolicitacao;
    }

    @Generated
    public Long getQuantidadeSegundoExpiracao() {
        return this.quantidadeSegundoExpiracao;
    }

    @Generated
    public String getEstadoSolicitacao() {
        return this.estadoSolicitacao;
    }

    @Generated
    public Long getNumeroVersaoSolicitacaoPagamento() {
        return this.numeroVersaoSolicitacaoPagamento;
    }

    @Generated
    public String getLinkQrCode() {
        return this.linkQrCode;
    }

    @Generated
    public String getQrCode() {
        return this.qrCode;
    }

    @Generated
    public String getCpfDevedor() {
        return this.cpfDevedor;
    }

    @Generated
    public String getCnpjDevedor() {
        return this.cnpjDevedor;
    }

    @Generated
    public String getNomeDevedor() {
        return this.nomeDevedor;
    }

    @Generated
    public BigDecimal getValorOriginalSolicitacao() {
        return this.valorOriginalSolicitacao;
    }

    @Generated
    public String getCodigoSolicitacaoBancoCentralBrasil() {
        return this.codigoSolicitacaoBancoCentralBrasil;
    }

    @Generated
    public String getDescricaoSolicitacaoPagamento() {
        return this.descricaoSolicitacaoPagamento;
    }

    @Generated
    public List<InformacaoAdicional> getListaInformacaoAdicional() {
        return this.listaInformacaoAdicional;
    }

    @Generated
    public String getCodigoIdentificadorPagamento() {
        return this.codigoIdentificadorPagamento;
    }

    @Generated
    public BigDecimal getValorPagamento() {
        return this.valorPagamento;
    }

    @Generated
    public String getTimestampPagamento() {
        return this.timestampPagamento;
    }

    @Generated
    public String getCpfPagador() {
        return this.cpfPagador;
    }

    @Generated
    public String getCnpjPagador() {
        return this.cnpjPagador;
    }

    @Generated
    public String getNomeClientePagador() {
        return this.nomeClientePagador;
    }

    @Generated
    public String getTextoInformativoPagador() {
        return this.textoInformativoPagador;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public List<QrCodePixBBErroDTO> getErros() {
        return this.erros;
    }

    @Generated
    public void setCodigoGuiaRecebimento(String codigoGuiaRecebimento) {
        this.codigoGuiaRecebimento = codigoGuiaRecebimento;
    }

    @Generated
    public void setEmailDevedor(String emailDevedor) {
        this.emailDevedor = emailDevedor;
    }

    @Generated
    public void setCodigoPaisTelefoneDevedor(Long codigoPaisTelefoneDevedor) {
        this.codigoPaisTelefoneDevedor = codigoPaisTelefoneDevedor;
    }

    @Generated
    public void setDddTelefoneDevedor(Long dddTelefoneDevedor) {
        this.dddTelefoneDevedor = dddTelefoneDevedor;
    }

    @Generated
    public void setNumeroTelefoneDevedor(String numeroTelefoneDevedor) {
        this.numeroTelefoneDevedor = numeroTelefoneDevedor;
    }

    @Generated
    public void setTimestampCriacaoSolicitacao(String timestampCriacaoSolicitacao) {
        this.timestampCriacaoSolicitacao = timestampCriacaoSolicitacao;
    }

    @Generated
    public void setQuantidadeSegundoExpiracao(Long quantidadeSegundoExpiracao) {
        this.quantidadeSegundoExpiracao = quantidadeSegundoExpiracao;
    }

    @Generated
    public void setEstadoSolicitacao(String estadoSolicitacao) {
        this.estadoSolicitacao = estadoSolicitacao;
    }

    @Generated
    public void setNumeroVersaoSolicitacaoPagamento(Long numeroVersaoSolicitacaoPagamento) {
        this.numeroVersaoSolicitacaoPagamento = numeroVersaoSolicitacaoPagamento;
    }

    @Generated
    public void setLinkQrCode(String linkQrCode) {
        this.linkQrCode = linkQrCode;
    }

    @Generated
    public void setQrCode(String qrCode) {
        this.qrCode = qrCode;
    }

    @Generated
    public void setCpfDevedor(String cpfDevedor) {
        this.cpfDevedor = cpfDevedor;
    }

    @Generated
    public void setCnpjDevedor(String cnpjDevedor) {
        this.cnpjDevedor = cnpjDevedor;
    }

    @Generated
    public void setNomeDevedor(String nomeDevedor) {
        this.nomeDevedor = nomeDevedor;
    }

    @Generated
    public void setValorOriginalSolicitacao(BigDecimal valorOriginalSolicitacao) {
        this.valorOriginalSolicitacao = valorOriginalSolicitacao;
    }

    @Generated
    public void setCodigoSolicitacaoBancoCentralBrasil(String codigoSolicitacaoBancoCentralBrasil) {
        this.codigoSolicitacaoBancoCentralBrasil = codigoSolicitacaoBancoCentralBrasil;
    }

    @Generated
    public void setDescricaoSolicitacaoPagamento(String descricaoSolicitacaoPagamento) {
        this.descricaoSolicitacaoPagamento = descricaoSolicitacaoPagamento;
    }

    @Generated
    public void setListaInformacaoAdicional(List<InformacaoAdicional> listaInformacaoAdicional) {
        this.listaInformacaoAdicional = listaInformacaoAdicional;
    }

    @Generated
    public void setCodigoIdentificadorPagamento(String codigoIdentificadorPagamento) {
        this.codigoIdentificadorPagamento = codigoIdentificadorPagamento;
    }

    @Generated
    public void setValorPagamento(BigDecimal valorPagamento) {
        this.valorPagamento = valorPagamento;
    }

    @Generated
    public void setTimestampPagamento(String timestampPagamento) {
        this.timestampPagamento = timestampPagamento;
    }

    @Generated
    public void setCpfPagador(String cpfPagador) {
        this.cpfPagador = cpfPagador;
    }

    @Generated
    public void setCnpjPagador(String cnpjPagador) {
        this.cnpjPagador = cnpjPagador;
    }

    @Generated
    public void setNomeClientePagador(String nomeClientePagador) {
        this.nomeClientePagador = nomeClientePagador;
    }

    @Generated
    public void setTextoInformativoPagador(String textoInformativoPagador) {
        this.textoInformativoPagador = textoInformativoPagador;
    }

    @Generated
    public void setMessage(String message) {
        this.message = message;
    }

    @Generated
    public void setErros(List<QrCodePixBBErroDTO> erros) {
        this.erros = erros;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConsultaQrCodePagamentoPixResponseBBDTO)) {
            return false;
        }
        ConsultaQrCodePagamentoPixResponseBBDTO other = (ConsultaQrCodePagamentoPixResponseBBDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$codigoGuiaRecebimento = this.getCodigoGuiaRecebimento();
        String other$codigoGuiaRecebimento = other.getCodigoGuiaRecebimento();
        if (this$codigoGuiaRecebimento == null ? other$codigoGuiaRecebimento != null : !this$codigoGuiaRecebimento.equals(other$codigoGuiaRecebimento)) {
            return false;
        }
        String this$emailDevedor = this.getEmailDevedor();
        String other$emailDevedor = other.getEmailDevedor();
        if (this$emailDevedor == null ? other$emailDevedor != null : !this$emailDevedor.equals(other$emailDevedor)) {
            return false;
        }
        Long this$codigoPaisTelefoneDevedor = this.getCodigoPaisTelefoneDevedor();
        Long other$codigoPaisTelefoneDevedor = other.getCodigoPaisTelefoneDevedor();
        if (this$codigoPaisTelefoneDevedor == null ? other$codigoPaisTelefoneDevedor != null : !((Object)this$codigoPaisTelefoneDevedor).equals(other$codigoPaisTelefoneDevedor)) {
            return false;
        }
        Long this$dddTelefoneDevedor = this.getDddTelefoneDevedor();
        Long other$dddTelefoneDevedor = other.getDddTelefoneDevedor();
        if (this$dddTelefoneDevedor == null ? other$dddTelefoneDevedor != null : !((Object)this$dddTelefoneDevedor).equals(other$dddTelefoneDevedor)) {
            return false;
        }
        String this$numeroTelefoneDevedor = this.getNumeroTelefoneDevedor();
        String other$numeroTelefoneDevedor = other.getNumeroTelefoneDevedor();
        if (this$numeroTelefoneDevedor == null ? other$numeroTelefoneDevedor != null : !this$numeroTelefoneDevedor.equals(other$numeroTelefoneDevedor)) {
            return false;
        }
        String this$timestampCriacaoSolicitacao = this.getTimestampCriacaoSolicitacao();
        String other$timestampCriacaoSolicitacao = other.getTimestampCriacaoSolicitacao();
        if (this$timestampCriacaoSolicitacao == null ? other$timestampCriacaoSolicitacao != null : !this$timestampCriacaoSolicitacao.equals(other$timestampCriacaoSolicitacao)) {
            return false;
        }
        Long this$quantidadeSegundoExpiracao = this.getQuantidadeSegundoExpiracao();
        Long other$quantidadeSegundoExpiracao = other.getQuantidadeSegundoExpiracao();
        if (this$quantidadeSegundoExpiracao == null ? other$quantidadeSegundoExpiracao != null : !((Object)this$quantidadeSegundoExpiracao).equals(other$quantidadeSegundoExpiracao)) {
            return false;
        }
        String this$estadoSolicitacao = this.getEstadoSolicitacao();
        String other$estadoSolicitacao = other.getEstadoSolicitacao();
        if (this$estadoSolicitacao == null ? other$estadoSolicitacao != null : !this$estadoSolicitacao.equals(other$estadoSolicitacao)) {
            return false;
        }
        Long this$numeroVersaoSolicitacaoPagamento = this.getNumeroVersaoSolicitacaoPagamento();
        Long other$numeroVersaoSolicitacaoPagamento = other.getNumeroVersaoSolicitacaoPagamento();
        if (this$numeroVersaoSolicitacaoPagamento == null ? other$numeroVersaoSolicitacaoPagamento != null : !((Object)this$numeroVersaoSolicitacaoPagamento).equals(other$numeroVersaoSolicitacaoPagamento)) {
            return false;
        }
        String this$linkQrCode = this.getLinkQrCode();
        String other$linkQrCode = other.getLinkQrCode();
        if (this$linkQrCode == null ? other$linkQrCode != null : !this$linkQrCode.equals(other$linkQrCode)) {
            return false;
        }
        String this$qrCode = this.getQrCode();
        String other$qrCode = other.getQrCode();
        if (this$qrCode == null ? other$qrCode != null : !this$qrCode.equals(other$qrCode)) {
            return false;
        }
        String this$cpfDevedor = this.getCpfDevedor();
        String other$cpfDevedor = other.getCpfDevedor();
        if (this$cpfDevedor == null ? other$cpfDevedor != null : !this$cpfDevedor.equals(other$cpfDevedor)) {
            return false;
        }
        String this$cnpjDevedor = this.getCnpjDevedor();
        String other$cnpjDevedor = other.getCnpjDevedor();
        if (this$cnpjDevedor == null ? other$cnpjDevedor != null : !this$cnpjDevedor.equals(other$cnpjDevedor)) {
            return false;
        }
        String this$nomeDevedor = this.getNomeDevedor();
        String other$nomeDevedor = other.getNomeDevedor();
        if (this$nomeDevedor == null ? other$nomeDevedor != null : !this$nomeDevedor.equals(other$nomeDevedor)) {
            return false;
        }
        BigDecimal this$valorOriginalSolicitacao = this.getValorOriginalSolicitacao();
        BigDecimal other$valorOriginalSolicitacao = other.getValorOriginalSolicitacao();
        if (this$valorOriginalSolicitacao == null ? other$valorOriginalSolicitacao != null : !((Object)this$valorOriginalSolicitacao).equals(other$valorOriginalSolicitacao)) {
            return false;
        }
        String this$codigoSolicitacaoBancoCentralBrasil = this.getCodigoSolicitacaoBancoCentralBrasil();
        String other$codigoSolicitacaoBancoCentralBrasil = other.getCodigoSolicitacaoBancoCentralBrasil();
        if (this$codigoSolicitacaoBancoCentralBrasil == null ? other$codigoSolicitacaoBancoCentralBrasil != null : !this$codigoSolicitacaoBancoCentralBrasil.equals(other$codigoSolicitacaoBancoCentralBrasil)) {
            return false;
        }
        String this$descricaoSolicitacaoPagamento = this.getDescricaoSolicitacaoPagamento();
        String other$descricaoSolicitacaoPagamento = other.getDescricaoSolicitacaoPagamento();
        if (this$descricaoSolicitacaoPagamento == null ? other$descricaoSolicitacaoPagamento != null : !this$descricaoSolicitacaoPagamento.equals(other$descricaoSolicitacaoPagamento)) {
            return false;
        }
        List this$listaInformacaoAdicional = this.getListaInformacaoAdicional();
        List other$listaInformacaoAdicional = other.getListaInformacaoAdicional();
        if (this$listaInformacaoAdicional == null ? other$listaInformacaoAdicional != null : !((Object)this$listaInformacaoAdicional).equals(other$listaInformacaoAdicional)) {
            return false;
        }
        String this$codigoIdentificadorPagamento = this.getCodigoIdentificadorPagamento();
        String other$codigoIdentificadorPagamento = other.getCodigoIdentificadorPagamento();
        if (this$codigoIdentificadorPagamento == null ? other$codigoIdentificadorPagamento != null : !this$codigoIdentificadorPagamento.equals(other$codigoIdentificadorPagamento)) {
            return false;
        }
        BigDecimal this$valorPagamento = this.getValorPagamento();
        BigDecimal other$valorPagamento = other.getValorPagamento();
        if (this$valorPagamento == null ? other$valorPagamento != null : !((Object)this$valorPagamento).equals(other$valorPagamento)) {
            return false;
        }
        String this$timestampPagamento = this.getTimestampPagamento();
        String other$timestampPagamento = other.getTimestampPagamento();
        if (this$timestampPagamento == null ? other$timestampPagamento != null : !this$timestampPagamento.equals(other$timestampPagamento)) {
            return false;
        }
        String this$cpfPagador = this.getCpfPagador();
        String other$cpfPagador = other.getCpfPagador();
        if (this$cpfPagador == null ? other$cpfPagador != null : !this$cpfPagador.equals(other$cpfPagador)) {
            return false;
        }
        String this$cnpjPagador = this.getCnpjPagador();
        String other$cnpjPagador = other.getCnpjPagador();
        if (this$cnpjPagador == null ? other$cnpjPagador != null : !this$cnpjPagador.equals(other$cnpjPagador)) {
            return false;
        }
        String this$nomeClientePagador = this.getNomeClientePagador();
        String other$nomeClientePagador = other.getNomeClientePagador();
        if (this$nomeClientePagador == null ? other$nomeClientePagador != null : !this$nomeClientePagador.equals(other$nomeClientePagador)) {
            return false;
        }
        String this$textoInformativoPagador = this.getTextoInformativoPagador();
        String other$textoInformativoPagador = other.getTextoInformativoPagador();
        if (this$textoInformativoPagador == null ? other$textoInformativoPagador != null : !this$textoInformativoPagador.equals(other$textoInformativoPagador)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        List this$erros = this.getErros();
        List other$erros = other.getErros();
        return !(this$erros == null ? other$erros != null : !((Object)this$erros).equals(other$erros));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ConsultaQrCodePagamentoPixResponseBBDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $codigoGuiaRecebimento = this.getCodigoGuiaRecebimento();
        result = result * 59 + ($codigoGuiaRecebimento == null ? 43 : $codigoGuiaRecebimento.hashCode());
        String $emailDevedor = this.getEmailDevedor();
        result = result * 59 + ($emailDevedor == null ? 43 : $emailDevedor.hashCode());
        Long $codigoPaisTelefoneDevedor = this.getCodigoPaisTelefoneDevedor();
        result = result * 59 + ($codigoPaisTelefoneDevedor == null ? 43 : ((Object)$codigoPaisTelefoneDevedor).hashCode());
        Long $dddTelefoneDevedor = this.getDddTelefoneDevedor();
        result = result * 59 + ($dddTelefoneDevedor == null ? 43 : ((Object)$dddTelefoneDevedor).hashCode());
        String $numeroTelefoneDevedor = this.getNumeroTelefoneDevedor();
        result = result * 59 + ($numeroTelefoneDevedor == null ? 43 : $numeroTelefoneDevedor.hashCode());
        String $timestampCriacaoSolicitacao = this.getTimestampCriacaoSolicitacao();
        result = result * 59 + ($timestampCriacaoSolicitacao == null ? 43 : $timestampCriacaoSolicitacao.hashCode());
        Long $quantidadeSegundoExpiracao = this.getQuantidadeSegundoExpiracao();
        result = result * 59 + ($quantidadeSegundoExpiracao == null ? 43 : ((Object)$quantidadeSegundoExpiracao).hashCode());
        String $estadoSolicitacao = this.getEstadoSolicitacao();
        result = result * 59 + ($estadoSolicitacao == null ? 43 : $estadoSolicitacao.hashCode());
        Long $numeroVersaoSolicitacaoPagamento = this.getNumeroVersaoSolicitacaoPagamento();
        result = result * 59 + ($numeroVersaoSolicitacaoPagamento == null ? 43 : ((Object)$numeroVersaoSolicitacaoPagamento).hashCode());
        String $linkQrCode = this.getLinkQrCode();
        result = result * 59 + ($linkQrCode == null ? 43 : $linkQrCode.hashCode());
        String $qrCode = this.getQrCode();
        result = result * 59 + ($qrCode == null ? 43 : $qrCode.hashCode());
        String $cpfDevedor = this.getCpfDevedor();
        result = result * 59 + ($cpfDevedor == null ? 43 : $cpfDevedor.hashCode());
        String $cnpjDevedor = this.getCnpjDevedor();
        result = result * 59 + ($cnpjDevedor == null ? 43 : $cnpjDevedor.hashCode());
        String $nomeDevedor = this.getNomeDevedor();
        result = result * 59 + ($nomeDevedor == null ? 43 : $nomeDevedor.hashCode());
        BigDecimal $valorOriginalSolicitacao = this.getValorOriginalSolicitacao();
        result = result * 59 + ($valorOriginalSolicitacao == null ? 43 : ((Object)$valorOriginalSolicitacao).hashCode());
        String $codigoSolicitacaoBancoCentralBrasil = this.getCodigoSolicitacaoBancoCentralBrasil();
        result = result * 59 + ($codigoSolicitacaoBancoCentralBrasil == null ? 43 : $codigoSolicitacaoBancoCentralBrasil.hashCode());
        String $descricaoSolicitacaoPagamento = this.getDescricaoSolicitacaoPagamento();
        result = result * 59 + ($descricaoSolicitacaoPagamento == null ? 43 : $descricaoSolicitacaoPagamento.hashCode());
        List $listaInformacaoAdicional = this.getListaInformacaoAdicional();
        result = result * 59 + ($listaInformacaoAdicional == null ? 43 : ((Object)$listaInformacaoAdicional).hashCode());
        String $codigoIdentificadorPagamento = this.getCodigoIdentificadorPagamento();
        result = result * 59 + ($codigoIdentificadorPagamento == null ? 43 : $codigoIdentificadorPagamento.hashCode());
        BigDecimal $valorPagamento = this.getValorPagamento();
        result = result * 59 + ($valorPagamento == null ? 43 : ((Object)$valorPagamento).hashCode());
        String $timestampPagamento = this.getTimestampPagamento();
        result = result * 59 + ($timestampPagamento == null ? 43 : $timestampPagamento.hashCode());
        String $cpfPagador = this.getCpfPagador();
        result = result * 59 + ($cpfPagador == null ? 43 : $cpfPagador.hashCode());
        String $cnpjPagador = this.getCnpjPagador();
        result = result * 59 + ($cnpjPagador == null ? 43 : $cnpjPagador.hashCode());
        String $nomeClientePagador = this.getNomeClientePagador();
        result = result * 59 + ($nomeClientePagador == null ? 43 : $nomeClientePagador.hashCode());
        String $textoInformativoPagador = this.getTextoInformativoPagador();
        result = result * 59 + ($textoInformativoPagador == null ? 43 : $textoInformativoPagador.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        List $erros = this.getErros();
        result = result * 59 + ($erros == null ? 43 : ((Object)$erros).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ConsultaQrCodePagamentoPixResponseBBDTO(codigoGuiaRecebimento=" + this.getCodigoGuiaRecebimento() + ", emailDevedor=" + this.getEmailDevedor() + ", codigoPaisTelefoneDevedor=" + this.getCodigoPaisTelefoneDevedor() + ", dddTelefoneDevedor=" + this.getDddTelefoneDevedor() + ", numeroTelefoneDevedor=" + this.getNumeroTelefoneDevedor() + ", timestampCriacaoSolicitacao=" + this.getTimestampCriacaoSolicitacao() + ", quantidadeSegundoExpiracao=" + this.getQuantidadeSegundoExpiracao() + ", estadoSolicitacao=" + this.getEstadoSolicitacao() + ", numeroVersaoSolicitacaoPagamento=" + this.getNumeroVersaoSolicitacaoPagamento() + ", linkQrCode=" + this.getLinkQrCode() + ", qrCode=" + this.getQrCode() + ", cpfDevedor=" + this.getCpfDevedor() + ", cnpjDevedor=" + this.getCnpjDevedor() + ", nomeDevedor=" + this.getNomeDevedor() + ", valorOriginalSolicitacao=" + this.getValorOriginalSolicitacao() + ", codigoSolicitacaoBancoCentralBrasil=" + this.getCodigoSolicitacaoBancoCentralBrasil() + ", descricaoSolicitacaoPagamento=" + this.getDescricaoSolicitacaoPagamento() + ", listaInformacaoAdicional=" + this.getListaInformacaoAdicional() + ", codigoIdentificadorPagamento=" + this.getCodigoIdentificadorPagamento() + ", valorPagamento=" + this.getValorPagamento() + ", timestampPagamento=" + this.getTimestampPagamento() + ", cpfPagador=" + this.getCpfPagador() + ", cnpjPagador=" + this.getCnpjPagador() + ", nomeClientePagador=" + this.getNomeClientePagador() + ", textoInformativoPagador=" + this.getTextoInformativoPagador() + ", message=" + this.getMessage() + ", erros=" + this.getErros() + ")";
    }
}

