/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.integracaoboleto.bancodobrasil;

import br.com.elotech.tributos.dto.integracaoboleto.ConsultaPixResponseDTO;
import br.com.elotech.tributos.dto.integracaoboleto.bancodobrasil.QrCodePixBBErroDTO;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

public class ConsultaPagamentoPixResponseBBDTO {
    private Long codigoEstado;
    private String timestamp;
    private BigDecimal valor;
    private Long codigoTipoPessoaRecebedor;
    private String cpfCnpjRecebedor;
    private String codigoSolicitacaoBancoCentralBrasil;
    private Long codigoBancoRecebedor;
    private String nomeBancoRecebedor;
    private Long codigoTipoPessoaPagador;
    private String cpfCnpjPagador;
    private Long codigoBancoPagador;
    private String nomeBancoPagador;
    private String codigoIdentificadorSolicitacaoPagamentoInstantaneo;
    private String codigoConciliacaoRecebedor;
    private String descricaoPagamentoPagador;
    private String descricaoComplementarPagador;
    private String codigoErroPagamento;
    private String textoErro;
    private String message;
    private List<QrCodePixBBErroDTO> erros;

    public ConsultaPixResponseDTO toConsultaPixE2EResponseDTO() {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'-'HH.mm.ss.SSSSSS");
        ConsultaPixResponseDTO dto = new ConsultaPixResponseDTO();
        dto.setTxid(this.codigoConciliacaoRecebedor);
        dto.setValorPagamento(this.valor);
        dto.setDataHoraPagamento((LocalDateTime)Optional.ofNullable(this.timestamp).filter(StringUtils::isNotEmpty).map(data -> LocalDateTime.parse(data, formatter)).orElse(null));
        dto.setChaveRecebedor(this.codigoSolicitacaoBancoCentralBrasil);
        dto.setInfoLivrePagador(this.descricaoPagamentoPagador);
        dto.setCpfCnpjPagador((String)Optional.ofNullable(this.cpfCnpjPagador).filter(cpfCnpj -> !cpfCnpj.equals("0")).orElse(null));
        return dto;
    }

    @JsonIgnore
    public boolean hasErro() {
        return !CollectionUtils.isEmpty((Collection)this.erros) || !StringUtils.isEmpty((CharSequence)this.message);
    }

    @JsonIgnore
    public String getErrosConcatenado() {
        return Optional.ofNullable(this.message).orElseGet(() -> ((List)Optional.ofNullable(this.erros).orElse(new ArrayList())).stream().map(QrCodePixBBErroDTO::getMensagem).collect(Collectors.joining(",")));
    }

    @Generated
    public ConsultaPagamentoPixResponseBBDTO() {
    }

    @Generated
    public Long getCodigoEstado() {
        return this.codigoEstado;
    }

    @Generated
    public String getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public BigDecimal getValor() {
        return this.valor;
    }

    @Generated
    public Long getCodigoTipoPessoaRecebedor() {
        return this.codigoTipoPessoaRecebedor;
    }

    @Generated
    public String getCpfCnpjRecebedor() {
        return this.cpfCnpjRecebedor;
    }

    @Generated
    public String getCodigoSolicitacaoBancoCentralBrasil() {
        return this.codigoSolicitacaoBancoCentralBrasil;
    }

    @Generated
    public Long getCodigoBancoRecebedor() {
        return this.codigoBancoRecebedor;
    }

    @Generated
    public String getNomeBancoRecebedor() {
        return this.nomeBancoRecebedor;
    }

    @Generated
    public Long getCodigoTipoPessoaPagador() {
        return this.codigoTipoPessoaPagador;
    }

    @Generated
    public String getCpfCnpjPagador() {
        return this.cpfCnpjPagador;
    }

    @Generated
    public Long getCodigoBancoPagador() {
        return this.codigoBancoPagador;
    }

    @Generated
    public String getNomeBancoPagador() {
        return this.nomeBancoPagador;
    }

    @Generated
    public String getCodigoIdentificadorSolicitacaoPagamentoInstantaneo() {
        return this.codigoIdentificadorSolicitacaoPagamentoInstantaneo;
    }

    @Generated
    public String getCodigoConciliacaoRecebedor() {
        return this.codigoConciliacaoRecebedor;
    }

    @Generated
    public String getDescricaoPagamentoPagador() {
        return this.descricaoPagamentoPagador;
    }

    @Generated
    public String getDescricaoComplementarPagador() {
        return this.descricaoComplementarPagador;
    }

    @Generated
    public String getCodigoErroPagamento() {
        return this.codigoErroPagamento;
    }

    @Generated
    public String getTextoErro() {
        return this.textoErro;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public List<QrCodePixBBErroDTO> getErros() {
        return this.erros;
    }

    @Generated
    public void setCodigoEstado(Long codigoEstado) {
        this.codigoEstado = codigoEstado;
    }

    @Generated
    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    @Generated
    public void setValor(BigDecimal valor) {
        this.valor = valor;
    }

    @Generated
    public void setCodigoTipoPessoaRecebedor(Long codigoTipoPessoaRecebedor) {
        this.codigoTipoPessoaRecebedor = codigoTipoPessoaRecebedor;
    }

    @Generated
    public void setCpfCnpjRecebedor(String cpfCnpjRecebedor) {
        this.cpfCnpjRecebedor = cpfCnpjRecebedor;
    }

    @Generated
    public void setCodigoSolicitacaoBancoCentralBrasil(String codigoSolicitacaoBancoCentralBrasil) {
        this.codigoSolicitacaoBancoCentralBrasil = codigoSolicitacaoBancoCentralBrasil;
    }

    @Generated
    public void setCodigoBancoRecebedor(Long codigoBancoRecebedor) {
        this.codigoBancoRecebedor = codigoBancoRecebedor;
    }

    @Generated
    public void setNomeBancoRecebedor(String nomeBancoRecebedor) {
        this.nomeBancoRecebedor = nomeBancoRecebedor;
    }

    @Generated
    public void setCodigoTipoPessoaPagador(Long codigoTipoPessoaPagador) {
        this.codigoTipoPessoaPagador = codigoTipoPessoaPagador;
    }

    @Generated
    public void setCpfCnpjPagador(String cpfCnpjPagador) {
        this.cpfCnpjPagador = cpfCnpjPagador;
    }

    @Generated
    public void setCodigoBancoPagador(Long codigoBancoPagador) {
        this.codigoBancoPagador = codigoBancoPagador;
    }

    @Generated
    public void setNomeBancoPagador(String nomeBancoPagador) {
        this.nomeBancoPagador = nomeBancoPagador;
    }

    @Generated
    public void setCodigoIdentificadorSolicitacaoPagamentoInstantaneo(String codigoIdentificadorSolicitacaoPagamentoInstantaneo) {
        this.codigoIdentificadorSolicitacaoPagamentoInstantaneo = codigoIdentificadorSolicitacaoPagamentoInstantaneo;
    }

    @Generated
    public void setCodigoConciliacaoRecebedor(String codigoConciliacaoRecebedor) {
        this.codigoConciliacaoRecebedor = codigoConciliacaoRecebedor;
    }

    @Generated
    public void setDescricaoPagamentoPagador(String descricaoPagamentoPagador) {
        this.descricaoPagamentoPagador = descricaoPagamentoPagador;
    }

    @Generated
    public void setDescricaoComplementarPagador(String descricaoComplementarPagador) {
        this.descricaoComplementarPagador = descricaoComplementarPagador;
    }

    @Generated
    public void setCodigoErroPagamento(String codigoErroPagamento) {
        this.codigoErroPagamento = codigoErroPagamento;
    }

    @Generated
    public void setTextoErro(String textoErro) {
        this.textoErro = textoErro;
    }

    @Generated
    public void setMessage(String message) {
        this.message = message;
    }

    @Generated
    public void setErros(List<QrCodePixBBErroDTO> erros) {
        this.erros = erros;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConsultaPagamentoPixResponseBBDTO)) {
            return false;
        }
        ConsultaPagamentoPixResponseBBDTO other = (ConsultaPagamentoPixResponseBBDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$codigoEstado = this.getCodigoEstado();
        Long other$codigoEstado = other.getCodigoEstado();
        if (this$codigoEstado == null ? other$codigoEstado != null : !((Object)this$codigoEstado).equals(other$codigoEstado)) {
            return false;
        }
        String this$timestamp = this.getTimestamp();
        String other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !this$timestamp.equals(other$timestamp)) {
            return false;
        }
        BigDecimal this$valor = this.getValor();
        BigDecimal other$valor = other.getValor();
        if (this$valor == null ? other$valor != null : !((Object)this$valor).equals(other$valor)) {
            return false;
        }
        Long this$codigoTipoPessoaRecebedor = this.getCodigoTipoPessoaRecebedor();
        Long other$codigoTipoPessoaRecebedor = other.getCodigoTipoPessoaRecebedor();
        if (this$codigoTipoPessoaRecebedor == null ? other$codigoTipoPessoaRecebedor != null : !((Object)this$codigoTipoPessoaRecebedor).equals(other$codigoTipoPessoaRecebedor)) {
            return false;
        }
        String this$cpfCnpjRecebedor = this.getCpfCnpjRecebedor();
        String other$cpfCnpjRecebedor = other.getCpfCnpjRecebedor();
        if (this$cpfCnpjRecebedor == null ? other$cpfCnpjRecebedor != null : !this$cpfCnpjRecebedor.equals(other$cpfCnpjRecebedor)) {
            return false;
        }
        String this$codigoSolicitacaoBancoCentralBrasil = this.getCodigoSolicitacaoBancoCentralBrasil();
        String other$codigoSolicitacaoBancoCentralBrasil = other.getCodigoSolicitacaoBancoCentralBrasil();
        if (this$codigoSolicitacaoBancoCentralBrasil == null ? other$codigoSolicitacaoBancoCentralBrasil != null : !this$codigoSolicitacaoBancoCentralBrasil.equals(other$codigoSolicitacaoBancoCentralBrasil)) {
            return false;
        }
        Long this$codigoBancoRecebedor = this.getCodigoBancoRecebedor();
        Long other$codigoBancoRecebedor = other.getCodigoBancoRecebedor();
        if (this$codigoBancoRecebedor == null ? other$codigoBancoRecebedor != null : !((Object)this$codigoBancoRecebedor).equals(other$codigoBancoRecebedor)) {
            return false;
        }
        String this$nomeBancoRecebedor = this.getNomeBancoRecebedor();
        String other$nomeBancoRecebedor = other.getNomeBancoRecebedor();
        if (this$nomeBancoRecebedor == null ? other$nomeBancoRecebedor != null : !this$nomeBancoRecebedor.equals(other$nomeBancoRecebedor)) {
            return false;
        }
        Long this$codigoTipoPessoaPagador = this.getCodigoTipoPessoaPagador();
        Long other$codigoTipoPessoaPagador = other.getCodigoTipoPessoaPagador();
        if (this$codigoTipoPessoaPagador == null ? other$codigoTipoPessoaPagador != null : !((Object)this$codigoTipoPessoaPagador).equals(other$codigoTipoPessoaPagador)) {
            return false;
        }
        String this$cpfCnpjPagador = this.getCpfCnpjPagador();
        String other$cpfCnpjPagador = other.getCpfCnpjPagador();
        if (this$cpfCnpjPagador == null ? other$cpfCnpjPagador != null : !this$cpfCnpjPagador.equals(other$cpfCnpjPagador)) {
            return false;
        }
        Long this$codigoBancoPagador = this.getCodigoBancoPagador();
        Long other$codigoBancoPagador = other.getCodigoBancoPagador();
        if (this$codigoBancoPagador == null ? other$codigoBancoPagador != null : !((Object)this$codigoBancoPagador).equals(other$codigoBancoPagador)) {
            return false;
        }
        String this$nomeBancoPagador = this.getNomeBancoPagador();
        String other$nomeBancoPagador = other.getNomeBancoPagador();
        if (this$nomeBancoPagador == null ? other$nomeBancoPagador != null : !this$nomeBancoPagador.equals(other$nomeBancoPagador)) {
            return false;
        }
        String this$codigoIdentificadorSolicitacaoPagamentoInstantaneo = this.getCodigoIdentificadorSolicitacaoPagamentoInstantaneo();
        String other$codigoIdentificadorSolicitacaoPagamentoInstantaneo = other.getCodigoIdentificadorSolicitacaoPagamentoInstantaneo();
        if (this$codigoIdentificadorSolicitacaoPagamentoInstantaneo == null ? other$codigoIdentificadorSolicitacaoPagamentoInstantaneo != null : !this$codigoIdentificadorSolicitacaoPagamentoInstantaneo.equals(other$codigoIdentificadorSolicitacaoPagamentoInstantaneo)) {
            return false;
        }
        String this$codigoConciliacaoRecebedor = this.getCodigoConciliacaoRecebedor();
        String other$codigoConciliacaoRecebedor = other.getCodigoConciliacaoRecebedor();
        if (this$codigoConciliacaoRecebedor == null ? other$codigoConciliacaoRecebedor != null : !this$codigoConciliacaoRecebedor.equals(other$codigoConciliacaoRecebedor)) {
            return false;
        }
        String this$descricaoPagamentoPagador = this.getDescricaoPagamentoPagador();
        String other$descricaoPagamentoPagador = other.getDescricaoPagamentoPagador();
        if (this$descricaoPagamentoPagador == null ? other$descricaoPagamentoPagador != null : !this$descricaoPagamentoPagador.equals(other$descricaoPagamentoPagador)) {
            return false;
        }
        String this$descricaoComplementarPagador = this.getDescricaoComplementarPagador();
        String other$descricaoComplementarPagador = other.getDescricaoComplementarPagador();
        if (this$descricaoComplementarPagador == null ? other$descricaoComplementarPagador != null : !this$descricaoComplementarPagador.equals(other$descricaoComplementarPagador)) {
            return false;
        }
        String this$codigoErroPagamento = this.getCodigoErroPagamento();
        String other$codigoErroPagamento = other.getCodigoErroPagamento();
        if (this$codigoErroPagamento == null ? other$codigoErroPagamento != null : !this$codigoErroPagamento.equals(other$codigoErroPagamento)) {
            return false;
        }
        String this$textoErro = this.getTextoErro();
        String other$textoErro = other.getTextoErro();
        if (this$textoErro == null ? other$textoErro != null : !this$textoErro.equals(other$textoErro)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        List this$erros = this.getErros();
        List other$erros = other.getErros();
        return !(this$erros == null ? other$erros != null : !((Object)this$erros).equals(other$erros));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ConsultaPagamentoPixResponseBBDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $codigoEstado = this.getCodigoEstado();
        result = result * 59 + ($codigoEstado == null ? 43 : ((Object)$codigoEstado).hashCode());
        String $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : $timestamp.hashCode());
        BigDecimal $valor = this.getValor();
        result = result * 59 + ($valor == null ? 43 : ((Object)$valor).hashCode());
        Long $codigoTipoPessoaRecebedor = this.getCodigoTipoPessoaRecebedor();
        result = result * 59 + ($codigoTipoPessoaRecebedor == null ? 43 : ((Object)$codigoTipoPessoaRecebedor).hashCode());
        String $cpfCnpjRecebedor = this.getCpfCnpjRecebedor();
        result = result * 59 + ($cpfCnpjRecebedor == null ? 43 : $cpfCnpjRecebedor.hashCode());
        String $codigoSolicitacaoBancoCentralBrasil = this.getCodigoSolicitacaoBancoCentralBrasil();
        result = result * 59 + ($codigoSolicitacaoBancoCentralBrasil == null ? 43 : $codigoSolicitacaoBancoCentralBrasil.hashCode());
        Long $codigoBancoRecebedor = this.getCodigoBancoRecebedor();
        result = result * 59 + ($codigoBancoRecebedor == null ? 43 : ((Object)$codigoBancoRecebedor).hashCode());
        String $nomeBancoRecebedor = this.getNomeBancoRecebedor();
        result = result * 59 + ($nomeBancoRecebedor == null ? 43 : $nomeBancoRecebedor.hashCode());
        Long $codigoTipoPessoaPagador = this.getCodigoTipoPessoaPagador();
        result = result * 59 + ($codigoTipoPessoaPagador == null ? 43 : ((Object)$codigoTipoPessoaPagador).hashCode());
        String $cpfCnpjPagador = this.getCpfCnpjPagador();
        result = result * 59 + ($cpfCnpjPagador == null ? 43 : $cpfCnpjPagador.hashCode());
        Long $codigoBancoPagador = this.getCodigoBancoPagador();
        result = result * 59 + ($codigoBancoPagador == null ? 43 : ((Object)$codigoBancoPagador).hashCode());
        String $nomeBancoPagador = this.getNomeBancoPagador();
        result = result * 59 + ($nomeBancoPagador == null ? 43 : $nomeBancoPagador.hashCode());
        String $codigoIdentificadorSolicitacaoPagamentoInstantaneo = this.getCodigoIdentificadorSolicitacaoPagamentoInstantaneo();
        result = result * 59 + ($codigoIdentificadorSolicitacaoPagamentoInstantaneo == null ? 43 : $codigoIdentificadorSolicitacaoPagamentoInstantaneo.hashCode());
        String $codigoConciliacaoRecebedor = this.getCodigoConciliacaoRecebedor();
        result = result * 59 + ($codigoConciliacaoRecebedor == null ? 43 : $codigoConciliacaoRecebedor.hashCode());
        String $descricaoPagamentoPagador = this.getDescricaoPagamentoPagador();
        result = result * 59 + ($descricaoPagamentoPagador == null ? 43 : $descricaoPagamentoPagador.hashCode());
        String $descricaoComplementarPagador = this.getDescricaoComplementarPagador();
        result = result * 59 + ($descricaoComplementarPagador == null ? 43 : $descricaoComplementarPagador.hashCode());
        String $codigoErroPagamento = this.getCodigoErroPagamento();
        result = result * 59 + ($codigoErroPagamento == null ? 43 : $codigoErroPagamento.hashCode());
        String $textoErro = this.getTextoErro();
        result = result * 59 + ($textoErro == null ? 43 : $textoErro.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        List $erros = this.getErros();
        result = result * 59 + ($erros == null ? 43 : ((Object)$erros).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ConsultaPagamentoPixResponseBBDTO(codigoEstado=" + this.getCodigoEstado() + ", timestamp=" + this.getTimestamp() + ", valor=" + this.getValor() + ", codigoTipoPessoaRecebedor=" + this.getCodigoTipoPessoaRecebedor() + ", cpfCnpjRecebedor=" + this.getCpfCnpjRecebedor() + ", codigoSolicitacaoBancoCentralBrasil=" + this.getCodigoSolicitacaoBancoCentralBrasil() + ", codigoBancoRecebedor=" + this.getCodigoBancoRecebedor() + ", nomeBancoRecebedor=" + this.getNomeBancoRecebedor() + ", codigoTipoPessoaPagador=" + this.getCodigoTipoPessoaPagador() + ", cpfCnpjPagador=" + this.getCpfCnpjPagador() + ", codigoBancoPagador=" + this.getCodigoBancoPagador() + ", nomeBancoPagador=" + this.getNomeBancoPagador() + ", codigoIdentificadorSolicitacaoPagamentoInstantaneo=" + this.getCodigoIdentificadorSolicitacaoPagamentoInstantaneo() + ", codigoConciliacaoRecebedor=" + this.getCodigoConciliacaoRecebedor() + ", descricaoPagamentoPagador=" + this.getDescricaoPagamentoPagador() + ", descricaoComplementarPagador=" + this.getDescricaoComplementarPagador() + ", codigoErroPagamento=" + this.getCodigoErroPagamento() + ", textoErro=" + this.getTextoErro() + ", message=" + this.getMessage() + ", erros=" + this.getErros() + ")";
    }
}

