/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.atendimento;

import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.atendimento.Atendimento;
import br.com.elotech.tributos.domain.atendimento.TipoAtendimento;
import br.com.elotech.tributos.domain.atendimento.TipoFiltroAtendimento;
import br.com.elotech.tributos.dto.AtendimentoPessoaDTO;
import br.com.elotech.tributos.dto.EnderecoCadastroGeralDTO;
import java.time.LocalDateTime;
import java.util.Optional;
import java.util.UUID;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;

public class AtendimentoDTO {
    private Long id;
    @NotNull
    private TipoAtendimento tipoAtendimento;
    private UUID atendente;
    private LocalDateTime horarioInicio;
    private LocalDateTime horarioFim;
    @Length(max=14)
    private @Length(max=14) String cpfCnpjRequerente;
    @Length(max=150)
    private @Length(max=150) String nomeRequerente;
    @Length(max=250)
    private @Length(max=250) String observacao;
    @NotNull
    private AtendimentoPessoaDTO contribuinte;
    @NotNull
    private EnderecoCadastroGeralDTO cadastroGeral;
    @NotNull
    private TipoFiltroAtendimento tipoFiltro;

    public Atendimento toEntity(CadastroGeral cadastroGeral) {
        Atendimento atendimento = new Atendimento();
        atendimento.setId(this.getId());
        atendimento.setAtendente(this.getAtendente());
        atendimento.setCadastroGeral(cadastroGeral);
        Optional.ofNullable(this.getContribuinte()).ifPresent(pessoa -> atendimento.setContribuinte(pessoa.toEntity(cadastroGeral)));
        atendimento.setCpfCnpjRequerente(this.getCpfCnpjRequerente());
        atendimento.setHorarioInicio(this.getHorarioInicio());
        atendimento.setHorarioFim(this.getHorarioFim());
        atendimento.setNomeRequerente(this.getNomeRequerente());
        atendimento.setObservacao(this.getObservacao());
        atendimento.setTipoAtendimento(this.getTipoAtendimento());
        atendimento.setTipoFiltro(this.tipoFiltro);
        return atendimento;
    }

    public static AtendimentoDTO from(Atendimento atendimento) {
        AtendimentoDTO dto = new AtendimentoDTO();
        Optional.ofNullable(atendimento.getId()).ifPresent(arg_0 -> dto.setId(arg_0));
        Optional.ofNullable(atendimento.getAtendente()).ifPresent(arg_0 -> dto.setAtendente(arg_0));
        Optional.ofNullable(atendimento.getCadastroGeral()).map(CadastroGeral::toEnderecoCadastroGeralDTO).ifPresent(arg_0 -> dto.setCadastroGeral(arg_0));
        Optional.ofNullable(atendimento.getContribuinte()).map(AtendimentoPessoaDTO::from).ifPresent(arg_0 -> dto.setContribuinte(arg_0));
        Optional.ofNullable(atendimento.getCpfCnpjRequerente()).ifPresent(arg_0 -> dto.setCpfCnpjRequerente(arg_0));
        Optional.ofNullable(atendimento.getHorarioFim()).ifPresent(arg_0 -> dto.setHorarioFim(arg_0));
        Optional.ofNullable(atendimento.getHorarioInicio()).ifPresent(arg_0 -> dto.setHorarioInicio(arg_0));
        Optional.ofNullable(atendimento.getNomeRequerente()).ifPresent(arg_0 -> dto.setNomeRequerente(arg_0));
        Optional.ofNullable(atendimento.getObservacao()).ifPresent(arg_0 -> dto.setObservacao(arg_0));
        Optional.ofNullable(atendimento.getTipoAtendimento()).ifPresent(arg_0 -> dto.setTipoAtendimento(arg_0));
        Optional.ofNullable(atendimento.getTipoFiltro()).ifPresent(arg_0 -> dto.setTipoFiltro(arg_0));
        return dto;
    }

    @Generated
    public AtendimentoDTO() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public TipoAtendimento getTipoAtendimento() {
        return this.tipoAtendimento;
    }

    @Generated
    public UUID getAtendente() {
        return this.atendente;
    }

    @Generated
    public LocalDateTime getHorarioInicio() {
        return this.horarioInicio;
    }

    @Generated
    public LocalDateTime getHorarioFim() {
        return this.horarioFim;
    }

    @Generated
    public String getCpfCnpjRequerente() {
        return this.cpfCnpjRequerente;
    }

    @Generated
    public String getNomeRequerente() {
        return this.nomeRequerente;
    }

    @Generated
    public String getObservacao() {
        return this.observacao;
    }

    @Generated
    public AtendimentoPessoaDTO getContribuinte() {
        return this.contribuinte;
    }

    @Generated
    public EnderecoCadastroGeralDTO getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public TipoFiltroAtendimento getTipoFiltro() {
        return this.tipoFiltro;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setTipoAtendimento(TipoAtendimento tipoAtendimento) {
        this.tipoAtendimento = tipoAtendimento;
    }

    @Generated
    public void setAtendente(UUID atendente) {
        this.atendente = atendente;
    }

    @Generated
    public void setHorarioInicio(LocalDateTime horarioInicio) {
        this.horarioInicio = horarioInicio;
    }

    @Generated
    public void setHorarioFim(LocalDateTime horarioFim) {
        this.horarioFim = horarioFim;
    }

    @Generated
    public void setCpfCnpjRequerente(String cpfCnpjRequerente) {
        this.cpfCnpjRequerente = cpfCnpjRequerente;
    }

    @Generated
    public void setNomeRequerente(String nomeRequerente) {
        this.nomeRequerente = nomeRequerente;
    }

    @Generated
    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Generated
    public void setContribuinte(AtendimentoPessoaDTO contribuinte) {
        this.contribuinte = contribuinte;
    }

    @Generated
    public void setCadastroGeral(EnderecoCadastroGeralDTO cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setTipoFiltro(TipoFiltroAtendimento tipoFiltro) {
        this.tipoFiltro = tipoFiltro;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AtendimentoDTO)) {
            return false;
        }
        AtendimentoDTO other = (AtendimentoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        TipoAtendimento this$tipoAtendimento = this.getTipoAtendimento();
        TipoAtendimento other$tipoAtendimento = other.getTipoAtendimento();
        if (this$tipoAtendimento == null ? other$tipoAtendimento != null : !this$tipoAtendimento.equals(other$tipoAtendimento)) {
            return false;
        }
        UUID this$atendente = this.getAtendente();
        UUID other$atendente = other.getAtendente();
        if (this$atendente == null ? other$atendente != null : !((Object)this$atendente).equals(other$atendente)) {
            return false;
        }
        LocalDateTime this$horarioInicio = this.getHorarioInicio();
        LocalDateTime other$horarioInicio = other.getHorarioInicio();
        if (this$horarioInicio == null ? other$horarioInicio != null : !((Object)this$horarioInicio).equals(other$horarioInicio)) {
            return false;
        }
        LocalDateTime this$horarioFim = this.getHorarioFim();
        LocalDateTime other$horarioFim = other.getHorarioFim();
        if (this$horarioFim == null ? other$horarioFim != null : !((Object)this$horarioFim).equals(other$horarioFim)) {
            return false;
        }
        String this$cpfCnpjRequerente = this.getCpfCnpjRequerente();
        String other$cpfCnpjRequerente = other.getCpfCnpjRequerente();
        if (this$cpfCnpjRequerente == null ? other$cpfCnpjRequerente != null : !this$cpfCnpjRequerente.equals(other$cpfCnpjRequerente)) {
            return false;
        }
        String this$nomeRequerente = this.getNomeRequerente();
        String other$nomeRequerente = other.getNomeRequerente();
        if (this$nomeRequerente == null ? other$nomeRequerente != null : !this$nomeRequerente.equals(other$nomeRequerente)) {
            return false;
        }
        String this$observacao = this.getObservacao();
        String other$observacao = other.getObservacao();
        if (this$observacao == null ? other$observacao != null : !this$observacao.equals(other$observacao)) {
            return false;
        }
        AtendimentoPessoaDTO this$contribuinte = this.getContribuinte();
        AtendimentoPessoaDTO other$contribuinte = other.getContribuinte();
        if (this$contribuinte == null ? other$contribuinte != null : !this$contribuinte.equals(other$contribuinte)) {
            return false;
        }
        EnderecoCadastroGeralDTO this$cadastroGeral = this.getCadastroGeral();
        EnderecoCadastroGeralDTO other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !this$cadastroGeral.equals(other$cadastroGeral)) {
            return false;
        }
        TipoFiltroAtendimento this$tipoFiltro = this.getTipoFiltro();
        TipoFiltroAtendimento other$tipoFiltro = other.getTipoFiltro();
        return !(this$tipoFiltro == null ? other$tipoFiltro != null : !this$tipoFiltro.equals(other$tipoFiltro));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AtendimentoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        TipoAtendimento $tipoAtendimento = this.getTipoAtendimento();
        result = result * 59 + ($tipoAtendimento == null ? 43 : $tipoAtendimento.hashCode());
        UUID $atendente = this.getAtendente();
        result = result * 59 + ($atendente == null ? 43 : ((Object)$atendente).hashCode());
        LocalDateTime $horarioInicio = this.getHorarioInicio();
        result = result * 59 + ($horarioInicio == null ? 43 : ((Object)$horarioInicio).hashCode());
        LocalDateTime $horarioFim = this.getHorarioFim();
        result = result * 59 + ($horarioFim == null ? 43 : ((Object)$horarioFim).hashCode());
        String $cpfCnpjRequerente = this.getCpfCnpjRequerente();
        result = result * 59 + ($cpfCnpjRequerente == null ? 43 : $cpfCnpjRequerente.hashCode());
        String $nomeRequerente = this.getNomeRequerente();
        result = result * 59 + ($nomeRequerente == null ? 43 : $nomeRequerente.hashCode());
        String $observacao = this.getObservacao();
        result = result * 59 + ($observacao == null ? 43 : $observacao.hashCode());
        AtendimentoPessoaDTO $contribuinte = this.getContribuinte();
        result = result * 59 + ($contribuinte == null ? 43 : $contribuinte.hashCode());
        EnderecoCadastroGeralDTO $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : $cadastroGeral.hashCode());
        TipoFiltroAtendimento $tipoFiltro = this.getTipoFiltro();
        result = result * 59 + ($tipoFiltro == null ? 43 : $tipoFiltro.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AtendimentoDTO(id=" + this.getId() + ", tipoAtendimento=" + this.getTipoAtendimento() + ", atendente=" + this.getAtendente() + ", horarioInicio=" + this.getHorarioInicio() + ", horarioFim=" + this.getHorarioFim() + ", cpfCnpjRequerente=" + this.getCpfCnpjRequerente() + ", nomeRequerente=" + this.getNomeRequerente() + ", observacao=" + this.getObservacao() + ", contribuinte=" + this.getContribuinte() + ", cadastroGeral=" + this.getCadastroGeral() + ", tipoFiltro=" + this.getTipoFiltro() + ")";
    }
}

