/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.elotech.core.exception.EloValidationException;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class CodigoBarrasDTO {
    private String codigoBarras;
    private String campo1;
    private String campo2;
    private String campo3;
    private String campo4;
    private String campo5;
    private String nossoNumero;
    private String linhaDigitavel;
    private String codigoBarrasFormatado;
    private String dvNossoNumero;

    public void generateCodigoBarrasFormatadoIntervalo2Of5() {
        if (StringUtils.isEmpty((CharSequence)this.codigoBarras)) {
            return;
        }
        String codigoBarras = this.codigoBarras;
        int tamanhoCodigoBarras = codigoBarras.length();
        if (tamanhoCodigoBarras % 2 != 0) {
            codigoBarras = String.format("%s%s", "0", codigoBarras);
            ++tamanhoCodigoBarras;
        }
        StringBuilder codigoBarrasFormatado = new StringBuilder("");
        int contador = tamanhoCodigoBarras / 2;
        for (int posicao = 0; posicao < contador; ++posicao) {
            int chunkCodigoBarras = Double.valueOf(StringUtils.substring((String)codigoBarras, (int)0, (int)2)).intValue();
            codigoBarrasFormatado.append(Optional.of(chunkCodigoBarras).filter(x -> x < 90).map(x -> Character.valueOf((char)(x + 33))).orElse(Character.valueOf((char)(chunkCodigoBarras + 71))));
            codigoBarras = StringUtils.substring((String)codigoBarras, (int)2);
        }
        this.codigoBarrasFormatado = String.format("%s%s%s", Character.valueOf('\u00ab'), codigoBarrasFormatado, Character.valueOf('\u00ac'));
    }

    public void generateDigitoVerificadorMod11(String modalidadeCarteira) {
        if (StringUtils.isEmpty((CharSequence)this.nossoNumero)) {
            return;
        }
        int total = 0;
        int multiplicador = 2;
        int limite = 9;
        String nossoNumeroReverse = StringUtils.reverse((String)String.format("%s%s", modalidadeCarteira, this.nossoNumero));
        for (int posicao = 0; posicao < nossoNumeroReverse.length(); ++posicao) {
            total += Optional.of(StringUtils.substring((String)nossoNumeroReverse, (int)posicao, (int)(posicao + 1))).map(Integer::valueOf).orElse(0) * multiplicador;
            if (multiplicador == limite) {
                multiplicador = 1;
            }
            ++multiplicador;
        }
        int digitoVerificador = 11 - (total - Double.valueOf(total / 11).intValue() * 11);
        if (digitoVerificador > limite) {
            this.dvNossoNumero = "0";
            return;
        }
        this.dvNossoNumero = Integer.toString(digitoVerificador);
    }

    public void validaDadosCodigoBarras() {
        if (StringUtils.isEmpty((CharSequence)this.getNossoNumero())) {
            throw new EloValidationException("Nosso n\u00famero n\u00e3o encontrado");
        }
        if (StringUtils.isEmpty((CharSequence)this.getCodigoBarras())) {
            throw new EloValidationException("C\u00f3digo de barras n\u00e3o encontrado");
        }
        if (StringUtils.isEmpty((CharSequence)this.getLinhaDigitavel())) {
            throw new EloValidationException("Linha digit\u00e1vel n\u00e3o encontrada");
        }
    }

    @Generated
    public CodigoBarrasDTO() {
    }

    @Generated
    public String getCodigoBarras() {
        return this.codigoBarras;
    }

    @Generated
    public String getCampo1() {
        return this.campo1;
    }

    @Generated
    public String getCampo2() {
        return this.campo2;
    }

    @Generated
    public String getCampo3() {
        return this.campo3;
    }

    @Generated
    public String getCampo4() {
        return this.campo4;
    }

    @Generated
    public String getCampo5() {
        return this.campo5;
    }

    @Generated
    public String getNossoNumero() {
        return this.nossoNumero;
    }

    @Generated
    public String getLinhaDigitavel() {
        return this.linhaDigitavel;
    }

    @Generated
    public String getCodigoBarrasFormatado() {
        return this.codigoBarrasFormatado;
    }

    @Generated
    public String getDvNossoNumero() {
        return this.dvNossoNumero;
    }

    @Generated
    public void setCodigoBarras(String codigoBarras) {
        this.codigoBarras = codigoBarras;
    }

    @Generated
    public void setCampo1(String campo1) {
        this.campo1 = campo1;
    }

    @Generated
    public void setCampo2(String campo2) {
        this.campo2 = campo2;
    }

    @Generated
    public void setCampo3(String campo3) {
        this.campo3 = campo3;
    }

    @Generated
    public void setCampo4(String campo4) {
        this.campo4 = campo4;
    }

    @Generated
    public void setCampo5(String campo5) {
        this.campo5 = campo5;
    }

    @Generated
    public void setNossoNumero(String nossoNumero) {
        this.nossoNumero = nossoNumero;
    }

    @Generated
    public void setLinhaDigitavel(String linhaDigitavel) {
        this.linhaDigitavel = linhaDigitavel;
    }

    @Generated
    public void setCodigoBarrasFormatado(String codigoBarrasFormatado) {
        this.codigoBarrasFormatado = codigoBarrasFormatado;
    }

    @Generated
    public void setDvNossoNumero(String dvNossoNumero) {
        this.dvNossoNumero = dvNossoNumero;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CodigoBarrasDTO)) {
            return false;
        }
        CodigoBarrasDTO other = (CodigoBarrasDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$codigoBarras = this.getCodigoBarras();
        String other$codigoBarras = other.getCodigoBarras();
        if (this$codigoBarras == null ? other$codigoBarras != null : !this$codigoBarras.equals(other$codigoBarras)) {
            return false;
        }
        String this$campo1 = this.getCampo1();
        String other$campo1 = other.getCampo1();
        if (this$campo1 == null ? other$campo1 != null : !this$campo1.equals(other$campo1)) {
            return false;
        }
        String this$campo2 = this.getCampo2();
        String other$campo2 = other.getCampo2();
        if (this$campo2 == null ? other$campo2 != null : !this$campo2.equals(other$campo2)) {
            return false;
        }
        String this$campo3 = this.getCampo3();
        String other$campo3 = other.getCampo3();
        if (this$campo3 == null ? other$campo3 != null : !this$campo3.equals(other$campo3)) {
            return false;
        }
        String this$campo4 = this.getCampo4();
        String other$campo4 = other.getCampo4();
        if (this$campo4 == null ? other$campo4 != null : !this$campo4.equals(other$campo4)) {
            return false;
        }
        String this$campo5 = this.getCampo5();
        String other$campo5 = other.getCampo5();
        if (this$campo5 == null ? other$campo5 != null : !this$campo5.equals(other$campo5)) {
            return false;
        }
        String this$nossoNumero = this.getNossoNumero();
        String other$nossoNumero = other.getNossoNumero();
        if (this$nossoNumero == null ? other$nossoNumero != null : !this$nossoNumero.equals(other$nossoNumero)) {
            return false;
        }
        String this$linhaDigitavel = this.getLinhaDigitavel();
        String other$linhaDigitavel = other.getLinhaDigitavel();
        if (this$linhaDigitavel == null ? other$linhaDigitavel != null : !this$linhaDigitavel.equals(other$linhaDigitavel)) {
            return false;
        }
        String this$codigoBarrasFormatado = this.getCodigoBarrasFormatado();
        String other$codigoBarrasFormatado = other.getCodigoBarrasFormatado();
        if (this$codigoBarrasFormatado == null ? other$codigoBarrasFormatado != null : !this$codigoBarrasFormatado.equals(other$codigoBarrasFormatado)) {
            return false;
        }
        String this$dvNossoNumero = this.getDvNossoNumero();
        String other$dvNossoNumero = other.getDvNossoNumero();
        return !(this$dvNossoNumero == null ? other$dvNossoNumero != null : !this$dvNossoNumero.equals(other$dvNossoNumero));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CodigoBarrasDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $codigoBarras = this.getCodigoBarras();
        result = result * 59 + ($codigoBarras == null ? 43 : $codigoBarras.hashCode());
        String $campo1 = this.getCampo1();
        result = result * 59 + ($campo1 == null ? 43 : $campo1.hashCode());
        String $campo2 = this.getCampo2();
        result = result * 59 + ($campo2 == null ? 43 : $campo2.hashCode());
        String $campo3 = this.getCampo3();
        result = result * 59 + ($campo3 == null ? 43 : $campo3.hashCode());
        String $campo4 = this.getCampo4();
        result = result * 59 + ($campo4 == null ? 43 : $campo4.hashCode());
        String $campo5 = this.getCampo5();
        result = result * 59 + ($campo5 == null ? 43 : $campo5.hashCode());
        String $nossoNumero = this.getNossoNumero();
        result = result * 59 + ($nossoNumero == null ? 43 : $nossoNumero.hashCode());
        String $linhaDigitavel = this.getLinhaDigitavel();
        result = result * 59 + ($linhaDigitavel == null ? 43 : $linhaDigitavel.hashCode());
        String $codigoBarrasFormatado = this.getCodigoBarrasFormatado();
        result = result * 59 + ($codigoBarrasFormatado == null ? 43 : $codigoBarrasFormatado.hashCode());
        String $dvNossoNumero = this.getDvNossoNumero();
        result = result * 59 + ($dvNossoNumero == null ? 43 : $dvNossoNumero.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CodigoBarrasDTO(codigoBarras=" + this.getCodigoBarras() + ", campo1=" + this.getCampo1() + ", campo2=" + this.getCampo2() + ", campo3=" + this.getCampo3() + ", campo4=" + this.getCampo4() + ", campo5=" + this.getCampo5() + ", nossoNumero=" + this.getNossoNumero() + ", linhaDigitavel=" + this.getLinhaDigitavel() + ", codigoBarrasFormatado=" + this.getCodigoBarrasFormatado() + ", dvNossoNumero=" + this.getDvNossoNumero() + ")";
    }
}

