/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.elotech.tributos.domain.Bairro;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Distrito;
import br.com.elotech.tributos.domain.Logradouro;
import br.com.elotech.tributos.domain.Setor;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.TipoCondicaoPessoaImovel;
import br.com.elotech.tributos.domain.TipoOrigemInscricao;
import br.com.elotech.tributos.domain.camposdinamicos.Resposta;
import br.com.elotech.tributos.domain.camposdinamicos.RespostaRural;
import br.com.elotech.tributos.domain.rural.CadastroRural;
import br.com.elotech.tributos.dto.BairroDTO;
import br.com.elotech.tributos.dto.LogradouroDTO;
import br.com.elotech.tributos.dto.cadastroimobiliario.ObservacaoDTO;
import br.com.elotech.tributos.dto.cadastroimobiliario.ProprietarioDTO;
import br.com.elotech.tributos.dto.camposdinamicos.GrupoRespostasDTO;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;

/*
 * Exception performing whole class analysis ignored.
 */
@JsonIgnoreProperties(ignoreUnknown=true)
public class CadastroRuralDTO {
    private Long id;
    private String usuario;
    private LocalDate dataInclusao;
    private LocalDate dataAlteracao;
    private String nomeProprietarioPrincipal;
    private TipoCadastro tipoCadastro = TipoCadastro.RURAL;
    private Long cadastroGeral;
    private Long cadastroGeralAnterior;
    private String endereco;
    private LogradouroDTO logradouro;
    private String complemento;
    private Distrito distrito;
    @JsonIgnoreProperties(value={"quadras"})
    private Setor setor;
    private BairroDTO bairro;
    private String lote;
    private String matricula;
    private Long oficio;
    private Boolean resideImovel;
    private List<ProprietarioDTO> proprietarios = new ArrayList();
    private Long numeroImovelReceita;
    private String codigoIncra;
    private String nomePropriedade;
    private BigDecimal quantidadeAlqueires = BigDecimal.ZERO;
    private BigDecimal quantidadeHectares = BigDecimal.ZERO;
    private BigDecimal valorTerreno = BigDecimal.ZERO;
    private BigDecimal areaArrendada = BigDecimal.ZERO;
    private BigDecimal areaCultivo = BigDecimal.ZERO;
    private BigDecimal areaPasto = BigDecimal.ZERO;
    private BigDecimal areaTotal = BigDecimal.ZERO;
    private BigDecimal areaTotalConstruida = BigDecimal.ZERO;
    private TipoOrigemInscricao origemInscricao;
    private TipoCondicaoPessoaImovel condicaoPessoaImovel;
    private List<ObservacaoDTO> observacoes = new ArrayList();
    private List<GrupoRespostasDTO> respostasRurais = new ArrayList();

    public static CadastroRuralDTO from(CadastroRural cadastroRural) {
        CadastroRuralDTO dto = new CadastroRuralDTO();
        dto.setId(cadastroRural.getId());
        dto.setUsuario(cadastroRural.getUsuario());
        dto.setDataInclusao(cadastroRural.getDataInclusao());
        dto.setDataAlteracao(cadastroRural.getDataAlteracao());
        cadastroRural.getProprietarioPrincipal().ifPresent(proprietario -> dto.setNomeProprietarioPrincipal(proprietario.getPessoa().getNome()));
        Optional.ofNullable(cadastroRural.getCadastroGeral()).ifPresent(arg_0 -> dto.setCadastroGeral(arg_0));
        Optional.ofNullable(cadastroRural.getCadastroGeralAnterior()).ifPresent(arg_0 -> dto.setCadastroGeralAnterior(arg_0));
        Optional.ofNullable(cadastroRural.getEndereco()).ifPresent(arg_0 -> dto.setEndereco(arg_0));
        Optional.ofNullable(cadastroRural.getLogradouro()).ifPresent(logradouro -> dto.setLogradouro(LogradouroDTO.from((Logradouro)logradouro)));
        Optional.ofNullable(cadastroRural.getComplemento()).ifPresent(arg_0 -> dto.setComplemento(arg_0));
        Optional.ofNullable(cadastroRural.getDistrito()).ifPresent(arg_0 -> dto.setDistrito(arg_0));
        Optional.ofNullable(cadastroRural.getSetor()).ifPresent(arg_0 -> dto.setSetor(arg_0));
        Optional.ofNullable(cadastroRural.getLote()).ifPresent(arg_0 -> dto.setLote(arg_0));
        Optional.ofNullable(cadastroRural.getBairro()).ifPresent(bairro -> dto.setBairro(BairroDTO.from((Bairro)bairro)));
        Optional.ofNullable(cadastroRural.getMatricula()).ifPresent(arg_0 -> dto.setMatricula(arg_0));
        Optional.ofNullable(cadastroRural.getOficio()).ifPresent(arg_0 -> dto.setOficio(arg_0));
        Optional.ofNullable(cadastroRural.getResideImovel()).ifPresent(arg_0 -> dto.setResideImovel(arg_0));
        dto.setProprietarios(cadastroRural.getProprietarios().stream().map(ProprietarioDTO::from).collect(Collectors.toList()));
        Optional.ofNullable(cadastroRural.getNumeroImovelReceita()).ifPresent(arg_0 -> dto.setNumeroImovelReceita(arg_0));
        Optional.ofNullable(cadastroRural.getCodigoIncra()).ifPresent(arg_0 -> dto.setCodigoIncra(arg_0));
        Optional.ofNullable(cadastroRural.getNomePropriedade()).ifPresent(arg_0 -> dto.setNomePropriedade(arg_0));
        Optional.ofNullable(cadastroRural.getQuantidadeAlqueires()).ifPresent(arg_0 -> dto.setQuantidadeAlqueires(arg_0));
        Optional.ofNullable(cadastroRural.getQuantidadeHectares()).ifPresent(arg_0 -> dto.setQuantidadeHectares(arg_0));
        Optional.ofNullable(cadastroRural.getAreaTotal()).ifPresent(arg_0 -> dto.setAreaTotal(arg_0));
        Optional.ofNullable(cadastroRural.getAreaArrendada()).ifPresent(arg_0 -> dto.setAreaArrendada(arg_0));
        Optional.ofNullable(cadastroRural.getAreaCultivo()).ifPresent(arg_0 -> dto.setAreaCultivo(arg_0));
        Optional.ofNullable(cadastroRural.getAreaPasto()).ifPresent(arg_0 -> dto.setAreaPasto(arg_0));
        Optional.ofNullable(cadastroRural.getValorTerreno()).ifPresent(arg_0 -> dto.setValorTerreno(arg_0));
        Optional.ofNullable(cadastroRural.getAreaTotalConstruida()).ifPresent(arg_0 -> dto.setAreaTotalConstruida(arg_0));
        Optional.ofNullable(cadastroRural.getOrigemInscricao()).ifPresent(arg_0 -> dto.setOrigemInscricao(arg_0));
        Optional.ofNullable(cadastroRural.getCondicaoPessoaImovel()).ifPresent(arg_0 -> dto.setCondicaoPessoaImovel(arg_0));
        dto.getObservacoes().addAll(cadastroRural.getObservacoes().stream().map(ObservacaoDTO::from).collect(Collectors.toList()));
        return dto;
    }

    public CadastroRural toEntity() {
        CadastroRural cadastroRural = new CadastroRural();
        cadastroRural.setId(this.getId());
        cadastroRural.setTipoCadastro(TipoCadastro.RURAL);
        cadastroRural.setCadastroGeral(this.getCadastroGeral());
        cadastroRural.setCadastroGeralAnterior(this.getCadastroGeralAnterior());
        Optional.ofNullable(this.getLogradouro()).ifPresent(logradouroDTO -> cadastroRural.setLogradouro(logradouroDTO.toEntity()));
        Optional.ofNullable(this.getBairro()).ifPresent(bairroDTO -> cadastroRural.setBairro(bairroDTO.toEntity()));
        cadastroRural.setComplemento(this.getComplemento());
        cadastroRural.setEndereco(this.getEndereco());
        cadastroRural.setLote(this.getLote());
        cadastroRural.setDistrito(this.getDistrito());
        cadastroRural.setSetor(this.getSetor());
        cadastroRural.setMatricula(this.getMatricula());
        cadastroRural.setOficio(this.getOficio());
        cadastroRural.setResideImovel(this.getResideImovel());
        cadastroRural.getProprietarios().addAll(this.proprietarios.stream().map(ProprietarioDTO::toEntity).collect(Collectors.toList()));
        Optional.ofNullable(this.getNumeroImovelReceita()).ifPresent(arg_0 -> ((CadastroRural)cadastroRural).setNumeroImovelReceita(arg_0));
        Optional.ofNullable(this.getCodigoIncra()).ifPresent(arg_0 -> ((CadastroRural)cadastroRural).setCodigoIncra(arg_0));
        Optional.ofNullable(this.getNomePropriedade()).ifPresent(arg_0 -> ((CadastroRural)cadastroRural).setNomePropriedade(arg_0));
        Optional.ofNullable(this.getQuantidadeAlqueires()).ifPresent(arg_0 -> ((CadastroRural)cadastroRural).setQuantidadeAlqueires(arg_0));
        Optional.ofNullable(this.getQuantidadeHectares()).ifPresent(arg_0 -> ((CadastroRural)cadastroRural).setQuantidadeHectares(arg_0));
        Optional.ofNullable(this.getAreaTotal()).ifPresent(arg_0 -> ((CadastroRural)cadastroRural).setAreaTotal(arg_0));
        Optional.ofNullable(this.getAreaArrendada()).ifPresent(arg_0 -> ((CadastroRural)cadastroRural).setAreaArrendada(arg_0));
        Optional.ofNullable(this.getAreaCultivo()).ifPresent(arg_0 -> ((CadastroRural)cadastroRural).setAreaCultivo(arg_0));
        Optional.ofNullable(this.getAreaPasto()).ifPresent(arg_0 -> ((CadastroRural)cadastroRural).setAreaPasto(arg_0));
        Optional.ofNullable(this.getValorTerreno()).ifPresent(arg_0 -> ((CadastroRural)cadastroRural).setValorTerreno(arg_0));
        Optional.ofNullable(this.getAreaTotalConstruida()).ifPresent(arg_0 -> ((CadastroRural)cadastroRural).setAreaTotalConstruida(arg_0));
        Optional.ofNullable(this.getOrigemInscricao()).ifPresent(arg_0 -> ((CadastroRural)cadastroRural).setOrigemInscricao(arg_0));
        Optional.ofNullable(this.getCondicaoPessoaImovel()).ifPresent(arg_0 -> ((CadastroRural)cadastroRural).setCondicaoPessoaImovel(arg_0));
        cadastroRural.getObservacoes().addAll(this.observacoes.stream().map(observacao -> observacao.toEntity((CadastroGeral)cadastroRural)).collect(Collectors.toList()));
        this.getRespostasRurais().forEach(grupoRespostasDTO -> grupoRespostasDTO.getRespostasPreenchidas().forEach(resposta -> cadastroRural.getRespostasRurais().add((RespostaRural)resposta.copyTo((Resposta)new RespostaRural()))));
        return cadastroRural;
    }

    public static CadastroRuralDTO fromComRespostaAgrupada(CadastroRural entity) {
        CadastroRuralDTO dto = CadastroRuralDTO.from((CadastroRural)entity);
        List grupoRespostasDTOS = GrupoRespostasDTO.agruparRespostasPorGrupoCampo((List)entity.getRespostasAvulso());
        dto.setRespostasRurais(grupoRespostasDTOS);
        return dto;
    }

    @Generated
    public CadastroRuralDTO() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getUsuario() {
        return this.usuario;
    }

    @Generated
    public LocalDate getDataInclusao() {
        return this.dataInclusao;
    }

    @Generated
    public LocalDate getDataAlteracao() {
        return this.dataAlteracao;
    }

    @Generated
    public String getNomeProprietarioPrincipal() {
        return this.nomeProprietarioPrincipal;
    }

    @Generated
    public TipoCadastro getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public Long getCadastroGeralAnterior() {
        return this.cadastroGeralAnterior;
    }

    @Generated
    public String getEndereco() {
        return this.endereco;
    }

    @Generated
    public LogradouroDTO getLogradouro() {
        return this.logradouro;
    }

    @Generated
    public String getComplemento() {
        return this.complemento;
    }

    @Generated
    public Distrito getDistrito() {
        return this.distrito;
    }

    @Generated
    public Setor getSetor() {
        return this.setor;
    }

    @Generated
    public BairroDTO getBairro() {
        return this.bairro;
    }

    @Generated
    public String getLote() {
        return this.lote;
    }

    @Generated
    public String getMatricula() {
        return this.matricula;
    }

    @Generated
    public Long getOficio() {
        return this.oficio;
    }

    @Generated
    public Boolean getResideImovel() {
        return this.resideImovel;
    }

    @Generated
    public List<ProprietarioDTO> getProprietarios() {
        return this.proprietarios;
    }

    @Generated
    public Long getNumeroImovelReceita() {
        return this.numeroImovelReceita;
    }

    @Generated
    public String getCodigoIncra() {
        return this.codigoIncra;
    }

    @Generated
    public String getNomePropriedade() {
        return this.nomePropriedade;
    }

    @Generated
    public BigDecimal getQuantidadeAlqueires() {
        return this.quantidadeAlqueires;
    }

    @Generated
    public BigDecimal getQuantidadeHectares() {
        return this.quantidadeHectares;
    }

    @Generated
    public BigDecimal getValorTerreno() {
        return this.valorTerreno;
    }

    @Generated
    public BigDecimal getAreaArrendada() {
        return this.areaArrendada;
    }

    @Generated
    public BigDecimal getAreaCultivo() {
        return this.areaCultivo;
    }

    @Generated
    public BigDecimal getAreaPasto() {
        return this.areaPasto;
    }

    @Generated
    public BigDecimal getAreaTotal() {
        return this.areaTotal;
    }

    @Generated
    public BigDecimal getAreaTotalConstruida() {
        return this.areaTotalConstruida;
    }

    @Generated
    public TipoOrigemInscricao getOrigemInscricao() {
        return this.origemInscricao;
    }

    @Generated
    public TipoCondicaoPessoaImovel getCondicaoPessoaImovel() {
        return this.condicaoPessoaImovel;
    }

    @Generated
    public List<ObservacaoDTO> getObservacoes() {
        return this.observacoes;
    }

    @Generated
    public List<GrupoRespostasDTO> getRespostasRurais() {
        return this.respostasRurais;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    @Generated
    public void setDataInclusao(LocalDate dataInclusao) {
        this.dataInclusao = dataInclusao;
    }

    @Generated
    public void setDataAlteracao(LocalDate dataAlteracao) {
        this.dataAlteracao = dataAlteracao;
    }

    @Generated
    public void setNomeProprietarioPrincipal(String nomeProprietarioPrincipal) {
        this.nomeProprietarioPrincipal = nomeProprietarioPrincipal;
    }

    @Generated
    public void setTipoCadastro(TipoCadastro tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setCadastroGeralAnterior(Long cadastroGeralAnterior) {
        this.cadastroGeralAnterior = cadastroGeralAnterior;
    }

    @Generated
    public void setEndereco(String endereco) {
        this.endereco = endereco;
    }

    @Generated
    public void setLogradouro(LogradouroDTO logradouro) {
        this.logradouro = logradouro;
    }

    @Generated
    public void setComplemento(String complemento) {
        this.complemento = complemento;
    }

    @Generated
    public void setDistrito(Distrito distrito) {
        this.distrito = distrito;
    }

    @Generated
    public void setSetor(Setor setor) {
        this.setor = setor;
    }

    @Generated
    public void setBairro(BairroDTO bairro) {
        this.bairro = bairro;
    }

    @Generated
    public void setLote(String lote) {
        this.lote = lote;
    }

    @Generated
    public void setMatricula(String matricula) {
        this.matricula = matricula;
    }

    @Generated
    public void setOficio(Long oficio) {
        this.oficio = oficio;
    }

    @Generated
    public void setResideImovel(Boolean resideImovel) {
        this.resideImovel = resideImovel;
    }

    @Generated
    public void setProprietarios(List<ProprietarioDTO> proprietarios) {
        this.proprietarios = proprietarios;
    }

    @Generated
    public void setNumeroImovelReceita(Long numeroImovelReceita) {
        this.numeroImovelReceita = numeroImovelReceita;
    }

    @Generated
    public void setCodigoIncra(String codigoIncra) {
        this.codigoIncra = codigoIncra;
    }

    @Generated
    public void setNomePropriedade(String nomePropriedade) {
        this.nomePropriedade = nomePropriedade;
    }

    @Generated
    public void setQuantidadeAlqueires(BigDecimal quantidadeAlqueires) {
        this.quantidadeAlqueires = quantidadeAlqueires;
    }

    @Generated
    public void setQuantidadeHectares(BigDecimal quantidadeHectares) {
        this.quantidadeHectares = quantidadeHectares;
    }

    @Generated
    public void setValorTerreno(BigDecimal valorTerreno) {
        this.valorTerreno = valorTerreno;
    }

    @Generated
    public void setAreaArrendada(BigDecimal areaArrendada) {
        this.areaArrendada = areaArrendada;
    }

    @Generated
    public void setAreaCultivo(BigDecimal areaCultivo) {
        this.areaCultivo = areaCultivo;
    }

    @Generated
    public void setAreaPasto(BigDecimal areaPasto) {
        this.areaPasto = areaPasto;
    }

    @Generated
    public void setAreaTotal(BigDecimal areaTotal) {
        this.areaTotal = areaTotal;
    }

    @Generated
    public void setAreaTotalConstruida(BigDecimal areaTotalConstruida) {
        this.areaTotalConstruida = areaTotalConstruida;
    }

    @Generated
    public void setOrigemInscricao(TipoOrigemInscricao origemInscricao) {
        this.origemInscricao = origemInscricao;
    }

    @Generated
    public void setCondicaoPessoaImovel(TipoCondicaoPessoaImovel condicaoPessoaImovel) {
        this.condicaoPessoaImovel = condicaoPessoaImovel;
    }

    @Generated
    public void setObservacoes(List<ObservacaoDTO> observacoes) {
        this.observacoes = observacoes;
    }

    @Generated
    public void setRespostasRurais(List<GrupoRespostasDTO> respostasRurais) {
        this.respostasRurais = respostasRurais;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CadastroRuralDTO)) {
            return false;
        }
        CadastroRuralDTO other = (CadastroRuralDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$usuario = this.getUsuario();
        String other$usuario = other.getUsuario();
        if (this$usuario == null ? other$usuario != null : !this$usuario.equals(other$usuario)) {
            return false;
        }
        LocalDate this$dataInclusao = this.getDataInclusao();
        LocalDate other$dataInclusao = other.getDataInclusao();
        if (this$dataInclusao == null ? other$dataInclusao != null : !((Object)this$dataInclusao).equals(other$dataInclusao)) {
            return false;
        }
        LocalDate this$dataAlteracao = this.getDataAlteracao();
        LocalDate other$dataAlteracao = other.getDataAlteracao();
        if (this$dataAlteracao == null ? other$dataAlteracao != null : !((Object)this$dataAlteracao).equals(other$dataAlteracao)) {
            return false;
        }
        String this$nomeProprietarioPrincipal = this.getNomeProprietarioPrincipal();
        String other$nomeProprietarioPrincipal = other.getNomeProprietarioPrincipal();
        if (this$nomeProprietarioPrincipal == null ? other$nomeProprietarioPrincipal != null : !this$nomeProprietarioPrincipal.equals(other$nomeProprietarioPrincipal)) {
            return false;
        }
        TipoCadastro this$tipoCadastro = this.getTipoCadastro();
        TipoCadastro other$tipoCadastro = other.getTipoCadastro();
        if (this$tipoCadastro == null ? other$tipoCadastro != null : !this$tipoCadastro.equals(other$tipoCadastro)) {
            return false;
        }
        Long this$cadastroGeral = this.getCadastroGeral();
        Long other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !((Object)this$cadastroGeral).equals(other$cadastroGeral)) {
            return false;
        }
        Long this$cadastroGeralAnterior = this.getCadastroGeralAnterior();
        Long other$cadastroGeralAnterior = other.getCadastroGeralAnterior();
        if (this$cadastroGeralAnterior == null ? other$cadastroGeralAnterior != null : !((Object)this$cadastroGeralAnterior).equals(other$cadastroGeralAnterior)) {
            return false;
        }
        String this$endereco = this.getEndereco();
        String other$endereco = other.getEndereco();
        if (this$endereco == null ? other$endereco != null : !this$endereco.equals(other$endereco)) {
            return false;
        }
        LogradouroDTO this$logradouro = this.getLogradouro();
        LogradouroDTO other$logradouro = other.getLogradouro();
        if (this$logradouro == null ? other$logradouro != null : !this$logradouro.equals(other$logradouro)) {
            return false;
        }
        String this$complemento = this.getComplemento();
        String other$complemento = other.getComplemento();
        if (this$complemento == null ? other$complemento != null : !this$complemento.equals(other$complemento)) {
            return false;
        }
        Distrito this$distrito = this.getDistrito();
        Distrito other$distrito = other.getDistrito();
        if (this$distrito == null ? other$distrito != null : !this$distrito.equals(other$distrito)) {
            return false;
        }
        Setor this$setor = this.getSetor();
        Setor other$setor = other.getSetor();
        if (this$setor == null ? other$setor != null : !this$setor.equals(other$setor)) {
            return false;
        }
        BairroDTO this$bairro = this.getBairro();
        BairroDTO other$bairro = other.getBairro();
        if (this$bairro == null ? other$bairro != null : !this$bairro.equals(other$bairro)) {
            return false;
        }
        String this$lote = this.getLote();
        String other$lote = other.getLote();
        if (this$lote == null ? other$lote != null : !this$lote.equals(other$lote)) {
            return false;
        }
        String this$matricula = this.getMatricula();
        String other$matricula = other.getMatricula();
        if (this$matricula == null ? other$matricula != null : !this$matricula.equals(other$matricula)) {
            return false;
        }
        Long this$oficio = this.getOficio();
        Long other$oficio = other.getOficio();
        if (this$oficio == null ? other$oficio != null : !((Object)this$oficio).equals(other$oficio)) {
            return false;
        }
        Boolean this$resideImovel = this.getResideImovel();
        Boolean other$resideImovel = other.getResideImovel();
        if (this$resideImovel == null ? other$resideImovel != null : !((Object)this$resideImovel).equals(other$resideImovel)) {
            return false;
        }
        List this$proprietarios = this.getProprietarios();
        List other$proprietarios = other.getProprietarios();
        if (this$proprietarios == null ? other$proprietarios != null : !((Object)this$proprietarios).equals(other$proprietarios)) {
            return false;
        }
        Long this$numeroImovelReceita = this.getNumeroImovelReceita();
        Long other$numeroImovelReceita = other.getNumeroImovelReceita();
        if (this$numeroImovelReceita == null ? other$numeroImovelReceita != null : !((Object)this$numeroImovelReceita).equals(other$numeroImovelReceita)) {
            return false;
        }
        String this$codigoIncra = this.getCodigoIncra();
        String other$codigoIncra = other.getCodigoIncra();
        if (this$codigoIncra == null ? other$codigoIncra != null : !this$codigoIncra.equals(other$codigoIncra)) {
            return false;
        }
        String this$nomePropriedade = this.getNomePropriedade();
        String other$nomePropriedade = other.getNomePropriedade();
        if (this$nomePropriedade == null ? other$nomePropriedade != null : !this$nomePropriedade.equals(other$nomePropriedade)) {
            return false;
        }
        BigDecimal this$quantidadeAlqueires = this.getQuantidadeAlqueires();
        BigDecimal other$quantidadeAlqueires = other.getQuantidadeAlqueires();
        if (this$quantidadeAlqueires == null ? other$quantidadeAlqueires != null : !((Object)this$quantidadeAlqueires).equals(other$quantidadeAlqueires)) {
            return false;
        }
        BigDecimal this$quantidadeHectares = this.getQuantidadeHectares();
        BigDecimal other$quantidadeHectares = other.getQuantidadeHectares();
        if (this$quantidadeHectares == null ? other$quantidadeHectares != null : !((Object)this$quantidadeHectares).equals(other$quantidadeHectares)) {
            return false;
        }
        BigDecimal this$valorTerreno = this.getValorTerreno();
        BigDecimal other$valorTerreno = other.getValorTerreno();
        if (this$valorTerreno == null ? other$valorTerreno != null : !((Object)this$valorTerreno).equals(other$valorTerreno)) {
            return false;
        }
        BigDecimal this$areaArrendada = this.getAreaArrendada();
        BigDecimal other$areaArrendada = other.getAreaArrendada();
        if (this$areaArrendada == null ? other$areaArrendada != null : !((Object)this$areaArrendada).equals(other$areaArrendada)) {
            return false;
        }
        BigDecimal this$areaCultivo = this.getAreaCultivo();
        BigDecimal other$areaCultivo = other.getAreaCultivo();
        if (this$areaCultivo == null ? other$areaCultivo != null : !((Object)this$areaCultivo).equals(other$areaCultivo)) {
            return false;
        }
        BigDecimal this$areaPasto = this.getAreaPasto();
        BigDecimal other$areaPasto = other.getAreaPasto();
        if (this$areaPasto == null ? other$areaPasto != null : !((Object)this$areaPasto).equals(other$areaPasto)) {
            return false;
        }
        BigDecimal this$areaTotal = this.getAreaTotal();
        BigDecimal other$areaTotal = other.getAreaTotal();
        if (this$areaTotal == null ? other$areaTotal != null : !((Object)this$areaTotal).equals(other$areaTotal)) {
            return false;
        }
        BigDecimal this$areaTotalConstruida = this.getAreaTotalConstruida();
        BigDecimal other$areaTotalConstruida = other.getAreaTotalConstruida();
        if (this$areaTotalConstruida == null ? other$areaTotalConstruida != null : !((Object)this$areaTotalConstruida).equals(other$areaTotalConstruida)) {
            return false;
        }
        TipoOrigemInscricao this$origemInscricao = this.getOrigemInscricao();
        TipoOrigemInscricao other$origemInscricao = other.getOrigemInscricao();
        if (this$origemInscricao == null ? other$origemInscricao != null : !this$origemInscricao.equals(other$origemInscricao)) {
            return false;
        }
        TipoCondicaoPessoaImovel this$condicaoPessoaImovel = this.getCondicaoPessoaImovel();
        TipoCondicaoPessoaImovel other$condicaoPessoaImovel = other.getCondicaoPessoaImovel();
        if (this$condicaoPessoaImovel == null ? other$condicaoPessoaImovel != null : !this$condicaoPessoaImovel.equals(other$condicaoPessoaImovel)) {
            return false;
        }
        List this$observacoes = this.getObservacoes();
        List other$observacoes = other.getObservacoes();
        if (this$observacoes == null ? other$observacoes != null : !((Object)this$observacoes).equals(other$observacoes)) {
            return false;
        }
        List this$respostasRurais = this.getRespostasRurais();
        List other$respostasRurais = other.getRespostasRurais();
        return !(this$respostasRurais == null ? other$respostasRurais != null : !((Object)this$respostasRurais).equals(other$respostasRurais));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CadastroRuralDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $usuario = this.getUsuario();
        result = result * 59 + ($usuario == null ? 43 : $usuario.hashCode());
        LocalDate $dataInclusao = this.getDataInclusao();
        result = result * 59 + ($dataInclusao == null ? 43 : ((Object)$dataInclusao).hashCode());
        LocalDate $dataAlteracao = this.getDataAlteracao();
        result = result * 59 + ($dataAlteracao == null ? 43 : ((Object)$dataAlteracao).hashCode());
        String $nomeProprietarioPrincipal = this.getNomeProprietarioPrincipal();
        result = result * 59 + ($nomeProprietarioPrincipal == null ? 43 : $nomeProprietarioPrincipal.hashCode());
        TipoCadastro $tipoCadastro = this.getTipoCadastro();
        result = result * 59 + ($tipoCadastro == null ? 43 : $tipoCadastro.hashCode());
        Long $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : ((Object)$cadastroGeral).hashCode());
        Long $cadastroGeralAnterior = this.getCadastroGeralAnterior();
        result = result * 59 + ($cadastroGeralAnterior == null ? 43 : ((Object)$cadastroGeralAnterior).hashCode());
        String $endereco = this.getEndereco();
        result = result * 59 + ($endereco == null ? 43 : $endereco.hashCode());
        LogradouroDTO $logradouro = this.getLogradouro();
        result = result * 59 + ($logradouro == null ? 43 : $logradouro.hashCode());
        String $complemento = this.getComplemento();
        result = result * 59 + ($complemento == null ? 43 : $complemento.hashCode());
        Distrito $distrito = this.getDistrito();
        result = result * 59 + ($distrito == null ? 43 : $distrito.hashCode());
        Setor $setor = this.getSetor();
        result = result * 59 + ($setor == null ? 43 : $setor.hashCode());
        BairroDTO $bairro = this.getBairro();
        result = result * 59 + ($bairro == null ? 43 : $bairro.hashCode());
        String $lote = this.getLote();
        result = result * 59 + ($lote == null ? 43 : $lote.hashCode());
        String $matricula = this.getMatricula();
        result = result * 59 + ($matricula == null ? 43 : $matricula.hashCode());
        Long $oficio = this.getOficio();
        result = result * 59 + ($oficio == null ? 43 : ((Object)$oficio).hashCode());
        Boolean $resideImovel = this.getResideImovel();
        result = result * 59 + ($resideImovel == null ? 43 : ((Object)$resideImovel).hashCode());
        List $proprietarios = this.getProprietarios();
        result = result * 59 + ($proprietarios == null ? 43 : ((Object)$proprietarios).hashCode());
        Long $numeroImovelReceita = this.getNumeroImovelReceita();
        result = result * 59 + ($numeroImovelReceita == null ? 43 : ((Object)$numeroImovelReceita).hashCode());
        String $codigoIncra = this.getCodigoIncra();
        result = result * 59 + ($codigoIncra == null ? 43 : $codigoIncra.hashCode());
        String $nomePropriedade = this.getNomePropriedade();
        result = result * 59 + ($nomePropriedade == null ? 43 : $nomePropriedade.hashCode());
        BigDecimal $quantidadeAlqueires = this.getQuantidadeAlqueires();
        result = result * 59 + ($quantidadeAlqueires == null ? 43 : ((Object)$quantidadeAlqueires).hashCode());
        BigDecimal $quantidadeHectares = this.getQuantidadeHectares();
        result = result * 59 + ($quantidadeHectares == null ? 43 : ((Object)$quantidadeHectares).hashCode());
        BigDecimal $valorTerreno = this.getValorTerreno();
        result = result * 59 + ($valorTerreno == null ? 43 : ((Object)$valorTerreno).hashCode());
        BigDecimal $areaArrendada = this.getAreaArrendada();
        result = result * 59 + ($areaArrendada == null ? 43 : ((Object)$areaArrendada).hashCode());
        BigDecimal $areaCultivo = this.getAreaCultivo();
        result = result * 59 + ($areaCultivo == null ? 43 : ((Object)$areaCultivo).hashCode());
        BigDecimal $areaPasto = this.getAreaPasto();
        result = result * 59 + ($areaPasto == null ? 43 : ((Object)$areaPasto).hashCode());
        BigDecimal $areaTotal = this.getAreaTotal();
        result = result * 59 + ($areaTotal == null ? 43 : ((Object)$areaTotal).hashCode());
        BigDecimal $areaTotalConstruida = this.getAreaTotalConstruida();
        result = result * 59 + ($areaTotalConstruida == null ? 43 : ((Object)$areaTotalConstruida).hashCode());
        TipoOrigemInscricao $origemInscricao = this.getOrigemInscricao();
        result = result * 59 + ($origemInscricao == null ? 43 : $origemInscricao.hashCode());
        TipoCondicaoPessoaImovel $condicaoPessoaImovel = this.getCondicaoPessoaImovel();
        result = result * 59 + ($condicaoPessoaImovel == null ? 43 : $condicaoPessoaImovel.hashCode());
        List $observacoes = this.getObservacoes();
        result = result * 59 + ($observacoes == null ? 43 : ((Object)$observacoes).hashCode());
        List $respostasRurais = this.getRespostasRurais();
        result = result * 59 + ($respostasRurais == null ? 43 : ((Object)$respostasRurais).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CadastroRuralDTO(id=" + this.getId() + ", usuario=" + this.getUsuario() + ", dataInclusao=" + this.getDataInclusao() + ", dataAlteracao=" + this.getDataAlteracao() + ", nomeProprietarioPrincipal=" + this.getNomeProprietarioPrincipal() + ", tipoCadastro=" + this.getTipoCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ", cadastroGeralAnterior=" + this.getCadastroGeralAnterior() + ", endereco=" + this.getEndereco() + ", logradouro=" + this.getLogradouro() + ", complemento=" + this.getComplemento() + ", distrito=" + this.getDistrito() + ", setor=" + this.getSetor() + ", bairro=" + this.getBairro() + ", lote=" + this.getLote() + ", matricula=" + this.getMatricula() + ", oficio=" + this.getOficio() + ", resideImovel=" + this.getResideImovel() + ", proprietarios=" + this.getProprietarios() + ", numeroImovelReceita=" + this.getNumeroImovelReceita() + ", codigoIncra=" + this.getCodigoIncra() + ", nomePropriedade=" + this.getNomePropriedade() + ", quantidadeAlqueires=" + this.getQuantidadeAlqueires() + ", quantidadeHectares=" + this.getQuantidadeHectares() + ", valorTerreno=" + this.getValorTerreno() + ", areaArrendada=" + this.getAreaArrendada() + ", areaCultivo=" + this.getAreaCultivo() + ", areaPasto=" + this.getAreaPasto() + ", areaTotal=" + this.getAreaTotal() + ", areaTotalConstruida=" + this.getAreaTotalConstruida() + ", origemInscricao=" + this.getOrigemInscricao() + ", condicaoPessoaImovel=" + this.getCondicaoPessoaImovel() + ", observacoes=" + this.getObservacoes() + ", respostasRurais=" + this.getRespostasRurais() + ")";
    }
}

