/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.pagamento;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.converter.SituacaoPagamentoLoteConverter;
import br.com.elotech.tributos.converter.TipoPagamentoLoteConverter;
import br.com.elotech.tributos.domain.Banco;
import br.com.elotech.tributos.domain.ContaBancaria;
import br.com.elotech.tributos.domain.Convenio;
import br.com.elotech.tributos.domain.TipoArquivoRetornoPagamento;
import br.com.elotech.tributos.domain.batch.BatchJobExecution;
import br.com.elotech.tributos.domain.integracaocontabil.LoteIntegracaoContabil;
import br.com.elotech.tributos.domain.pagamento.PagamentoLoteId;
import br.com.elotech.tributos.domain.pagamento.SituacaoPagamentoLote;
import br.com.elotech.tributos.domain.pagamento.TipoPagamentoLote;
import java.time.LocalDate;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.annotations.JoinColumnOrFormula;
import org.hibernate.annotations.JoinColumnsOrFormulas;
import org.hibernate.annotations.JoinFormula;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="TRIBPAGAMENTOLOTE")
public class PagamentoLote
implements EloEntity<PagamentoLoteId> {
    @EmbeddedId
    private PagamentoLoteId id;
    @NotNull(message="Data do lote obrigat\u00f3rio no pagamento lote")
    private @NotNull(message="Data do lote obrigat\u00f3rio no pagamento lote") LocalDate dataLote;
    private LocalDate dataMovimento;
    private LocalDate dataCredito;
    @ManyToOne
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="entidade", referencedColumnName="entidade")), @JoinColumnOrFormula(column=@JoinColumn(name="convenio", referencedColumnName="convenio"))})
    private Convenio convenio;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="entidade", referencedColumnName="entidade")), @JoinColumnOrFormula(column=@JoinColumn(name="contabancaria", referencedColumnName="contabancaria"))})
    private ContaBancaria contaBancaria;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="banco")
    private Banco banco;
    @Convert(converter=TipoPagamentoLoteConverter.class)
    private TipoPagamentoLote tipo;
    @Column(name="situacaoLote")
    @Convert(converter=SituacaoPagamentoLoteConverter.class)
    private SituacaoPagamentoLote situacao;
    private Long numeroLote;
    private String arquivoHash;
    private String nomeArquivo;
    private TipoArquivoRetornoPagamento tipoArquivo;
    @Length(max=400)
    private @Length(max=400) String observacao;
    @ManyToOne
    @JoinColumn(name="IDJOB", referencedColumnName="JOB_EXECUTION_ID")
    private BatchJobExecution batchJobExecution;
    @OneToOne(mappedBy="pagamentoLote")
    private LoteIntegracaoContabil loteIntegracaoContabil;
    private Boolean loteManual;
    private Boolean arquivoRetorno;
    private Long numeroBaixas;

    public void verificaSituacaoLote() {
        if (SituacaoPagamentoLote.FECHADO.equals((Object)this.getSituacao())) {
            throw new EloValidationException("Lote n\u00e3o est\u00e1 em aberto");
        }
    }

    public void verificaTipoDeArquivoRetorno() {
        if (!this.tipoArquivo.permiteBaixa().booleanValue()) {
            throw new EloValidationException("Baixa deste tipo de arquivo ainda n\u00e3o foi implementado.");
        }
    }

    public boolean getPodeIntegrarLotePagamento() {
        if (Objects.nonNull(this.getContaBancaria())) {
            return Boolean.TRUE.equals(this.getContaBancaria().getIntegraArrecadacao()) && SituacaoPagamentoLote.FECHADO.equals((Object)this.getSituacao());
        }
        return false;
    }

    @Generated
    public PagamentoLote() {
    }

    @Generated
    public PagamentoLoteId getId() {
        return this.id;
    }

    @Generated
    public LocalDate getDataLote() {
        return this.dataLote;
    }

    @Generated
    public LocalDate getDataMovimento() {
        return this.dataMovimento;
    }

    @Generated
    public LocalDate getDataCredito() {
        return this.dataCredito;
    }

    @Generated
    public Convenio getConvenio() {
        return this.convenio;
    }

    @Generated
    public ContaBancaria getContaBancaria() {
        return this.contaBancaria;
    }

    @Generated
    public Banco getBanco() {
        return this.banco;
    }

    @Generated
    public TipoPagamentoLote getTipo() {
        return this.tipo;
    }

    @Generated
    public SituacaoPagamentoLote getSituacao() {
        return this.situacao;
    }

    @Generated
    public Long getNumeroLote() {
        return this.numeroLote;
    }

    @Generated
    public String getArquivoHash() {
        return this.arquivoHash;
    }

    @Generated
    public String getNomeArquivo() {
        return this.nomeArquivo;
    }

    @Generated
    public TipoArquivoRetornoPagamento getTipoArquivo() {
        return this.tipoArquivo;
    }

    @Generated
    public String getObservacao() {
        return this.observacao;
    }

    @Generated
    public BatchJobExecution getBatchJobExecution() {
        return this.batchJobExecution;
    }

    @Generated
    public LoteIntegracaoContabil getLoteIntegracaoContabil() {
        return this.loteIntegracaoContabil;
    }

    @Generated
    public Boolean getLoteManual() {
        return this.loteManual;
    }

    @Generated
    public Boolean getArquivoRetorno() {
        return this.arquivoRetorno;
    }

    @Generated
    public Long getNumeroBaixas() {
        return this.numeroBaixas;
    }

    @Generated
    public void setId(PagamentoLoteId id) {
        this.id = id;
    }

    @Generated
    public void setDataLote(LocalDate dataLote) {
        this.dataLote = dataLote;
    }

    @Generated
    public void setDataMovimento(LocalDate dataMovimento) {
        this.dataMovimento = dataMovimento;
    }

    @Generated
    public void setDataCredito(LocalDate dataCredito) {
        this.dataCredito = dataCredito;
    }

    @Generated
    public void setConvenio(Convenio convenio) {
        this.convenio = convenio;
    }

    @Generated
    public void setContaBancaria(ContaBancaria contaBancaria) {
        this.contaBancaria = contaBancaria;
    }

    @Generated
    public void setBanco(Banco banco) {
        this.banco = banco;
    }

    @Generated
    public void setTipo(TipoPagamentoLote tipo) {
        this.tipo = tipo;
    }

    @Generated
    public void setSituacao(SituacaoPagamentoLote situacao) {
        this.situacao = situacao;
    }

    @Generated
    public void setNumeroLote(Long numeroLote) {
        this.numeroLote = numeroLote;
    }

    @Generated
    public void setArquivoHash(String arquivoHash) {
        this.arquivoHash = arquivoHash;
    }

    @Generated
    public void setNomeArquivo(String nomeArquivo) {
        this.nomeArquivo = nomeArquivo;
    }

    @Generated
    public void setTipoArquivo(TipoArquivoRetornoPagamento tipoArquivo) {
        this.tipoArquivo = tipoArquivo;
    }

    @Generated
    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Generated
    public void setBatchJobExecution(BatchJobExecution batchJobExecution) {
        this.batchJobExecution = batchJobExecution;
    }

    @Generated
    public void setLoteIntegracaoContabil(LoteIntegracaoContabil loteIntegracaoContabil) {
        this.loteIntegracaoContabil = loteIntegracaoContabil;
    }

    @Generated
    public void setLoteManual(Boolean loteManual) {
        this.loteManual = loteManual;
    }

    @Generated
    public void setArquivoRetorno(Boolean arquivoRetorno) {
        this.arquivoRetorno = arquivoRetorno;
    }

    @Generated
    public void setNumeroBaixas(Long numeroBaixas) {
        this.numeroBaixas = numeroBaixas;
    }

    @Generated
    public String toString() {
        return "PagamentoLote(id=" + this.getId() + ", dataLote=" + this.getDataLote() + ", dataMovimento=" + this.getDataMovimento() + ", dataCredito=" + this.getDataCredito() + ", convenio=" + this.getConvenio() + ", contaBancaria=" + this.getContaBancaria() + ", banco=" + this.getBanco() + ", tipo=" + this.getTipo() + ", situacao=" + this.getSituacao() + ", numeroLote=" + this.getNumeroLote() + ", arquivoHash=" + this.getArquivoHash() + ", nomeArquivo=" + this.getNomeArquivo() + ", tipoArquivo=" + this.getTipoArquivo() + ", observacao=" + this.getObservacao() + ", batchJobExecution=" + this.getBatchJobExecution() + ", loteIntegracaoContabil=" + this.getLoteIntegracaoContabil() + ", loteManual=" + this.getLoteManual() + ", arquivoRetorno=" + this.getArquivoRetorno() + ", numeroBaixas=" + this.getNumeroBaixas() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PagamentoLote)) {
            return false;
        }
        PagamentoLote other = (PagamentoLote)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        PagamentoLoteId this$id = this.getId();
        PagamentoLoteId other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PagamentoLote;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PagamentoLoteId $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }
}

