/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.integracoes;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.tributos.enums.IntegracaoTokenOperation;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.Table;
import lombok.Generated;

@Entity
@Table(name="tribintegracaotoken")
public class IntegracaoToken
implements EloEntity<Long> {
    @Id
    @EloSequence
    @Column(name="id")
    private Long id;
    @Column(name="banco")
    private Long banco;
    @Column(name="operation")
    @Enumerated(value=EnumType.STRING)
    private IntegracaoTokenOperation operation;
    @Column(name="valor")
    private String valor;
    @Column(name="expiracao")
    private LocalDateTime expiracao;

    public boolean isValid() {
        LocalDateTime now = LocalDateTime.now();
        return now.isBefore(this.expiracao);
    }

    public void setExpiracao(String milliseconds) {
        this.expiracao = Instant.ofEpochSecond(Long.parseLong(milliseconds)).atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public void setExpiracao(LocalDateTime localDateTime) {
        this.expiracao = localDateTime;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getBanco() {
        return this.banco;
    }

    @Generated
    public IntegracaoTokenOperation getOperation() {
        return this.operation;
    }

    @Generated
    public String getValor() {
        return this.valor;
    }

    @Generated
    public LocalDateTime getExpiracao() {
        return this.expiracao;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setBanco(Long banco) {
        this.banco = banco;
    }

    @Generated
    public void setOperation(IntegracaoTokenOperation operation) {
        this.operation = operation;
    }

    @Generated
    public void setValor(String valor) {
        this.valor = valor;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IntegracaoToken)) {
            return false;
        }
        IntegracaoToken other = (IntegracaoToken)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$banco = this.getBanco();
        Long other$banco = other.getBanco();
        if (this$banco == null ? other$banco != null : !((Object)this$banco).equals(other$banco)) {
            return false;
        }
        IntegracaoTokenOperation this$operation = this.getOperation();
        IntegracaoTokenOperation other$operation = other.getOperation();
        if (this$operation == null ? other$operation != null : !this$operation.equals(other$operation)) {
            return false;
        }
        String this$valor = this.getValor();
        String other$valor = other.getValor();
        if (this$valor == null ? other$valor != null : !this$valor.equals(other$valor)) {
            return false;
        }
        LocalDateTime this$expiracao = this.getExpiracao();
        LocalDateTime other$expiracao = other.getExpiracao();
        return !(this$expiracao == null ? other$expiracao != null : !((Object)this$expiracao).equals(other$expiracao));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof IntegracaoToken;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $banco = this.getBanco();
        result = result * 59 + ($banco == null ? 43 : ((Object)$banco).hashCode());
        IntegracaoTokenOperation $operation = this.getOperation();
        result = result * 59 + ($operation == null ? 43 : $operation.hashCode());
        String $valor = this.getValor();
        result = result * 59 + ($valor == null ? 43 : $valor.hashCode());
        LocalDateTime $expiracao = this.getExpiracao();
        result = result * 59 + ($expiracao == null ? 43 : ((Object)$expiracao).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "IntegracaoToken(id=" + this.getId() + ", banco=" + this.getBanco() + ", operation=" + this.getOperation() + ", valor=" + this.getValor() + ", expiracao=" + this.getExpiracao() + ")";
    }

    @Generated
    public IntegracaoToken(Long id, Long banco, IntegracaoTokenOperation operation, String valor, LocalDateTime expiracao) {
        this.id = id;
        this.banco = banco;
        this.operation = operation;
        this.valor = valor;
        this.expiracao = expiracao;
    }

    @Generated
    public IntegracaoToken() {
    }
}

