/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.tributos.domain.ContaBancaria;
import br.com.elotech.tributos.domain.Convenio;
import br.com.elotech.tributos.domain.Pagamento;
import br.com.elotech.tributos.domain.PagamentoNegociadoDebNovo;
import br.com.elotech.tributos.domain.PagamentoNegociadoDebOrigem;
import br.com.elotech.tributos.domain.SituacaoPagNegociadoNovo;
import br.com.elotech.tributos.dto.PagamentoNegociadoDTO;
import br.com.elotech.tributos.dto.PagamentoNegociadoDebitoDTO;
import br.com.elotech.tributos.dto.PagamentoNegociadoSituacaoEnum;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import lombok.Generated;

@Entity
@Table(name="TRIBPGTONEGOCIADO")
public class PagamentoNegociado
implements EloEntity<Long>,
Serializable {
    @Id
    @Column(name="pgtonegociado")
    @EloSequence(applyOnMerge=true, sequenceName="s05pgtonegociado")
    private Long id;
    private String observacao;
    private BigDecimal valorNegociado = BigDecimal.ZERO;
    @ManyToOne
    @JoinColumn(name="contaBancaria", referencedColumnName="id")
    private ContaBancaria contaBancaria;
    private LocalDate dataCredito;
    private PagamentoNegociadoSituacaoEnum cancelado;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="entidadePagamentoGerado", referencedColumnName="entidade"), @JoinColumn(name="exercicioPagamentoGerado", referencedColumnName="exercicioPagamento"), @JoinColumn(name="pagamentoGerado", referencedColumnName="pagamento")})
    private Pagamento pagamentoGerado;
    private String cadastroGeralfiltro;
    private String tipoCadastrofiltro;
    private String exercicioFiltro;
    private String guiaRecolhimentoFiltro;
    private String subDividaFiltro;
    private String parcelaFiltro;
    private String creditoFiltro;
    private Long cda;
    private Long exercicioCDA;
    private Long situacaoLegal;
    private Long motivoDesconto;
    private LocalDate dataReferencia;
    private LocalDate venctoInicial;
    private LocalDate venctoFinal;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="convenio", referencedColumnName="convenio")
    private Convenio convenio;
    private LocalDate dataNegociacao;
    private String usuario;
    private String usuarioCancelamento;
    private LocalDate dataCancelamento;
    private String motivoCancelamento;
    private BigDecimal valorDebitoBaixado;
    private BigDecimal valorDebitoNovo;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="pagamentoNegociado", orphanRemoval=true)
    private List<PagamentoNegociadoDebOrigem> debitosOrigem = new ArrayList();
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="pgtonegociado", referencedColumnName="pgtonegociado")
    private List<PagamentoNegociadoDebNovo> debitosNovos = new ArrayList();

    public PagamentoNegociadoDTO to() {
        PagamentoNegociadoDTO dto = new PagamentoNegociadoDTO();
        Optional.ofNullable(this.id).ifPresent(arg_0 -> ((PagamentoNegociadoDTO)dto).setId(arg_0));
        Optional.ofNullable(this.dataNegociacao).ifPresent(arg_0 -> ((PagamentoNegociadoDTO)dto).setDataNegociacao(arg_0));
        Optional.ofNullable(this.cadastroGeralfiltro).ifPresent(arg_0 -> ((PagamentoNegociadoDTO)dto).setCadastroGeral(arg_0));
        Optional.ofNullable(this.tipoCadastrofiltro).ifPresent(arg_0 -> ((PagamentoNegociadoDTO)dto).setTipoCadastro(arg_0));
        Optional.ofNullable(this.valorNegociado).ifPresent(arg_0 -> ((PagamentoNegociadoDTO)dto).setValorNegociacao(arg_0));
        Optional.ofNullable(this.observacao).ifPresent(arg_0 -> ((PagamentoNegociadoDTO)dto).setObservacao(arg_0));
        Optional.ofNullable(this.cancelado).map(PagamentoNegociadoSituacaoEnum::getDescricao).ifPresent(arg_0 -> ((PagamentoNegociadoDTO)dto).setSituacao(arg_0));
        List debitosOrigem = this.debitosOrigem.stream().map(PagamentoNegociadoDebitoDTO::fromOrigem).collect(Collectors.toList());
        ArrayList<PagamentoNegociadoDebitoDTO> debitosNovos = new ArrayList<PagamentoNegociadoDebitoDTO>();
        if (this.debitosNovos.size() > 0) {
            PagamentoNegociadoDebNovo debitoAberto = this.debitosNovos.stream().filter(element -> SituacaoPagNegociadoNovo.ABERTO.equals((Object)element.getSituacao())).findFirst().get();
            debitosNovos.add(PagamentoNegociadoDebitoDTO.from((PagamentoNegociadoDebNovo)debitoAberto));
        }
        dto.setDebitosOrigem(debitosOrigem);
        dto.setDebitosNovos(debitosNovos);
        return dto;
    }

    @Generated
    public PagamentoNegociado() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getObservacao() {
        return this.observacao;
    }

    @Generated
    public BigDecimal getValorNegociado() {
        return this.valorNegociado;
    }

    @Generated
    public ContaBancaria getContaBancaria() {
        return this.contaBancaria;
    }

    @Generated
    public LocalDate getDataCredito() {
        return this.dataCredito;
    }

    @Generated
    public PagamentoNegociadoSituacaoEnum getCancelado() {
        return this.cancelado;
    }

    @Generated
    public Pagamento getPagamentoGerado() {
        return this.pagamentoGerado;
    }

    @Generated
    public String getCadastroGeralfiltro() {
        return this.cadastroGeralfiltro;
    }

    @Generated
    public String getTipoCadastrofiltro() {
        return this.tipoCadastrofiltro;
    }

    @Generated
    public String getExercicioFiltro() {
        return this.exercicioFiltro;
    }

    @Generated
    public String getGuiaRecolhimentoFiltro() {
        return this.guiaRecolhimentoFiltro;
    }

    @Generated
    public String getSubDividaFiltro() {
        return this.subDividaFiltro;
    }

    @Generated
    public String getParcelaFiltro() {
        return this.parcelaFiltro;
    }

    @Generated
    public String getCreditoFiltro() {
        return this.creditoFiltro;
    }

    @Generated
    public Long getCda() {
        return this.cda;
    }

    @Generated
    public Long getExercicioCDA() {
        return this.exercicioCDA;
    }

    @Generated
    public Long getSituacaoLegal() {
        return this.situacaoLegal;
    }

    @Generated
    public Long getMotivoDesconto() {
        return this.motivoDesconto;
    }

    @Generated
    public LocalDate getDataReferencia() {
        return this.dataReferencia;
    }

    @Generated
    public LocalDate getVenctoInicial() {
        return this.venctoInicial;
    }

    @Generated
    public LocalDate getVenctoFinal() {
        return this.venctoFinal;
    }

    @Generated
    public Convenio getConvenio() {
        return this.convenio;
    }

    @Generated
    public LocalDate getDataNegociacao() {
        return this.dataNegociacao;
    }

    @Generated
    public String getUsuario() {
        return this.usuario;
    }

    @Generated
    public String getUsuarioCancelamento() {
        return this.usuarioCancelamento;
    }

    @Generated
    public LocalDate getDataCancelamento() {
        return this.dataCancelamento;
    }

    @Generated
    public String getMotivoCancelamento() {
        return this.motivoCancelamento;
    }

    @Generated
    public BigDecimal getValorDebitoBaixado() {
        return this.valorDebitoBaixado;
    }

    @Generated
    public BigDecimal getValorDebitoNovo() {
        return this.valorDebitoNovo;
    }

    @Generated
    public List<PagamentoNegociadoDebOrigem> getDebitosOrigem() {
        return this.debitosOrigem;
    }

    @Generated
    public List<PagamentoNegociadoDebNovo> getDebitosNovos() {
        return this.debitosNovos;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Generated
    public void setValorNegociado(BigDecimal valorNegociado) {
        this.valorNegociado = valorNegociado;
    }

    @Generated
    public void setContaBancaria(ContaBancaria contaBancaria) {
        this.contaBancaria = contaBancaria;
    }

    @Generated
    public void setDataCredito(LocalDate dataCredito) {
        this.dataCredito = dataCredito;
    }

    @Generated
    public void setCancelado(PagamentoNegociadoSituacaoEnum cancelado) {
        this.cancelado = cancelado;
    }

    @Generated
    public void setPagamentoGerado(Pagamento pagamentoGerado) {
        this.pagamentoGerado = pagamentoGerado;
    }

    @Generated
    public void setCadastroGeralfiltro(String cadastroGeralfiltro) {
        this.cadastroGeralfiltro = cadastroGeralfiltro;
    }

    @Generated
    public void setTipoCadastrofiltro(String tipoCadastrofiltro) {
        this.tipoCadastrofiltro = tipoCadastrofiltro;
    }

    @Generated
    public void setExercicioFiltro(String exercicioFiltro) {
        this.exercicioFiltro = exercicioFiltro;
    }

    @Generated
    public void setGuiaRecolhimentoFiltro(String guiaRecolhimentoFiltro) {
        this.guiaRecolhimentoFiltro = guiaRecolhimentoFiltro;
    }

    @Generated
    public void setSubDividaFiltro(String subDividaFiltro) {
        this.subDividaFiltro = subDividaFiltro;
    }

    @Generated
    public void setParcelaFiltro(String parcelaFiltro) {
        this.parcelaFiltro = parcelaFiltro;
    }

    @Generated
    public void setCreditoFiltro(String creditoFiltro) {
        this.creditoFiltro = creditoFiltro;
    }

    @Generated
    public void setCda(Long cda) {
        this.cda = cda;
    }

    @Generated
    public void setExercicioCDA(Long exercicioCDA) {
        this.exercicioCDA = exercicioCDA;
    }

    @Generated
    public void setSituacaoLegal(Long situacaoLegal) {
        this.situacaoLegal = situacaoLegal;
    }

    @Generated
    public void setMotivoDesconto(Long motivoDesconto) {
        this.motivoDesconto = motivoDesconto;
    }

    @Generated
    public void setDataReferencia(LocalDate dataReferencia) {
        this.dataReferencia = dataReferencia;
    }

    @Generated
    public void setVenctoInicial(LocalDate venctoInicial) {
        this.venctoInicial = venctoInicial;
    }

    @Generated
    public void setVenctoFinal(LocalDate venctoFinal) {
        this.venctoFinal = venctoFinal;
    }

    @Generated
    public void setConvenio(Convenio convenio) {
        this.convenio = convenio;
    }

    @Generated
    public void setDataNegociacao(LocalDate dataNegociacao) {
        this.dataNegociacao = dataNegociacao;
    }

    @Generated
    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    @Generated
    public void setUsuarioCancelamento(String usuarioCancelamento) {
        this.usuarioCancelamento = usuarioCancelamento;
    }

    @Generated
    public void setDataCancelamento(LocalDate dataCancelamento) {
        this.dataCancelamento = dataCancelamento;
    }

    @Generated
    public void setMotivoCancelamento(String motivoCancelamento) {
        this.motivoCancelamento = motivoCancelamento;
    }

    @Generated
    public void setValorDebitoBaixado(BigDecimal valorDebitoBaixado) {
        this.valorDebitoBaixado = valorDebitoBaixado;
    }

    @Generated
    public void setValorDebitoNovo(BigDecimal valorDebitoNovo) {
        this.valorDebitoNovo = valorDebitoNovo;
    }

    @Generated
    public void setDebitosOrigem(List<PagamentoNegociadoDebOrigem> debitosOrigem) {
        this.debitosOrigem = debitosOrigem;
    }

    @Generated
    public void setDebitosNovos(List<PagamentoNegociadoDebNovo> debitosNovos) {
        this.debitosNovos = debitosNovos;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PagamentoNegociado)) {
            return false;
        }
        PagamentoNegociado other = (PagamentoNegociado)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PagamentoNegociado;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PagamentoNegociado(id=" + this.getId() + ")";
    }
}

