/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.BoletoDebitoID;
import br.com.elotech.tributos.domain.DebitoParcelaTributo;
import br.com.elotech.tributos.dto.AgrupamentoTributosDTO;
import br.com.elotech.tributos.dto.DebitoEmAbertoDTO;
import br.com.elotech.tributos.dto.DebitoPagamentoNegociadoDTO;
import br.com.elotech.tributos.dto.boleto.BoletoEspecialDebitoDTO;
import java.io.Serializable;
import java.math.BigDecimal;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import lombok.Generated;

@Entity
@Table(name="tribbloquetodebito")
public class BoletoDebito
implements EloEntity<BoletoDebitoID>,
Serializable {
    @EmbeddedId
    private BoletoDebitoID id;
    private BigDecimal valorPrincipal = BigDecimal.ZERO;
    private BigDecimal valorJuros = BigDecimal.ZERO;
    private BigDecimal valorMulta = BigDecimal.ZERO;
    private BigDecimal valorCorrecao = BigDecimal.ZERO;
    private BigDecimal valorDesconto = BigDecimal.ZERO;
    private BigDecimal valorAtualizacao = BigDecimal.ZERO;
    private BigDecimal valorDescontoPrincipal = BigDecimal.ZERO;
    private BigDecimal valorDescontoJuros = BigDecimal.ZERO;
    private BigDecimal valorDescontoMulta = BigDecimal.ZERO;
    private BigDecimal valorDescontoCorrecao = BigDecimal.ZERO;
    @Transient
    private BigDecimal valorPrincipalAcrescimo = BigDecimal.ZERO;
    @Transient
    private BigDecimal valorJurosAcrescimo = BigDecimal.ZERO;
    @Transient
    private BigDecimal valorMultaAcrescimo = BigDecimal.ZERO;
    @Transient
    private BigDecimal valorCorrecaoAcrescimo = BigDecimal.ZERO;

    public static BoletoDebito of(Bloqueto boleto, DebitoParcelaTributo debitoParcelaTributo, DebitoEmAbertoDTO debitoBoletoDTO) {
        BoletoDebitoID boletoDebitoID = new BoletoDebitoID();
        boletoDebitoID.setDebitoParcelaTributo(debitoParcelaTributo);
        boletoDebitoID.setEntidade(boleto.getEntidade());
        boletoDebitoID.setExercicioBoleto(boleto.getExercicioBloqueto());
        boletoDebitoID.setBoleto(boleto.getBloqueto());
        BoletoDebito boletoDebito = new BoletoDebito();
        boletoDebito.setId(boletoDebitoID);
        boletoDebito.setValorPrincipal(debitoBoletoDTO.getValorPrincipal());
        boletoDebito.setValorJuros(debitoBoletoDTO.getValorJuros());
        boletoDebito.setValorMulta(debitoBoletoDTO.getValorMulta());
        boletoDebito.setValorCorrecao(debitoBoletoDTO.getValorCorrecao());
        boletoDebito.setValorDescontoPrincipal(debitoBoletoDTO.getValorDescontoPrincipal());
        boletoDebito.setValorDescontoJuros(debitoBoletoDTO.getValorDescontoJuros());
        boletoDebito.setValorDescontoMulta(debitoBoletoDTO.getValorDescontoMulta());
        boletoDebito.setValorDescontoCorrecao(debitoBoletoDTO.getValorDescontoCorrecao());
        boletoDebito.setValorDesconto(debitoBoletoDTO.getValorTotalDesconto());
        return boletoDebito;
    }

    public static BoletoDebito of(Bloqueto boleto, BoletoEspecialDebitoDTO debitoBoletoDTO) {
        DebitoParcelaTributo debitoParcelaTributo = new DebitoParcelaTributo();
        debitoParcelaTributo.setId(debitoBoletoDTO.getIdDebitoParcelaReceita());
        BoletoDebitoID boletoDebitoID = new BoletoDebitoID();
        boletoDebitoID.setBoleto(boleto.getBloqueto());
        boletoDebitoID.setEntidade(boleto.getEntidade());
        boletoDebitoID.setExercicioBoleto(boleto.getExercicioBloqueto());
        boletoDebitoID.setDebitoParcelaTributo(debitoParcelaTributo);
        BoletoDebito boletoDebito = new BoletoDebito();
        boletoDebito.setId(boletoDebitoID);
        boletoDebito.setValorPrincipal(debitoBoletoDTO.getValorPrincipal());
        boletoDebito.setValorJuros(debitoBoletoDTO.getValorJuros());
        boletoDebito.setValorMulta(debitoBoletoDTO.getValorMulta());
        boletoDebito.setValorDescontoPrincipal(debitoBoletoDTO.getValorDescontoPrincipal());
        boletoDebito.setValorCorrecao(debitoBoletoDTO.getValorCorrecao());
        boletoDebito.setValorDescontoJuros(debitoBoletoDTO.getValorDescontoJuros());
        boletoDebito.setValorDescontoMulta(debitoBoletoDTO.getValorDescontoMulta());
        boletoDebito.setValorDesconto(debitoBoletoDTO.getValorDescontos());
        boletoDebito.setValorDescontoCorrecao(debitoBoletoDTO.getValorDescontoCorrecao());
        return boletoDebito;
    }

    public static BoletoDebito of(Bloqueto boleto, DebitoPagamentoNegociadoDTO debito) {
        DebitoParcelaTributo debitoParcelaTributo = new DebitoParcelaTributo();
        debitoParcelaTributo.setId(debito.getIdDebitoParcelaReceita());
        BoletoDebitoID boletoDebitoID = new BoletoDebitoID();
        boletoDebitoID.setBoleto(boleto.getBloqueto());
        boletoDebitoID.setEntidade(boleto.getEntidade());
        boletoDebitoID.setExercicioBoleto(boleto.getExercicioBloqueto());
        boletoDebitoID.setDebitoParcelaTributo(debitoParcelaTributo);
        BoletoDebito boletoDebito = new BoletoDebito();
        boletoDebito.setId(boletoDebitoID);
        boletoDebito.setValorPrincipal(debito.getValorPrincipal());
        boletoDebito.setValorJuros(debito.getValorJuros());
        boletoDebito.setValorMulta(debito.getValorMulta());
        boletoDebito.setValorDescontoPrincipal(debito.getValorDescontoPrincipal());
        boletoDebito.setValorCorrecao(debito.getValorCorrecao());
        boletoDebito.setValorDescontoJuros(debito.getValorDescontoJuros());
        boletoDebito.setValorDescontoMulta(debito.getValorDescontoMulta());
        boletoDebito.setValorDesconto(debito.getValorDescontos());
        boletoDebito.setValorDescontoCorrecao(debito.getValorDescontoCorrecao());
        return boletoDebito;
    }

    public static BoletoDebito of(Bloqueto boleto, AgrupamentoTributosDTO tributosDTO) {
        DebitoParcelaTributo debitoParcelaTributo = new DebitoParcelaTributo();
        debitoParcelaTributo.setId(tributosDTO.getIdDebitoParcelaTributo());
        BoletoDebitoID boletoDebitoID = new BoletoDebitoID();
        boletoDebitoID.setBoleto(boleto.getBloqueto());
        boletoDebitoID.setEntidade(boleto.getEntidade());
        boletoDebitoID.setExercicioBoleto(boleto.getExercicioBloqueto());
        boletoDebitoID.setDebitoParcelaTributo(debitoParcelaTributo);
        BoletoDebito boletoDebito = new BoletoDebito();
        boletoDebito.setId(boletoDebitoID);
        boletoDebito.setValorPrincipal(tributosDTO.getValorPrincipal());
        boletoDebito.setValorJuros(tributosDTO.getValorJuros());
        boletoDebito.setValorMulta(tributosDTO.getValorMulta());
        boletoDebito.setValorDescontoPrincipal(tributosDTO.getValorDescontoPrincipal());
        boletoDebito.setValorCorrecao(tributosDTO.getValorCorrecao());
        boletoDebito.setValorDescontoJuros(tributosDTO.getValorDescontoJuros());
        boletoDebito.setValorDescontoMulta(tributosDTO.getValorDescontoMulta());
        boletoDebito.setValorDesconto(tributosDTO.getValorDescontoJuros().add(tributosDTO.getValorDescontoMulta()).add(tributosDTO.getValorDescontoCorrecao()));
        boletoDebito.setValorDescontoCorrecao(tributosDTO.getValorDescontoCorrecao());
        return boletoDebito;
    }

    public BoletoDebito add(BoletoDebito boletoDebito) {
        this.valorPrincipal = this.valorPrincipal.add(boletoDebito.getValorPrincipal());
        this.valorJuros = this.valorJuros.add(boletoDebito.getValorJuros());
        this.valorMulta = this.valorMulta.add(boletoDebito.getValorMulta());
        this.valorCorrecao = this.valorCorrecao.add(boletoDebito.getValorCorrecao());
        this.valorDescontoPrincipal = this.valorDescontoPrincipal.add(boletoDebito.getValorDescontoPrincipal());
        this.valorDescontoJuros = this.valorDescontoJuros.add(boletoDebito.getValorDescontoJuros());
        this.valorDescontoMulta = this.valorDescontoMulta.add(boletoDebito.getValorDescontoMulta());
        this.valorDescontoCorrecao = this.valorDescontoCorrecao.add(boletoDebito.getValorDescontoCorrecao());
        this.valorPrincipalAcrescimo = this.valorPrincipalAcrescimo.add(boletoDebito.getValorPrincipalAcrescimo());
        this.valorJurosAcrescimo = this.valorJurosAcrescimo.add(boletoDebito.getValorJurosAcrescimo());
        this.valorMultaAcrescimo = this.valorMultaAcrescimo.add(boletoDebito.getValorMultaAcrescimo());
        this.valorCorrecaoAcrescimo = this.valorCorrecaoAcrescimo.add(boletoDebito.getValorCorrecaoAcrescimo());
        return this;
    }

    public BigDecimal getValorTotalDesconto() {
        return this.getValorDescontoPrincipal().add(this.getValorDescontoJuros()).add(this.getValorDescontoMulta()).add(this.getValorDescontoCorrecao());
    }

    public BigDecimal getValorTotal() {
        return this.getValorPrincipal().add(this.getValorCorrecao()).add(this.getValorJuros()).add(this.getValorMulta()).subtract(this.getValorTotalDesconto());
    }

    public BigDecimal getValorTotalComAcrescimos() {
        return this.getValorPrincipalAcrescimo().add(this.getValorCorrecaoAcrescimo()).add(this.getValorJurosAcrescimo()).add(this.getValorMultaAcrescimo()).subtract(this.getValorTotalDesconto());
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BoletoDebito)) {
            return false;
        }
        BoletoDebito other = (BoletoDebito)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        BoletoDebitoID this$id = this.getId();
        BoletoDebitoID other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BoletoDebito;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BoletoDebitoID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    @Generated
    public BoletoDebitoID getId() {
        return this.id;
    }

    @Generated
    public BigDecimal getValorPrincipal() {
        return this.valorPrincipal;
    }

    @Generated
    public BigDecimal getValorJuros() {
        return this.valorJuros;
    }

    @Generated
    public BigDecimal getValorMulta() {
        return this.valorMulta;
    }

    @Generated
    public BigDecimal getValorCorrecao() {
        return this.valorCorrecao;
    }

    @Generated
    public BigDecimal getValorDesconto() {
        return this.valorDesconto;
    }

    @Generated
    public BigDecimal getValorAtualizacao() {
        return this.valorAtualizacao;
    }

    @Generated
    public BigDecimal getValorDescontoPrincipal() {
        return this.valorDescontoPrincipal;
    }

    @Generated
    public BigDecimal getValorDescontoJuros() {
        return this.valorDescontoJuros;
    }

    @Generated
    public BigDecimal getValorDescontoMulta() {
        return this.valorDescontoMulta;
    }

    @Generated
    public BigDecimal getValorDescontoCorrecao() {
        return this.valorDescontoCorrecao;
    }

    @Generated
    public BigDecimal getValorPrincipalAcrescimo() {
        return this.valorPrincipalAcrescimo;
    }

    @Generated
    public BigDecimal getValorJurosAcrescimo() {
        return this.valorJurosAcrescimo;
    }

    @Generated
    public BigDecimal getValorMultaAcrescimo() {
        return this.valorMultaAcrescimo;
    }

    @Generated
    public BigDecimal getValorCorrecaoAcrescimo() {
        return this.valorCorrecaoAcrescimo;
    }

    @Generated
    public void setId(BoletoDebitoID id) {
        this.id = id;
    }

    @Generated
    public void setValorPrincipal(BigDecimal valorPrincipal) {
        this.valorPrincipal = valorPrincipal;
    }

    @Generated
    public void setValorJuros(BigDecimal valorJuros) {
        this.valorJuros = valorJuros;
    }

    @Generated
    public void setValorMulta(BigDecimal valorMulta) {
        this.valorMulta = valorMulta;
    }

    @Generated
    public void setValorCorrecao(BigDecimal valorCorrecao) {
        this.valorCorrecao = valorCorrecao;
    }

    @Generated
    public void setValorDesconto(BigDecimal valorDesconto) {
        this.valorDesconto = valorDesconto;
    }

    @Generated
    public void setValorAtualizacao(BigDecimal valorAtualizacao) {
        this.valorAtualizacao = valorAtualizacao;
    }

    @Generated
    public void setValorDescontoPrincipal(BigDecimal valorDescontoPrincipal) {
        this.valorDescontoPrincipal = valorDescontoPrincipal;
    }

    @Generated
    public void setValorDescontoJuros(BigDecimal valorDescontoJuros) {
        this.valorDescontoJuros = valorDescontoJuros;
    }

    @Generated
    public void setValorDescontoMulta(BigDecimal valorDescontoMulta) {
        this.valorDescontoMulta = valorDescontoMulta;
    }

    @Generated
    public void setValorDescontoCorrecao(BigDecimal valorDescontoCorrecao) {
        this.valorDescontoCorrecao = valorDescontoCorrecao;
    }

    @Generated
    public void setValorPrincipalAcrescimo(BigDecimal valorPrincipalAcrescimo) {
        this.valorPrincipalAcrescimo = valorPrincipalAcrescimo;
    }

    @Generated
    public void setValorJurosAcrescimo(BigDecimal valorJurosAcrescimo) {
        this.valorJurosAcrescimo = valorJurosAcrescimo;
    }

    @Generated
    public void setValorMultaAcrescimo(BigDecimal valorMultaAcrescimo) {
        this.valorMultaAcrescimo = valorMultaAcrescimo;
    }

    @Generated
    public void setValorCorrecaoAcrescimo(BigDecimal valorCorrecaoAcrescimo) {
        this.valorCorrecaoAcrescimo = valorCorrecaoAcrescimo;
    }
}

