/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.calculo.resource;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.resource.support.CrudResource;
import br.com.elotech.tributos.calculo.domain.CalculoCadastro;
import br.com.elotech.tributos.calculo.dto.AuxiliaresCalculoDTO;
import br.com.elotech.tributos.calculo.dto.ParametroTesteScriptDTO;
import br.com.elotech.tributos.calculo.service.CalculoAvaliacaoExecucaoService;
import br.com.elotech.tributos.calculo.service.CalculoTributoService;
import br.com.elotech.tributos.domain.TipoDivida;
import br.com.elotech.tributos.domain.calculo.CalculoAvaliacao;
import br.com.elotech.tributos.domain.calculo.TipoCalculoConfig;
import br.com.elotech.tributos.domain.camposdinamicos.Campo;
import java.util.List;
import lombok.Generated;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/calculo-avaliacao"})
public class CalculoAvaliacaoResource
extends CrudResource<CalculoAvaliacao, Long> {
    private final CalculoAvaliacaoExecucaoService calculoAvaliacaoExecucaoService;
    private final CalculoTributoService calculoTributoService;

    @PostMapping(value={"/teste-script"})
    public ResponseEntity<CalculoCadastro> testarScript(@RequestBody ParametroTesteScriptDTO parametroCalculoDTO) {
        return ResponseEntity.ok((Object)this.calculoAvaliacaoExecucaoService.testarScript(parametroCalculoDTO).stream().findFirst().map(CalculoCadastro::fromAvaliacao).orElseThrow(() -> new EloValidationException("N\u00e3o foi poss\u00edvel fazer o teste do script de avalia\u00e7\u00e3o.")));
    }

    @GetMapping(value={"/auxiliares"})
    public ResponseEntity<AuxiliaresCalculoDTO> getAuxiliares(@RequestParam Long exercicio) {
        return ResponseEntity.ok((Object)this.calculoTributoService.getAuxiliares(exercicio, TipoDivida.IPTU));
    }

    @GetMapping(value={"/campos-dinamicos-calculo"})
    public ResponseEntity<List<Campo>> getCamposDinamicosCalculo(@RequestParam String search, @RequestParam String tipoCalculoTributo) {
        return ResponseEntity.ok((Object)this.calculoTributoService.getCamposDinamicosCalculo(search, TipoDivida.IPTU, TipoCalculoConfig.fromValue((String)tipoCalculoTributo)));
    }

    @Generated
    public CalculoAvaliacaoResource(CalculoAvaliacaoExecucaoService calculoAvaliacaoExecucaoService, CalculoTributoService calculoTributoService) {
        this.calculoAvaliacaoExecucaoService = calculoAvaliacaoExecucaoService;
        this.calculoTributoService = calculoTributoService;
    }
}

