/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.calculo.dto;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.calculo.dto.CalculoContext;
import br.com.elotech.tributos.calculo.dto.CalculoImobiliarioContext;
import br.com.elotech.tributos.calculo.dto.CalculoMobiliarioContext;
import br.com.elotech.tributos.domain.TipoDivida;

public class CalculoContextFactory {
    private CalculoContextFactory() {
    }

    public static CalculoContext getContext(TipoDivida tipoDivida) {
        if (TipoDivida.IPTU.equals((Object)tipoDivida)) {
            return new CalculoImobiliarioContext();
        }
        if (TipoDivida.ISS_FIXO.equals((Object)tipoDivida) || TipoDivida.ALVARA.equals((Object)tipoDivida) || TipoDivida.ISS_HOMOLOGADO.equals((Object)tipoDivida)) {
            return new CalculoMobiliarioContext();
        }
        throw new EloValidationException(String.format("N\u00e3o h\u00e1 implementa\u00e7\u00e3o de c\u00e1lculo para o tipo de d\u00edvida %s.", tipoDivida));
    }
}

