/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.calculo.dto;

import br.com.elotech.tributos.calculo.domain.CalculoCadastro;
import br.com.elotech.tributos.calculo.domain.CalculoInconsistencia;
import br.com.elotech.tributos.calculo.dto.CalculoResultadoResumidoDTO;
import br.com.elotech.tributos.domain.TipoCadastro;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;

public class CalculoCadastroResumidoDTO {
    private Long id;
    private Long idCadastro;
    private TipoCadastro tipoCadastro;
    private Long cadastroGeral;
    private String cpfCnpj;
    private String nome;
    private BigDecimal valorCalculado = BigDecimal.ZERO;
    private BigDecimal valorDeducoes = BigDecimal.ZERO;
    private BigDecimal valorTotal = BigDecimal.ZERO;
    private Long divida;
    private String descricaoDivida;
    private Long idDebito;
    private List<CalculoResultadoResumidoDTO> resultados = new ArrayList();
    private List<CalculoInconsistencia> inconsistencias = new ArrayList();

    public static CalculoCadastroResumidoDTO from(CalculoCadastro calculoCadastro) {
        CalculoCadastroResumidoDTO dto = new CalculoCadastroResumidoDTO();
        dto.id = calculoCadastro.getId();
        dto.idCadastro = calculoCadastro.getCadastro().getId();
        dto.tipoCadastro = calculoCadastro.getCadastro().getTipoCadastro();
        dto.cadastroGeral = calculoCadastro.getCadastro().getCadastroGeral();
        dto.cpfCnpj = calculoCadastro.getCadastro().getPessoa().getCnpjCpf();
        dto.nome = calculoCadastro.getCadastro().getPessoa().getNome();
        dto.setResultados(calculoCadastro.getResultados().stream().map(CalculoResultadoResumidoDTO::from).collect(Collectors.toList()));
        dto.setInconsistencias(calculoCadastro.getInconsistencias());
        dto.setValorCalculado(calculoCadastro.getValorCalculado());
        dto.setValorDeducoes(calculoCadastro.getValorDeducoes());
        dto.setValorTotal(calculoCadastro.getValorTotal());
        dto.setDivida(calculoCadastro.getDivida().getDivida());
        dto.setDescricaoDivida(calculoCadastro.getDivida().getDescricao());
        Optional.ofNullable(calculoCadastro.getDebito()).ifPresent(debito -> dto.setIdDebito(debito.getId()));
        return dto;
    }

    @Generated
    public CalculoCadastroResumidoDTO() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getIdCadastro() {
        return this.idCadastro;
    }

    @Generated
    public TipoCadastro getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public String getCpfCnpj() {
        return this.cpfCnpj;
    }

    @Generated
    public String getNome() {
        return this.nome;
    }

    @Generated
    public BigDecimal getValorCalculado() {
        return this.valorCalculado;
    }

    @Generated
    public BigDecimal getValorDeducoes() {
        return this.valorDeducoes;
    }

    @Generated
    public BigDecimal getValorTotal() {
        return this.valorTotal;
    }

    @Generated
    public Long getDivida() {
        return this.divida;
    }

    @Generated
    public String getDescricaoDivida() {
        return this.descricaoDivida;
    }

    @Generated
    public Long getIdDebito() {
        return this.idDebito;
    }

    @Generated
    public List<CalculoResultadoResumidoDTO> getResultados() {
        return this.resultados;
    }

    @Generated
    public List<CalculoInconsistencia> getInconsistencias() {
        return this.inconsistencias;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setIdCadastro(Long idCadastro) {
        this.idCadastro = idCadastro;
    }

    @Generated
    public void setTipoCadastro(TipoCadastro tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setCpfCnpj(String cpfCnpj) {
        this.cpfCnpj = cpfCnpj;
    }

    @Generated
    public void setNome(String nome) {
        this.nome = nome;
    }

    @Generated
    public void setValorCalculado(BigDecimal valorCalculado) {
        this.valorCalculado = valorCalculado;
    }

    @Generated
    public void setValorDeducoes(BigDecimal valorDeducoes) {
        this.valorDeducoes = valorDeducoes;
    }

    @Generated
    public void setValorTotal(BigDecimal valorTotal) {
        this.valorTotal = valorTotal;
    }

    @Generated
    public void setDivida(Long divida) {
        this.divida = divida;
    }

    @Generated
    public void setDescricaoDivida(String descricaoDivida) {
        this.descricaoDivida = descricaoDivida;
    }

    @Generated
    public void setIdDebito(Long idDebito) {
        this.idDebito = idDebito;
    }

    @Generated
    public void setResultados(List<CalculoResultadoResumidoDTO> resultados) {
        this.resultados = resultados;
    }

    @Generated
    public void setInconsistencias(List<CalculoInconsistencia> inconsistencias) {
        this.inconsistencias = inconsistencias;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CalculoCadastroResumidoDTO)) {
            return false;
        }
        CalculoCadastroResumidoDTO other = (CalculoCadastroResumidoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$idCadastro = this.getIdCadastro();
        Long other$idCadastro = other.getIdCadastro();
        if (this$idCadastro == null ? other$idCadastro != null : !((Object)this$idCadastro).equals(other$idCadastro)) {
            return false;
        }
        TipoCadastro this$tipoCadastro = this.getTipoCadastro();
        TipoCadastro other$tipoCadastro = other.getTipoCadastro();
        if (this$tipoCadastro == null ? other$tipoCadastro != null : !this$tipoCadastro.equals(other$tipoCadastro)) {
            return false;
        }
        Long this$cadastroGeral = this.getCadastroGeral();
        Long other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !((Object)this$cadastroGeral).equals(other$cadastroGeral)) {
            return false;
        }
        String this$cpfCnpj = this.getCpfCnpj();
        String other$cpfCnpj = other.getCpfCnpj();
        if (this$cpfCnpj == null ? other$cpfCnpj != null : !this$cpfCnpj.equals(other$cpfCnpj)) {
            return false;
        }
        String this$nome = this.getNome();
        String other$nome = other.getNome();
        if (this$nome == null ? other$nome != null : !this$nome.equals(other$nome)) {
            return false;
        }
        BigDecimal this$valorCalculado = this.getValorCalculado();
        BigDecimal other$valorCalculado = other.getValorCalculado();
        if (this$valorCalculado == null ? other$valorCalculado != null : !((Object)this$valorCalculado).equals(other$valorCalculado)) {
            return false;
        }
        BigDecimal this$valorDeducoes = this.getValorDeducoes();
        BigDecimal other$valorDeducoes = other.getValorDeducoes();
        if (this$valorDeducoes == null ? other$valorDeducoes != null : !((Object)this$valorDeducoes).equals(other$valorDeducoes)) {
            return false;
        }
        BigDecimal this$valorTotal = this.getValorTotal();
        BigDecimal other$valorTotal = other.getValorTotal();
        if (this$valorTotal == null ? other$valorTotal != null : !((Object)this$valorTotal).equals(other$valorTotal)) {
            return false;
        }
        Long this$divida = this.getDivida();
        Long other$divida = other.getDivida();
        if (this$divida == null ? other$divida != null : !((Object)this$divida).equals(other$divida)) {
            return false;
        }
        String this$descricaoDivida = this.getDescricaoDivida();
        String other$descricaoDivida = other.getDescricaoDivida();
        if (this$descricaoDivida == null ? other$descricaoDivida != null : !this$descricaoDivida.equals(other$descricaoDivida)) {
            return false;
        }
        Long this$idDebito = this.getIdDebito();
        Long other$idDebito = other.getIdDebito();
        if (this$idDebito == null ? other$idDebito != null : !((Object)this$idDebito).equals(other$idDebito)) {
            return false;
        }
        List this$resultados = this.getResultados();
        List other$resultados = other.getResultados();
        if (this$resultados == null ? other$resultados != null : !((Object)this$resultados).equals(other$resultados)) {
            return false;
        }
        List this$inconsistencias = this.getInconsistencias();
        List other$inconsistencias = other.getInconsistencias();
        return !(this$inconsistencias == null ? other$inconsistencias != null : !((Object)this$inconsistencias).equals(other$inconsistencias));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CalculoCadastroResumidoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $idCadastro = this.getIdCadastro();
        result = result * 59 + ($idCadastro == null ? 43 : ((Object)$idCadastro).hashCode());
        TipoCadastro $tipoCadastro = this.getTipoCadastro();
        result = result * 59 + ($tipoCadastro == null ? 43 : $tipoCadastro.hashCode());
        Long $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : ((Object)$cadastroGeral).hashCode());
        String $cpfCnpj = this.getCpfCnpj();
        result = result * 59 + ($cpfCnpj == null ? 43 : $cpfCnpj.hashCode());
        String $nome = this.getNome();
        result = result * 59 + ($nome == null ? 43 : $nome.hashCode());
        BigDecimal $valorCalculado = this.getValorCalculado();
        result = result * 59 + ($valorCalculado == null ? 43 : ((Object)$valorCalculado).hashCode());
        BigDecimal $valorDeducoes = this.getValorDeducoes();
        result = result * 59 + ($valorDeducoes == null ? 43 : ((Object)$valorDeducoes).hashCode());
        BigDecimal $valorTotal = this.getValorTotal();
        result = result * 59 + ($valorTotal == null ? 43 : ((Object)$valorTotal).hashCode());
        Long $divida = this.getDivida();
        result = result * 59 + ($divida == null ? 43 : ((Object)$divida).hashCode());
        String $descricaoDivida = this.getDescricaoDivida();
        result = result * 59 + ($descricaoDivida == null ? 43 : $descricaoDivida.hashCode());
        Long $idDebito = this.getIdDebito();
        result = result * 59 + ($idDebito == null ? 43 : ((Object)$idDebito).hashCode());
        List $resultados = this.getResultados();
        result = result * 59 + ($resultados == null ? 43 : ((Object)$resultados).hashCode());
        List $inconsistencias = this.getInconsistencias();
        result = result * 59 + ($inconsistencias == null ? 43 : ((Object)$inconsistencias).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CalculoCadastroResumidoDTO(id=" + this.getId() + ", idCadastro=" + this.getIdCadastro() + ", tipoCadastro=" + this.getTipoCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ", cpfCnpj=" + this.getCpfCnpj() + ", nome=" + this.getNome() + ", valorCalculado=" + this.getValorCalculado() + ", valorDeducoes=" + this.getValorDeducoes() + ", valorTotal=" + this.getValorTotal() + ", divida=" + this.getDivida() + ", descricaoDivida=" + this.getDescricaoDivida() + ", idDebito=" + this.getIdDebito() + ", resultados=" + this.getResultados() + ", inconsistencias=" + this.getInconsistencias() + ")";
    }
}

