/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.calculo.dto;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.calculo.dto.CadastroCalculoDTO;
import br.com.elotech.tributos.calculo.dto.CadastroIsencaoDTO;
import br.com.elotech.tributos.calculo.dto.CalculoContext;
import br.com.elotech.tributos.calculo.dto.CalculoResultadoDTO;
import br.com.elotech.tributos.calculo.dto.InconsistenciaCalculoDTO;
import br.com.elotech.tributos.domain.calculo.CalculoAvaliacao;
import br.com.elotech.tributos.domain.calculo.CalculoConfigBase;
import br.com.elotech.tributos.domain.calculo.CalculoTributo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class CadastroCalculoRoot {
    private Long id;
    private Long tipoCadastro;
    private Long cadastroGeral;
    private List<CadastroCalculoDTO> children = new ArrayList();
    private Map<CalculoTributo, CalculoResultadoDTO> resultado = new HashMap();
    private Map<CalculoAvaliacao, CalculoResultadoDTO> resultadoAvaliacao = new HashMap();
    private List<InconsistenciaCalculoDTO> inconsistencias = new ArrayList();
    private List<CadastroIsencaoDTO> isencoes = new ArrayList();

    public void addInconsistencia(CalculoConfigBase config, String mensagem) {
        InconsistenciaCalculoDTO inconsistencia = config.buildInconsistencia(mensagem);
        this.inconsistencias.add(inconsistencia);
    }

    public void addResultado(CalculoConfigBase config, CalculoContext context) {
        CalculoResultadoDTO resultadoDTO = CalculoResultadoDTO.from((CalculoConfigBase)config, (CalculoContext)context);
        if (config instanceof CalculoTributo) {
            this.resultado.put((CalculoTributo)config, resultadoDTO);
        } else if (config instanceof CalculoAvaliacao) {
            this.resultadoAvaliacao.put((CalculoAvaliacao)config, resultadoDTO);
        } else {
            throw new EloValidationException("Tipo de configura\u00e7\u00e3o de c\u00e1lculo n\u00e3o implementado ainda: " + config.getClass().getSimpleName());
        }
    }

    @Generated
    public CadastroCalculoRoot() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public List<CadastroCalculoDTO> getChildren() {
        return this.children;
    }

    @Generated
    public Map<CalculoTributo, CalculoResultadoDTO> getResultado() {
        return this.resultado;
    }

    @Generated
    public Map<CalculoAvaliacao, CalculoResultadoDTO> getResultadoAvaliacao() {
        return this.resultadoAvaliacao;
    }

    @Generated
    public List<InconsistenciaCalculoDTO> getInconsistencias() {
        return this.inconsistencias;
    }

    @Generated
    public List<CadastroIsencaoDTO> getIsencoes() {
        return this.isencoes;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setTipoCadastro(Long tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setChildren(List<CadastroCalculoDTO> children) {
        this.children = children;
    }

    @Generated
    public void setResultado(Map<CalculoTributo, CalculoResultadoDTO> resultado) {
        this.resultado = resultado;
    }

    @Generated
    public void setResultadoAvaliacao(Map<CalculoAvaliacao, CalculoResultadoDTO> resultadoAvaliacao) {
        this.resultadoAvaliacao = resultadoAvaliacao;
    }

    @Generated
    public void setInconsistencias(List<InconsistenciaCalculoDTO> inconsistencias) {
        this.inconsistencias = inconsistencias;
    }

    @Generated
    public void setIsencoes(List<CadastroIsencaoDTO> isencoes) {
        this.isencoes = isencoes;
    }

    @Generated
    public String toString() {
        return "CadastroCalculoRoot(id=" + this.getId() + ", tipoCadastro=" + this.getTipoCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ", children=" + this.getChildren() + ", resultado=" + this.getResultado() + ", resultadoAvaliacao=" + this.getResultadoAvaliacao() + ", inconsistencias=" + this.getInconsistencias() + ", isencoes=" + this.getIsencoes() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CadastroCalculoRoot)) {
            return false;
        }
        CadastroCalculoRoot other = (CadastroCalculoRoot)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$tipoCadastro = this.getTipoCadastro();
        Long other$tipoCadastro = other.getTipoCadastro();
        if (this$tipoCadastro == null ? other$tipoCadastro != null : !((Object)this$tipoCadastro).equals(other$tipoCadastro)) {
            return false;
        }
        Long this$cadastroGeral = this.getCadastroGeral();
        Long other$cadastroGeral = other.getCadastroGeral();
        return !(this$cadastroGeral == null ? other$cadastroGeral != null : !((Object)this$cadastroGeral).equals(other$cadastroGeral));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CadastroCalculoRoot;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $tipoCadastro = this.getTipoCadastro();
        result = result * 59 + ($tipoCadastro == null ? 43 : ((Object)$tipoCadastro).hashCode());
        Long $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : ((Object)$cadastroGeral).hashCode());
        return result;
    }
}

