/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.calculo.domain;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.MetaModelIgnore;
import br.com.elotech.tributos.calculo.domain.CalculoLinha;
import br.com.elotech.tributos.calculo.dto.VariavelDTO;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Optional;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import lombok.Generated;

@Table(name="calculotrace")
@Entity
public class CalculoTrace
implements EloEntity<Long> {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="seq_calculotrace")
    @SequenceGenerator(name="seq_calculotrace", sequenceName="seq_calculotrace")
    private Long id;
    @JsonIgnore
    @MetaModelIgnore
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="calculolinha", referencedColumnName="id")
    private CalculoLinha calculoLinha;
    private String identificador;
    private String valor;

    public static CalculoTrace from(CalculoLinha calculoLinha, VariavelDTO variavelDTO) {
        CalculoTrace calculoTrace = new CalculoTrace();
        calculoTrace.setCalculoLinha(calculoLinha);
        calculoTrace.setIdentificador(variavelDTO.getVariavel());
        Optional.ofNullable(variavelDTO.getValor()).map(Object::toString).ifPresent(arg_0 -> calculoTrace.setValor(arg_0));
        return calculoTrace;
    }

    @Generated
    public CalculoTrace() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public CalculoLinha getCalculoLinha() {
        return this.calculoLinha;
    }

    @Generated
    public String getIdentificador() {
        return this.identificador;
    }

    @Generated
    public String getValor() {
        return this.valor;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setCalculoLinha(CalculoLinha calculoLinha) {
        this.calculoLinha = calculoLinha;
    }

    @Generated
    public void setIdentificador(String identificador) {
        this.identificador = identificador;
    }

    @Generated
    public void setValor(String valor) {
        this.valor = valor;
    }

    @Generated
    public String toString() {
        return "CalculoTrace(id=" + this.getId() + ", calculoLinha=" + this.getCalculoLinha() + ", identificador=" + this.getIdentificador() + ", valor=" + this.getValor() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CalculoTrace)) {
            return false;
        }
        CalculoTrace other = (CalculoTrace)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CalculoTrace;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

