/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.calculo.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.calculo.domain.CalculoCadastro;
import br.com.elotech.tributos.calculo.domain.CalculoFormaPagamento;
import br.com.elotech.tributos.calculo.domain.SituacaoCalculo;
import br.com.elotech.tributos.calculo.domain.TipoCalculo;
import br.com.elotech.tributos.calculo.dto.CadastroCalculoRoot;
import br.com.elotech.tributos.domain.Divida;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.TipoDivida;
import br.com.elotech.tributos.domain.batch.BatchJobExecution;
import br.com.elotech.tributos.dto.CalculoFormaPagamentoDTO;
import br.com.elotech.tributos.util.MultiValueFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.annotations.Formula;

/*
 * Exception performing whole class analysis ignored.
 */
@Table(name="calculo")
@Entity
public class Calculo
implements EloEntity<Long> {
    @Id
    @EloSequence(sequenceName="seq_calculo")
    private Long id;
    @Enumerated(value=EnumType.STRING)
    private TipoCalculo tipo;
    @Enumerated(value=EnumType.STRING)
    private SituacaoCalculo situacao;
    @NotNull
    private Long exercicio;
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="calculo_divida", joinColumns={@JoinColumn(name="idcalculo")}, inverseJoinColumns={@JoinColumn(name="iddivida")})
    private List<Divida> dividas = new ArrayList();
    private TipoDivida tipoDivida;
    @Column(length=400)
    private String filtroCadastro;
    private LocalDate dataCalculo;
    private LocalDate dataLancamento;
    @Column(length=250)
    private String usuario;
    @Column(length=250)
    private String usuarioGeracaoDebito;
    private LocalDate dataGeracaoDebito;
    @Column(length=250)
    private String usuarioCancelamento;
    private LocalDate dataCancelamento;
    private Boolean constituido = Boolean.FALSE;
    @JsonIgnoreProperties(value={"calculo"})
    @OneToMany(orphanRemoval=true, cascade={CascadeType.ALL}, mappedBy="calculo")
    private List<CalculoCadastro> cadastros = new ArrayList();
    @JsonIgnore
    @OneToMany(orphanRemoval=true, cascade={CascadeType.ALL}, mappedBy="calculo")
    private List<CalculoFormaPagamento> formasPagamento = new ArrayList();
    @ManyToOne
    @JoinColumn(name="idjobsimulacao", referencedColumnName="job_execution_id")
    private BatchJobExecution batchJobExecutionSimulacao;
    @ManyToOne
    @JoinColumn(name="idjobdebito", referencedColumnName="job_execution_id")
    private BatchJobExecution batchJobExecutionDebito;
    @ManyToOne
    @JoinColumn(name="idjobcarne", referencedColumnName="job_execution_id")
    private BatchJobExecution batchJobExecutionCarne;
    @Formula(value="( select count(*) from calculocadastro calculocadastro where calculocadastro.calculo = id ) ")
    private Long totalCadastros;
    @Formula(value="( select count(*) from calculocadastro calculocadastro where calculocadastro.calculo = id  and exists (select 1              from calculoinconsistencia calculoinconsistencia             where calculoinconsistencia.calculocadastro = calculocadastro.id) )")
    private Long totalCadastrosComInconsistencia;

    public List<CalculoCadastro> parseResultados(List<CadastroCalculoRoot> result) {
        ArrayList<CalculoCadastro> resultadoPorCadastroDivida = new ArrayList<CalculoCadastro>();
        result.forEach(root -> this.getDividas().forEach(divida -> {
            CalculoCadastro cadastro = this.parseResultado(root, divida);
            if (Boolean.TRUE.equals(cadastro.calculou())) {
                resultadoPorCadastroDivida.add(cadastro);
            }
        }));
        return resultadoPorCadastroDivida;
    }

    private CalculoCadastro parseResultado(CadastroCalculoRoot root, Divida divida) {
        CalculoCadastro cadastro = CalculoCadastro.from((CadastroCalculoRoot)root, (Divida)divida);
        cadastro.setCalculo(this);
        return cadastro;
    }

    public String filterCadastrosInconsistentes() {
        return this.getCadastros().stream().filter(calculoCadastro -> Objects.nonNull(calculoCadastro.getCadastro()) && calculoCadastro.hasInconsistencia() != false).map(calculoCadastro -> calculoCadastro.getCadastro().getId().toString()).collect(Collectors.joining(","));
    }

    public String buildFilterCadastrosById(String cadastros) {
        return MultiValueFilter.generateFilters((String)cadastros, (String)"cadastrogeral.idkey");
    }

    public String buildFilterCadastros() {
        return this.buildFilterCadastros(this.getFiltroCadastro());
    }

    public String buildFilterCadastros(String cadastrosFiltrados) {
        StringBuilder filtro = new StringBuilder();
        filtro.append(MultiValueFilter.generateFilters((String)cadastrosFiltrados, (String)"cadastrogeral.cadastrogeral"));
        if (TipoCadastro.IMOBILIARIO.equals((Object)Calculo.getTipoCadastroByTipoDivida((TipoDivida)this.tipoDivida))) {
            filtro.append(" and cadastrogeral.tipocadastro = 1");
        } else if (TipoCadastro.MOBILIARIO.equals((Object)Calculo.getTipoCadastroByTipoDivida((TipoDivida)this.tipoDivida))) {
            filtro.append(" and cadastrogeral.tipocadastro = 2");
        }
        return filtro.toString();
    }

    public static TipoCadastro getTipoCadastroByTipoDivida(TipoDivida tipoDivida) {
        if (tipoDivida.equals((Object)TipoDivida.IPTU)) {
            return TipoCadastro.IMOBILIARIO;
        }
        if (TipoDivida.ISS_FIXO.equals((Object)tipoDivida) || TipoDivida.ALVARA.equals((Object)tipoDivida)) {
            return TipoCadastro.MOBILIARIO;
        }
        throw new EloValidationException(String.format("N\u00e3o h\u00e1 implementa\u00e7\u00e3o de c\u00e1lculo para o tipo de d\u00edvida %s.", tipoDivida));
    }

    public String getFiltroDivida() {
        return this.dividas.stream().sorted(Comparator.comparing(Divida::getDivida)).map(divida -> divida.getDivida().toString()).collect(Collectors.joining(", "));
    }

    @JsonIgnore
    public boolean getNecessitaConfigurarFormasPagamento() {
        return SituacaoCalculo.LOTE_GERADO.equals((Object)this.getSituacao()) && this.getFormasPagamento().isEmpty();
    }

    public void replaceAllCalculoFormaPagamento(List<CalculoFormaPagamentoDTO> formasPagamento) {
        this.getFormasPagamento().clear();
        formasPagamento.forEach(formaPagamentoDTO -> this.getFormasPagamento().add(formaPagamentoDTO.toEntity(this)));
    }

    @Generated
    public Calculo() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public TipoCalculo getTipo() {
        return this.tipo;
    }

    @Generated
    public SituacaoCalculo getSituacao() {
        return this.situacao;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public List<Divida> getDividas() {
        return this.dividas;
    }

    @Generated
    public TipoDivida getTipoDivida() {
        return this.tipoDivida;
    }

    @Generated
    public String getFiltroCadastro() {
        return this.filtroCadastro;
    }

    @Generated
    public LocalDate getDataCalculo() {
        return this.dataCalculo;
    }

    @Generated
    public LocalDate getDataLancamento() {
        return this.dataLancamento;
    }

    @Generated
    public String getUsuario() {
        return this.usuario;
    }

    @Generated
    public String getUsuarioGeracaoDebito() {
        return this.usuarioGeracaoDebito;
    }

    @Generated
    public LocalDate getDataGeracaoDebito() {
        return this.dataGeracaoDebito;
    }

    @Generated
    public String getUsuarioCancelamento() {
        return this.usuarioCancelamento;
    }

    @Generated
    public LocalDate getDataCancelamento() {
        return this.dataCancelamento;
    }

    @Generated
    public Boolean getConstituido() {
        return this.constituido;
    }

    @Generated
    public List<CalculoCadastro> getCadastros() {
        return this.cadastros;
    }

    @Generated
    public List<CalculoFormaPagamento> getFormasPagamento() {
        return this.formasPagamento;
    }

    @Generated
    public BatchJobExecution getBatchJobExecutionSimulacao() {
        return this.batchJobExecutionSimulacao;
    }

    @Generated
    public BatchJobExecution getBatchJobExecutionDebito() {
        return this.batchJobExecutionDebito;
    }

    @Generated
    public BatchJobExecution getBatchJobExecutionCarne() {
        return this.batchJobExecutionCarne;
    }

    @Generated
    public Long getTotalCadastros() {
        return this.totalCadastros;
    }

    @Generated
    public Long getTotalCadastrosComInconsistencia() {
        return this.totalCadastrosComInconsistencia;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setTipo(TipoCalculo tipo) {
        this.tipo = tipo;
    }

    @Generated
    public void setSituacao(SituacaoCalculo situacao) {
        this.situacao = situacao;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setDividas(List<Divida> dividas) {
        this.dividas = dividas;
    }

    @Generated
    public void setTipoDivida(TipoDivida tipoDivida) {
        this.tipoDivida = tipoDivida;
    }

    @Generated
    public void setFiltroCadastro(String filtroCadastro) {
        this.filtroCadastro = filtroCadastro;
    }

    @Generated
    public void setDataCalculo(LocalDate dataCalculo) {
        this.dataCalculo = dataCalculo;
    }

    @Generated
    public void setDataLancamento(LocalDate dataLancamento) {
        this.dataLancamento = dataLancamento;
    }

    @Generated
    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    @Generated
    public void setUsuarioGeracaoDebito(String usuarioGeracaoDebito) {
        this.usuarioGeracaoDebito = usuarioGeracaoDebito;
    }

    @Generated
    public void setDataGeracaoDebito(LocalDate dataGeracaoDebito) {
        this.dataGeracaoDebito = dataGeracaoDebito;
    }

    @Generated
    public void setUsuarioCancelamento(String usuarioCancelamento) {
        this.usuarioCancelamento = usuarioCancelamento;
    }

    @Generated
    public void setDataCancelamento(LocalDate dataCancelamento) {
        this.dataCancelamento = dataCancelamento;
    }

    @Generated
    public void setConstituido(Boolean constituido) {
        this.constituido = constituido;
    }

    @Generated
    public void setCadastros(List<CalculoCadastro> cadastros) {
        this.cadastros = cadastros;
    }

    @Generated
    public void setFormasPagamento(List<CalculoFormaPagamento> formasPagamento) {
        this.formasPagamento = formasPagamento;
    }

    @Generated
    public void setBatchJobExecutionSimulacao(BatchJobExecution batchJobExecutionSimulacao) {
        this.batchJobExecutionSimulacao = batchJobExecutionSimulacao;
    }

    @Generated
    public void setBatchJobExecutionDebito(BatchJobExecution batchJobExecutionDebito) {
        this.batchJobExecutionDebito = batchJobExecutionDebito;
    }

    @Generated
    public void setBatchJobExecutionCarne(BatchJobExecution batchJobExecutionCarne) {
        this.batchJobExecutionCarne = batchJobExecutionCarne;
    }

    @Generated
    public void setTotalCadastros(Long totalCadastros) {
        this.totalCadastros = totalCadastros;
    }

    @Generated
    public void setTotalCadastrosComInconsistencia(Long totalCadastrosComInconsistencia) {
        this.totalCadastrosComInconsistencia = totalCadastrosComInconsistencia;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Calculo)) {
            return false;
        }
        Calculo other = (Calculo)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Calculo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Calculo(id=" + this.getId() + ")";
    }
}

